/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import java.util.List;
import java.util.Map;

public class EMAChatRoom extends EMABase {

	public enum EMAChatRoomStyle {
		EMAChatRoomStylePrivateOnlyOwnerInvite,         /*! *\~chinese 私有群组，创建完成后，只允许Owner邀请用户加入 *\~english Private groups, after created, only allowing owner invite users to join */
		EMAChatRoomStylePrivateMemberCanInvite,         /*! *\~chinese 私有群组，创建完成后，只允许Owner和群成员邀请用户加入 *\~english Private groups, after created, only allowing owner and members invite users to join  */
		EMAChatRoomStylePublicJoinNeedApproval,         /*! *\~chinese 公开群组，创建完成后，只允许Owner邀请用户加入; 非群成员用户需发送入群申请，Owner同意后才能入组 *\~english Public groups, after created, only allowing owner invite users to join; Non-group members into the group must send an application to the owner after the Owner agree */
		EMAChatRoomStylePublicOpenJoin                  /*! *\~chinese 公开群组，创建完成后，允许非群组成员加入，不需要Owner同意 *\~english Public groups, after created, to allow non-members to join the group, does not require owner agrees */
	}
	
	public final static int EMChatroomLeaveReason_BE_KICKED = 0;
	public final static int EMChatroomLeaveReason_DESTROYED = 1;
	
	public enum EMLeaveReason {
		BE_KICKED,
		DESTROYED
	}
	
	public EMAChatRoom(EMAChatRoom room) {
		nativeInit(room);
	}
	
	public EMAChatRoom(String roomId) {
		nativeInit(roomId);
	}
	
    public String getId() {
    	return nativeChatroomId();
    }
    native String nativeChatroomId();

    public String getName() {
    	return nativeChatroomSubject();
    }
    native String nativeChatroomSubject();

    public String getDescription() {
    	return nativeChatroomDescription();
	}
    native String nativeChatroomDescription();
 
	public EMAChatRoom() {
		nativeInit();
	}
	
	public String getOwner() {
		return nativegetOwner();
	}
	native String nativegetOwner();

	public List<String> getAdministratorList() {
		return nativeGetAdministratorList();
	}
	native List<String> nativeGetAdministratorList();
	
	public int getAffiliationsCount() {
		return nativegetAffiliationsCount();
	}
	native int nativegetAffiliationsCount();
	
	public List<String> getMemberList(){
	    return nativegetMemberList();
	}
	native List<String> nativegetMemberList();

	public int getMaxUserCount() {
		return nativegetMaxUserCount();
	}
	native int nativegetMaxUserCount();

	public List<String> getBlockList() {
		return nativeGetBlockList();
	}
	native List<String> nativeGetBlockList();

	public Map<String, Long> getMuteList() {
		return nativeGetMuteList();
	}
	native Map<String, Long> nativeGetMuteList();

	@Override
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}
	
	native void nativeInit();
	native void nativeInit(EMAChatRoom room);
	native void nativeInit(String id);
	native void nativeFinalize();
}
