/*
 * Decompiled with CFR 0.152.
 */
package internal.org.apache.http.entity.mime.content;

import internal.org.apache.http.entity.mime.content.AbstractContentBody;
import java.io.IOException;
import java.io.OutputStream;

public class ByteArrayBody
extends AbstractContentBody {
    private final byte[] data;
    private final String filename;

    public ByteArrayBody(byte[] byArray, String string, String string2) {
        super(string);
        if (byArray == null) {
            throw new IllegalArgumentException("byte[] may not be null");
        }
        this.data = byArray;
        this.filename = string2;
    }

    public ByteArrayBody(byte[] byArray, String string) {
        this(byArray, "application/octet-stream", string);
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.data);
    }

    @Override
    public String getCharset() {
        return null;
    }

    @Override
    public String getTransferEncoding() {
        return "binary";
    }

    @Override
    public long getContentLength() {
        return this.data.length;
    }
}

