/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.SystemClock;
import android.view.Surface;
import com.superrtc.call.Logging;
import com.superrtc.call.MediaCodecVideoEncoder;
import com.superrtc.call.SurfaceTextureHelper;
import com.superrtc.call.ThreadUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class MediaCodecVideoDecoder {
    private static final String TAG = "MediaCodecVideoDecoder";
    private static final long MAX_DECODE_TIME_MS = 200L;
    private static final int DEQUEUE_INPUT_TIMEOUT = 500000;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int MAX_QUEUED_OUTPUTBUFFERS = 3;
    private static MediaCodecVideoDecoder runningInstance = null;
    private static MediaCodecVideoDecoderErrorCallback errorCallback = null;
    private static int codecErrors = 0;
    private static Set<String> hwDecoderDisabledTypes = new HashSet<String>();
    private Thread mediaCodecThread;
    private MediaCodec mediaCodec;
    private ByteBuffer[] inputBuffers;
    private ByteBuffer[] outputBuffers;
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static final String H264_MIME_TYPE = "video/avc";
    private static final String[] supportedVp8HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Nvidia.", "OMX.Exynos.", "OMX.Intel."};
    private static final String[] supportedVp9HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Exynos."};
    private static final String[] supportedH264HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Intel.", "OMX.hisi."};
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final List<Integer> supportedColorList = Arrays.asList(19, 21, 2141391872, 2141391876, 17);
    private int colorFormat;
    private int width;
    private int height;
    private int stride;
    private int sliceHeight;
    private boolean hasDecodedFirstFrame;
    private final Queue<TimeStamps> decodeStartTimeMs = new LinkedList<TimeStamps>();
    private boolean useSurface;
    private TextureListener textureListener;
    private int droppedFrames;
    private Surface surface = null;
    private final Queue<DecodedOutputBuffer> dequeuedSurfaceOutputBuffers = new LinkedList<DecodedOutputBuffer>();

    public static void setErrorCallback(MediaCodecVideoDecoderErrorCallback mediaCodecVideoDecoderErrorCallback) {
        Logging.d(TAG, "Set error callback");
        errorCallback = mediaCodecVideoDecoderErrorCallback;
    }

    public static void disableVp8HwCodec() {
        Logging.w(TAG, "VP8 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Logging.w(TAG, "VP9 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        Logging.w(TAG, "H.264 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static boolean isVp8HwSupported() {
        return !hwDecoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP8_MIME_TYPE, supportedVp8HwCodecPrefixes) != null;
    }

    public static boolean isVp9HwSupported() {
        return !hwDecoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes) != null;
    }

    public static boolean isH264HwSupported() {
        return !hwDecoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, supportedH264HwCodecPrefixes) != null;
    }

    public static void printStackTrace() {
        StackTraceElement[] stackTraceElementArray;
        if (runningInstance != null && MediaCodecVideoDecoder.runningInstance.mediaCodecThread != null && (stackTraceElementArray = MediaCodecVideoDecoder.runningInstance.mediaCodecThread.getStackTrace()).length > 0) {
            Logging.d(TAG, "MediaCodecVideoDecoder stacks trace:");
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray2[n2];
                Logging.d(TAG, stackTraceElement.toString());
                ++n2;
            }
        }
    }

    private static DecoderProperties findDecoder(String string, String[] stringArray) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        Logging.d(TAG, "Trying to find HW decoder for mime " + string);
        int n = 0;
        while (n < MediaCodecList.getCodecCount()) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)n);
            if (!mediaCodecInfo.isEncoder()) {
                String string2 = null;
                String[] stringArray2 = mediaCodecInfo.getSupportedTypes();
                int n22 = stringArray2.length;
                int n3 = 0;
                while (n3 < n22) {
                    String string3 = stringArray2[n3];
                    if (string3.equals(string)) {
                        string2 = mediaCodecInfo.getName();
                        break;
                    }
                    ++n3;
                }
                if (string2 != null) {
                    Logging.d(TAG, "Found candidate decoder " + string2);
                    boolean bl = false;
                    String[] stringArray3 = stringArray;
                    int n4 = stringArray.length;
                    n22 = 0;
                    while (n22 < n4) {
                        String string4 = stringArray3[n22];
                        if (string2.startsWith(string4)) {
                            bl = true;
                            break;
                        }
                        ++n22;
                    }
                    Logging.d(TAG, "hw decoder supportedCodec  = " + bl);
                    if (bl) {
                        MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(string);
                        int[] nArray = codecCapabilities.colorFormats;
                        int n5 = codecCapabilities.colorFormats.length;
                        n4 = 0;
                        while (n4 < n5) {
                            n22 = nArray[n4];
                            Logging.v(TAG, "   Color: 0x" + Integer.toHexString(n22));
                            ++n4;
                        }
                        for (int n22 : supportedColorList) {
                            int[] nArray2 = codecCapabilities.colorFormats;
                            int n6 = codecCapabilities.colorFormats.length;
                            int n7 = 0;
                            while (n7 < n6) {
                                n5 = nArray2[n7];
                                if (n5 == n22) {
                                    Logging.d(TAG, "Found target decoder " + string2 + ". Color: 0x" + Integer.toHexString(n5));
                                    return new DecoderProperties(string2, n5);
                                }
                                ++n7;
                            }
                        }
                    }
                }
            }
            ++n;
        }
        Logging.d(TAG, "No HW decoder found for mime " + string);
        return null;
    }

    private void checkOnMediaCodecThread() throws IllegalStateException {
        if (this.mediaCodecThread.getId() != Thread.currentThread().getId()) {
            throw new IllegalStateException("MediaCodecVideoDecoder previously operated on " + this.mediaCodecThread + " but is now called on " + Thread.currentThread());
        }
    }

    private boolean initDecode(VideoCodecType videoCodecType, int n, int n2, SurfaceTextureHelper surfaceTextureHelper) {
        MediaFormat mediaFormat;
        DecoderProperties decoderProperties;
        block13: {
            if (this.mediaCodecThread != null) {
                throw new RuntimeException("initDecode: Forgot to release()?");
            }
            String string = null;
            this.useSurface = surfaceTextureHelper != null;
            String[] stringArray = null;
            if (videoCodecType == VideoCodecType.VIDEO_CODEC_VP8) {
                string = VP8_MIME_TYPE;
                stringArray = supportedVp8HwCodecPrefixes;
            } else if (videoCodecType == VideoCodecType.VIDEO_CODEC_VP9) {
                string = VP9_MIME_TYPE;
                stringArray = supportedVp9HwCodecPrefixes;
            } else if (videoCodecType == VideoCodecType.VIDEO_CODEC_H264) {
                string = H264_MIME_TYPE;
                stringArray = supportedH264HwCodecPrefixes;
            } else {
                throw new RuntimeException("initDecode: Non-supported codec " + (Object)((Object)videoCodecType));
            }
            decoderProperties = MediaCodecVideoDecoder.findDecoder(string, stringArray);
            if (decoderProperties == null) {
                throw new RuntimeException("Cannot find HW decoder for " + (Object)((Object)videoCodecType));
            }
            Logging.d(TAG, "Java initDecode: " + (Object)((Object)videoCodecType) + " : " + n + " x " + n2 + ". Color: 0x" + Integer.toHexString(decoderProperties.colorFormat) + ". Use Surface: " + this.useSurface);
            runningInstance = this;
            this.mediaCodecThread = Thread.currentThread();
            try {
                this.width = n;
                this.height = n2;
                this.stride = n;
                this.sliceHeight = n2;
                if (this.useSurface) {
                    this.textureListener = new TextureListener(surfaceTextureHelper);
                    this.surface = new Surface(surfaceTextureHelper.getSurfaceTexture());
                }
                mediaFormat = MediaFormat.createVideoFormat((String)string, (int)n, (int)n2);
                if (!this.useSurface) {
                    mediaFormat.setInteger("color-format", decoderProperties.colorFormat);
                }
                Logging.d(TAG, "  Format: " + mediaFormat);
                this.mediaCodec = MediaCodecVideoEncoder.createByCodecName(decoderProperties.codecName);
                if (this.mediaCodec != null) break block13;
                Logging.e(TAG, "Can not create media decoder");
                return false;
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(TAG, "initDecode failed", illegalStateException);
                return false;
            }
        }
        this.mediaCodec.configure(mediaFormat, this.surface, null, 0);
        this.mediaCodec.start();
        this.colorFormat = decoderProperties.colorFormat;
        this.outputBuffers = this.mediaCodec.getOutputBuffers();
        this.inputBuffers = this.mediaCodec.getInputBuffers();
        this.decodeStartTimeMs.clear();
        this.hasDecodedFirstFrame = false;
        this.dequeuedSurfaceOutputBuffers.clear();
        this.droppedFrames = 0;
        Logging.d(TAG, "Input buffers: " + this.inputBuffers.length + ". Output buffers: " + this.outputBuffers.length);
        return true;
    }

    private void reset(int n, int n2) {
        if (this.mediaCodecThread == null || this.mediaCodec == null) {
            throw new RuntimeException("Incorrect reset call for non-initialized decoder.");
        }
        Logging.d(TAG, "Java reset: " + n + " x " + n2);
        this.mediaCodec.flush();
        this.width = n;
        this.height = n2;
        this.decodeStartTimeMs.clear();
        this.dequeuedSurfaceOutputBuffers.clear();
        this.hasDecodedFirstFrame = false;
        this.droppedFrames = 0;
    }

    private void release() {
        Logging.d(TAG, "Java releaseDecoder. Total number of dropped frames: " + this.droppedFrames);
        this.checkOnMediaCodecThread();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Logging.d(MediaCodecVideoDecoder.TAG, "Java releaseDecoder on release thread");
                    MediaCodecVideoDecoder.this.mediaCodec.stop();
                    MediaCodecVideoDecoder.this.mediaCodec.release();
                    Logging.d(MediaCodecVideoDecoder.TAG, "Java releaseDecoder on release thread done");
                }
                catch (Exception exception) {
                    Logging.e(MediaCodecVideoDecoder.TAG, "Media decoder release failed", exception);
                }
                countDownLatch.countDown();
            }
        };
        new Thread(runnable).start();
        if (!ThreadUtils.awaitUninterruptibly(countDownLatch, 5000L)) {
            Logging.e(TAG, "Media decoder release timeout");
            ++codecErrors;
            if (errorCallback != null) {
                Logging.e(TAG, "Invoke codec error callback. Errors: " + codecErrors);
                errorCallback.onMediaCodecVideoDecoderCriticalError(codecErrors);
            }
        }
        this.mediaCodec = null;
        this.mediaCodecThread = null;
        runningInstance = null;
        if (this.useSurface) {
            this.surface.release();
            this.surface = null;
            this.textureListener.release();
        }
        Logging.d(TAG, "Java releaseDecoder done");
    }

    private int dequeueInputBuffer() {
        this.checkOnMediaCodecThread();
        try {
            return this.mediaCodec.dequeueInputBuffer(500000L);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueIntputBuffer failed", illegalStateException);
            return -2;
        }
    }

    private boolean queueInputBuffer(int n, int n2, long l, long l2, long l3) {
        this.checkOnMediaCodecThread();
        try {
            this.inputBuffers[n].position(0);
            this.inputBuffers[n].limit(n2);
            this.decodeStartTimeMs.add(new TimeStamps(SystemClock.elapsedRealtime(), l2, l3));
            this.mediaCodec.queueInputBuffer(n, 0, n2, l, 0);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "decode failed", illegalStateException);
            return false;
        }
    }

    private DecodedOutputBuffer dequeueOutputBuffer(int n) {
        int n2;
        this.checkOnMediaCodecThread();
        if (this.decodeStartTimeMs.isEmpty()) {
            return null;
        }
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        block5: while (true) {
            n2 = this.mediaCodec.dequeueOutputBuffer(bufferInfo, TimeUnit.MILLISECONDS.toMicros(n));
            switch (n2) {
                case -3: {
                    this.outputBuffers = this.mediaCodec.getOutputBuffers();
                    Logging.d(TAG, "Decoder output buffers changed: " + this.outputBuffers.length);
                    if (!this.hasDecodedFirstFrame) continue block5;
                    throw new RuntimeException("Unexpected output buffer change event.");
                }
                case -2: {
                    MediaFormat mediaFormat = this.mediaCodec.getOutputFormat();
                    Logging.d(TAG, "Decoder format changed: " + mediaFormat.toString());
                    int n3 = mediaFormat.getInteger("width");
                    int n4 = mediaFormat.getInteger("height");
                    if (this.hasDecodedFirstFrame && (n3 != this.width || n4 != this.height)) {
                        throw new RuntimeException("Unexpected size change. Configured " + this.width + "*" + this.height + ". New " + n3 + "*" + n4);
                    }
                    this.width = mediaFormat.getInteger("width");
                    this.height = mediaFormat.getInteger("height");
                    if (!this.useSurface && mediaFormat.containsKey("color-format")) {
                        this.colorFormat = mediaFormat.getInteger("color-format");
                        Logging.d(TAG, "Color: 0x" + Integer.toHexString(this.colorFormat));
                        if (!supportedColorList.contains(this.colorFormat)) {
                            throw new IllegalStateException("Non supported color format: " + this.colorFormat);
                        }
                    }
                    if (mediaFormat.containsKey("stride")) {
                        this.stride = mediaFormat.getInteger("stride");
                    }
                    if (mediaFormat.containsKey("slice-height")) {
                        this.sliceHeight = mediaFormat.getInteger("slice-height");
                    }
                    Logging.d(TAG, "Frame stride and slice height: " + this.stride + " x " + this.sliceHeight);
                    this.stride = Math.max(this.width, this.stride);
                    this.sliceHeight = Math.max(this.height, this.sliceHeight);
                    continue block5;
                }
                case -1: {
                    return null;
                }
            }
            break;
        }
        this.hasDecodedFirstFrame = true;
        TimeStamps timeStamps = this.decodeStartTimeMs.remove();
        long l = SystemClock.elapsedRealtime() - timeStamps.decodeStartTimeMs;
        if (l > 200L) {
            Logging.e(TAG, "Very high decode time: " + l + "ms." + " Might be caused by resuming H264 decoding after a pause.");
            l = 200L;
        }
        return new DecodedOutputBuffer(n2, bufferInfo.offset, bufferInfo.size, TimeUnit.MICROSECONDS.toMillis(bufferInfo.presentationTimeUs), timeStamps.timeStampMs, timeStamps.ntpTimeStampMs, l, SystemClock.elapsedRealtime());
    }

    private DecodedTextureBuffer dequeueTextureBuffer(int n) {
        this.checkOnMediaCodecThread();
        if (!this.useSurface) {
            throw new IllegalStateException("dequeueTexture() called for byte buffer decoding.");
        }
        DecodedOutputBuffer decodedOutputBuffer = this.dequeueOutputBuffer(n);
        if (decodedOutputBuffer != null) {
            this.dequeuedSurfaceOutputBuffers.add(decodedOutputBuffer);
        }
        this.MaybeRenderDecodedTextureBuffer();
        DecodedTextureBuffer decodedTextureBuffer = this.textureListener.dequeueTextureBuffer(n);
        if (decodedTextureBuffer != null) {
            this.MaybeRenderDecodedTextureBuffer();
            return decodedTextureBuffer;
        }
        if (this.dequeuedSurfaceOutputBuffers.size() >= Math.min(3, this.outputBuffers.length) || n > 0 && !this.dequeuedSurfaceOutputBuffers.isEmpty()) {
            ++this.droppedFrames;
            DecodedOutputBuffer decodedOutputBuffer2 = this.dequeuedSurfaceOutputBuffers.remove();
            if (n > 0) {
                Logging.w(TAG, "Draining decoder. Dropping frame with TS: " + decodedOutputBuffer2.presentationTimeStampMs + ". Total number of dropped frames: " + this.droppedFrames);
            } else {
                Logging.w(TAG, "Too many output buffers " + this.dequeuedSurfaceOutputBuffers.size() + ". Dropping frame with TS: " + decodedOutputBuffer2.presentationTimeStampMs + ". Total number of dropped frames: " + this.droppedFrames);
            }
            this.mediaCodec.releaseOutputBuffer(decodedOutputBuffer2.index, false);
            return new DecodedTextureBuffer(0, null, decodedOutputBuffer2.presentationTimeStampMs, decodedOutputBuffer2.timeStampMs, decodedOutputBuffer2.ntpTimeStampMs, decodedOutputBuffer2.decodeTimeMs, SystemClock.elapsedRealtime() - decodedOutputBuffer2.endDecodeTimeMs);
        }
        return null;
    }

    private void MaybeRenderDecodedTextureBuffer() {
        if (this.dequeuedSurfaceOutputBuffers.isEmpty() || this.textureListener.isWaitingForTexture()) {
            return;
        }
        DecodedOutputBuffer decodedOutputBuffer = this.dequeuedSurfaceOutputBuffers.remove();
        this.textureListener.addBufferToRender(decodedOutputBuffer);
        this.mediaCodec.releaseOutputBuffer(decodedOutputBuffer.index, true);
    }

    private void returnDecodedOutputBuffer(int n) throws IllegalStateException, MediaCodec.CodecException {
        this.checkOnMediaCodecThread();
        if (this.useSurface) {
            throw new IllegalStateException("returnDecodedOutputBuffer() called for surface decoding.");
        }
        this.mediaCodec.releaseOutputBuffer(n, false);
    }

    private static class DecodedOutputBuffer {
        private final int index;
        private final int offset;
        private final int size;
        private final long presentationTimeStampMs;
        private final long timeStampMs;
        private final long ntpTimeStampMs;
        private final long decodeTimeMs;
        private final long endDecodeTimeMs;

        public DecodedOutputBuffer(int n, int n2, int n3, long l, long l2, long l3, long l4, long l5) {
            this.index = n;
            this.offset = n2;
            this.size = n3;
            this.presentationTimeStampMs = l;
            this.timeStampMs = l2;
            this.ntpTimeStampMs = l3;
            this.decodeTimeMs = l4;
            this.endDecodeTimeMs = l5;
        }
    }

    private static class DecodedTextureBuffer {
        private final int textureID;
        private final float[] transformMatrix;
        private final long presentationTimeStampMs;
        private final long timeStampMs;
        private final long ntpTimeStampMs;
        private final long decodeTimeMs;
        private final long frameDelayMs;

        public DecodedTextureBuffer(int n, float[] fArray, long l, long l2, long l3, long l4, long l5) {
            this.textureID = n;
            this.transformMatrix = fArray;
            this.presentationTimeStampMs = l;
            this.timeStampMs = l2;
            this.ntpTimeStampMs = l3;
            this.decodeTimeMs = l4;
            this.frameDelayMs = l5;
        }
    }

    private static class DecoderProperties {
        public final String codecName;
        public final int colorFormat;

        public DecoderProperties(String string, int n) {
            this.codecName = string;
            this.colorFormat = n;
        }
    }

    public static interface MediaCodecVideoDecoderErrorCallback {
        public void onMediaCodecVideoDecoderCriticalError(int var1);
    }

    private static class TextureListener
    implements SurfaceTextureHelper.OnTextureFrameAvailableListener {
        private final SurfaceTextureHelper surfaceTextureHelper;
        private final Object newFrameLock = new Object();
        private DecodedOutputBuffer bufferToRender;
        private DecodedTextureBuffer renderedBuffer;

        public TextureListener(SurfaceTextureHelper surfaceTextureHelper) {
            this.surfaceTextureHelper = surfaceTextureHelper;
            surfaceTextureHelper.startListening(this);
        }

        public void addBufferToRender(DecodedOutputBuffer decodedOutputBuffer) {
            if (this.bufferToRender != null) {
                Logging.e(MediaCodecVideoDecoder.TAG, "Unexpected addBufferToRender() called while waiting for a texture.");
                throw new IllegalStateException("Waiting for a texture.");
            }
            this.bufferToRender = decodedOutputBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isWaitingForTexture() {
            Object object = this.newFrameLock;
            synchronized (object) {
                return this.bufferToRender != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTextureFrameAvailable(int n, float[] fArray, long l) {
            Object object = this.newFrameLock;
            synchronized (object) {
                if (this.renderedBuffer != null) {
                    Logging.e(MediaCodecVideoDecoder.TAG, "Unexpected onTextureFrameAvailable() called while already holding a texture.");
                    throw new IllegalStateException("Already holding a texture.");
                }
                this.renderedBuffer = new DecodedTextureBuffer(n, fArray, this.bufferToRender.presentationTimeStampMs, this.bufferToRender.timeStampMs, this.bufferToRender.ntpTimeStampMs, this.bufferToRender.decodeTimeMs, SystemClock.elapsedRealtime() - this.bufferToRender.endDecodeTimeMs);
                this.bufferToRender = null;
                this.newFrameLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DecodedTextureBuffer dequeueTextureBuffer(int n) {
            Object object = this.newFrameLock;
            synchronized (object) {
                if (this.renderedBuffer == null && n > 0 && this.isWaitingForTexture()) {
                    try {
                        this.newFrameLock.wait(n);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                DecodedTextureBuffer decodedTextureBuffer = this.renderedBuffer;
                this.renderedBuffer = null;
                return decodedTextureBuffer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            this.surfaceTextureHelper.dispose();
            Object object = this.newFrameLock;
            synchronized (object) {
                if (this.renderedBuffer != null) {
                    this.surfaceTextureHelper.returnTextureFrame();
                    this.renderedBuffer = null;
                }
            }
        }
    }

    private static class TimeStamps {
        private final long decodeStartTimeMs;
        private final long timeStampMs;
        private final long ntpTimeStampMs;

        public TimeStamps(long l, long l2, long l3) {
            this.decodeStartTimeMs = l;
            this.timeStampMs = l2;
            this.ntpTimeStampMs = l3;
        }
    }

    public static enum VideoCodecType {
        VIDEO_CODEC_VP8,
        VIDEO_CODEC_VP9,
        VIDEO_CODEC_H264;

    }
}

