/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import android.hardware.Camera;
import android.os.SystemClock;
import com.superrtc.call.CameraEnumerationAndroid;
import com.superrtc.call.Logging;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CameraEnumerator
implements CameraEnumerationAndroid.Enumerator {
    private static final String TAG = "CameraEnumerator";
    private List<List<CameraEnumerationAndroid.CaptureFormat>> cachedSupportedFormats;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(int n) {
        CameraEnumerator cameraEnumerator = this;
        synchronized (cameraEnumerator) {
            if (this.cachedSupportedFormats == null) {
                this.cachedSupportedFormats = new ArrayList<List<CameraEnumerationAndroid.CaptureFormat>>();
                int n2 = 0;
                while (n2 < CameraEnumerationAndroid.getDeviceCount()) {
                    this.cachedSupportedFormats.add(this.enumerateFormats(n2));
                    ++n2;
                }
            }
        }
        return this.cachedSupportedFormats.get(n);
    }

    private List<CameraEnumerationAndroid.CaptureFormat> enumerateFormats(int n) {
        Camera.Parameters parameters;
        Logging.d(TAG, "Get supported formats for camera index " + n + ".");
        long l = SystemClock.elapsedRealtime();
        Camera camera = null;
        try {
            try {
                Logging.d(TAG, "Opening camera with index " + n);
                camera = Camera.open((int)n);
                parameters = camera.getParameters();
            }
            catch (RuntimeException runtimeException) {
                Logging.e(TAG, "Open camera failed on camera index " + n, runtimeException);
                ArrayList<CameraEnumerationAndroid.CaptureFormat> arrayList = new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
                if (camera != null) {
                    camera.release();
                }
                return arrayList;
            }
        }
        finally {
            if (camera != null) {
                camera.release();
            }
        }
        ArrayList<CameraEnumerationAndroid.CaptureFormat> arrayList = new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
        try {
            Object object;
            int n2 = 0;
            int n3 = 0;
            List list = parameters.getSupportedPreviewFpsRange();
            if (list != null) {
                object = (int[])list.get(list.size() - 1);
                n2 = object[0];
                n3 = object[1];
            }
            Iterator iterator = parameters.getSupportedPreviewSizes().iterator();
            while (iterator.hasNext()) {
                object = (Camera.Size)iterator.next();
                arrayList.add(new CameraEnumerationAndroid.CaptureFormat(object.width, object.height, n2, n3));
            }
        }
        catch (Exception exception) {
            Logging.e(TAG, "getSupportedFormats() failed on camera index " + n, exception);
        }
        long l2 = SystemClock.elapsedRealtime();
        Logging.d(TAG, "Get supported formats for camera index " + n + " done." + " Time spent: " + (l2 - l) + " ms.");
        return arrayList;
    }
}

