/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.hyphenate.util.EMLog;

public class NetUtils {
    private static final String TAG = "net";
    private static final int LOW_SPEED_UPLOAD_BUF_SIZE = 1024;
    private static final int HIGH_SPEED_UPLOAD_BUF_SIZE = 10240;
    private static final int MAX_SPEED_UPLOAD_BUF_SIZE = 102400;
    private static final int LOW_SPEED_DOWNLOAD_BUF_SIZE = 2024;
    private static final int HIGH_SPEED_DOWNLOAD_BUF_SIZE = 30720;
    private static final int MAX_SPEED_DOWNLOAD_BUF_SIZE = 102400;

    public static boolean hasNetwork(Context context) {
        if (context != null) {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                return networkInfo.isAvailable();
            }
            return false;
        }
        return false;
    }

    @TargetApi(value=13)
    public static boolean hasDataConnection(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
            if (networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected()) {
                EMLog.d(TAG, "has wifi connection");
                return true;
            }
            networkInfo = connectivityManager.getNetworkInfo(0);
            if (networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected()) {
                EMLog.d(TAG, "has mobile connection");
                return true;
            }
            if (Build.VERSION.SDK_INT >= 13 && (networkInfo = connectivityManager.getNetworkInfo(9)) != null && networkInfo.isAvailable() && networkInfo.isConnected()) {
                EMLog.d(TAG, "has ethernet connection");
                return true;
            }
            EMLog.d(TAG, "no data connection");
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Deprecated
    public static boolean isWifiConnection(Context context) {
        return NetUtils.isWifiConnected(context);
    }

    public static boolean isWifiConnected(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
        if (networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected()) {
            EMLog.d(TAG, "wifi is connected");
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isMobileConnection(Context context) {
        return NetUtils.isMobileConnected(context);
    }

    public static boolean isMobileConnected(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getNetworkInfo(0);
        if (networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected()) {
            EMLog.d(TAG, "mobile is connected");
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isEthernetConnection(Context context) {
        return NetUtils.isEthernetConnected(context);
    }

    public static boolean isEthernetConnected(Context context) {
        ConnectivityManager connectivityManager;
        NetworkInfo networkInfo;
        if (Build.VERSION.SDK_INT >= 13 && (networkInfo = (connectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(9)) != null && networkInfo.isAvailable() && networkInfo.isConnected()) {
            EMLog.d(TAG, "ethernet is connected");
            return true;
        }
        return false;
    }

    public static String getWiFiSSID(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        return wifiInfo.getSSID();
    }

    public static int getUploadBufSize(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.getType() == 1) {
            return 102400;
        }
        if (Build.VERSION.SDK_INT >= 13 && networkInfo != null && networkInfo.getType() == 9) {
            return 102400;
        }
        if (networkInfo == null && NetUtils.isConnectionFast(networkInfo.getType(), networkInfo.getSubtype())) {
            return 10240;
        }
        return 1024;
    }

    public static int getDownloadBufSize(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.getType() == 1) {
            return 102400;
        }
        if (Build.VERSION.SDK_INT >= 13 && networkInfo != null && networkInfo.getType() == 9) {
            return 102400;
        }
        if (networkInfo == null && NetUtils.isConnectionFast(networkInfo.getType(), networkInfo.getSubtype())) {
            return 30720;
        }
        return 2024;
    }

    private static boolean isConnectionFast(int n, int n2) {
        if (n == 1) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= 13 && n == 9) {
            return true;
        }
        if (n == 0) {
            switch (n2) {
                case 7: {
                    return false;
                }
                case 4: {
                    return false;
                }
                case 2: {
                    return false;
                }
                case 5: {
                    return true;
                }
                case 6: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 8: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 3: {
                    return true;
                }
            }
            if (Build.VERSION.SDK_INT >= 11 && (n2 == 14 || n2 == 13)) {
                return true;
            }
            if (Build.VERSION.SDK_INT >= 9 && n2 == 12) {
                return true;
            }
            if (Build.VERSION.SDK_INT >= 8 && n2 == 11) {
                return false;
            }
        }
        return false;
    }

    public static String getNetworkType(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isAvailable()) {
            int n = networkInfo.getType();
            if (Build.VERSION.SDK_INT >= 13 && n == 9) {
                return "ETHERNET";
            }
            if (n == 1) {
                return "WIFI";
            }
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            switch (telephonyManager.getNetworkType()) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    return "2G";
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    return "3G";
                }
                case 13: {
                    return "4G";
                }
            }
            return "unkonw network";
        }
        return "no network";
    }
}

