/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.PowerManager;
import android.os.Process;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.Log;
import com.hyphenate.EMCallBack;
import com.hyphenate.EMConnectionListener;
import com.hyphenate.a.a;
import com.hyphenate.analytics.EMActiveCollector;
import com.hyphenate.analytics.EMTimeTag;
import com.hyphenate.chat.EMCallManager;
import com.hyphenate.chat.EMChatManager;
import com.hyphenate.chat.EMChatRoomManager;
import com.hyphenate.chat.EMChatService;
import com.hyphenate.chat.EMContact;
import com.hyphenate.chat.EMContactManager;
import com.hyphenate.chat.EMEncryptProvider;
import com.hyphenate.chat.EMExtraService;
import com.hyphenate.chat.EMGroupManager;
import com.hyphenate.chat.EMJobService;
import com.hyphenate.chat.EMMonitor;
import com.hyphenate.chat.EMOptions;
import com.hyphenate.chat.EMPushHelper;
import com.hyphenate.chat.EMPushManager;
import com.hyphenate.chat.EMSessionManager;
import com.hyphenate.chat.EMSmartHeartBeat;
import com.hyphenate.chat.adapter.EMAChatClient;
import com.hyphenate.chat.adapter.EMAConnectionListener;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMANetCallback;
import com.hyphenate.chat.core.EMAdvanceDebugManager;
import com.hyphenate.chat.core.EMChatConfigPrivate;
import com.hyphenate.chat.core.EMDBManager;
import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.CryptoUtils;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.NetUtils;
import com.hyphenate.util.PathUtil;
import com.hyphenate.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class EMClient {
    public static final String TAG = "EMClient";
    private static EMClient instance = null;
    static boolean libraryLoaded = false;
    private EMGroupManager groupManager;
    private EMChatRoomManager chatroomManager;
    private EMChatManager chatManager;
    private EMContactManager contactManager;
    private EMCallManager callManager;
    private EMPushManager pushManager;
    private EMAChatClient emaObject;
    private Context mContext;
    private ExecutorService executor = null;
    private ExecutorService mainQueue = Executors.newSingleThreadExecutor();
    private EMEncryptProvider encryptProvider = null;
    private CryptoUtils cryptoUtils = new CryptoUtils();
    private boolean sdkInited = false;
    private EMChatConfigPrivate mChatConfigPrivate;
    private List<EMConnectionListener> connectionListeners = Collections.synchronizedList(new ArrayList());
    private MyConnectionListener connectionListener = new MyConnectionListener();
    private EMSmartHeartBeat smartHeartbeat = null;
    private PowerManager.WakeLock wakeLock;
    public static final String VERSION = "3.3.0";
    private static final int JOB_ID = 11;
    private static final int JOB_INTERVAL = 60000;
    boolean stopService;
    private BroadcastReceiver connectivityBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String string = intent.getAction();
            if (!string.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                EMLog.d(EMClient.TAG, "skip no connectivity action");
                return;
            }
            EMLog.d(EMClient.TAG, "connectivity receiver onReceiver");
            EMClient.this.execute(new Runnable(){

                @Override
                public void run() {
                    EMClient.this.onNetworkChanged();
                }
            });
        }
    };
    private AppStateListener appStateListener;
    private int activitySize = 0;

    private EMClient() {
    }

    public static EMClient getInstance() {
        if (instance == null) {
            EMClient.loadLibrary();
            instance = new EMClient();
        }
        return instance;
    }

    public void init(Context context, EMOptions eMOptions) {
        if (this.sdkInited) {
            return;
        }
        EMTimeTag eMTimeTag = new EMTimeTag();
        eMTimeTag.start();
        this.mContext = context.getApplicationContext();
        this.registerActivityLifecycleCallbacks();
        this.mChatConfigPrivate = new EMChatConfigPrivate();
        this.mChatConfigPrivate.a(context, eMOptions);
        eMOptions.setConfig(this.mChatConfigPrivate);
        this.emaObject = EMAChatClient.create(this.mChatConfigPrivate.a);
        this.emaObject.addConnectionListener(this.connectionListener);
        this.executor = Executors.newCachedThreadPool();
        this.cryptoUtils.init(1);
        this.initManagers();
        EMActiveCollector.sendActivePacket(this.mContext, this.getChatConfigPrivate());
        final String string = EMSessionManager.getInstance().getLastLoginUser();
        EMLog.e(TAG, "is autoLogin : " + eMOptions.getAutoLogin());
        EMLog.e(TAG, "lastLoginUser : " + string);
        EMLog.e(TAG, "hyphenate SDK is initialized with version : " + this.getChatConfigPrivate().e());
        PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
        this.wakeLock = powerManager.newWakeLock(1, "emclient");
        this.sdkInited = true;
        if (eMOptions.getAutoLogin() && this.isLoggedInBefore()) {
            final String string2 = EMSessionManager.getInstance().getLastLoginPwd();
            final String string3 = string;
            EMSessionManager.getInstance().currentUser = new EMContact(string3);
            final EMCallBack eMCallBack = new EMCallBack(){

                @Override
                public void onSuccess() {
                    Log.d((String)EMClient.TAG, (String)"hyphenate login onSuccess");
                    EMSessionManager.getInstance().currentUser = new EMContact(string3);
                }

                @Override
                public void onError(int n, String string) {
                    Log.d((String)EMClient.TAG, (String)"hyphenate login onError");
                }

                @Override
                public void onProgress(int n, String string) {
                }
            };
            this.execute(new Runnable(){

                @Override
                public void run() {
                    EMClient.this.getChatConfigPrivate().b(string3);
                    EMClient.this.groupManager().loadAllGroups();
                    EMClient.this.chatManager().loadAllConversationsFromDB();
                    EMClient.this.autoLogin(string, string2, eMCallBack);
                }
            });
        }
        eMTimeTag.stop();
        EMLog.e(TAG, "[Collector][sdk init]init time is : " + eMTimeTag.timeStr());
    }

    public void createAccount(String string, String string2) throws HyphenateException {
        string = string.toLowerCase();
        Pattern pattern = Pattern.compile("^[a-zA-Z0-9_-]+$");
        boolean bl = pattern.matcher(string).find();
        if (!bl) {
            throw new HyphenateException(205, "illegal user name");
        }
        EMAError eMAError = this.emaObject.createAccount(string, string2);
        this.handleError(eMAError);
    }

    public void login(String string, String string2, EMCallBack eMCallBack) {
        if (TextUtils.isEmpty((CharSequence)this.getChatConfigPrivate().l())) {
            throw new RuntimeException("please setup your appkey either in AndroidManifest.xml or through the EMOptions");
        }
        if (eMCallBack == null) {
            throw new IllegalArgumentException("callback is null!");
        }
        if (string == null || string2 == null || string.equals("") || string2.equals("")) {
            throw new IllegalArgumentException("username or password is null or empty!");
        }
        string = string.toLowerCase();
        this._login(string, string2, eMCallBack, false);
    }

    public int logout(boolean bl) {
        try {
            EMPushHelper.getInstance().onDestroy(bl);
        }
        catch (HyphenateException hyphenateException) {
            hyphenateException.printStackTrace();
            return 212;
        }
        this.logout();
        return 0;
    }

    void logout() {
        EMLog.d(TAG, " SDK Logout");
        try {
            if (this.connectivityBroadcastReceiver != null) {
                this.mContext.unregisterReceiver(this.connectivityBroadcastReceiver);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        EMSessionManager.getInstance().clearLastLoginUser();
        EMSessionManager.getInstance().clearLastLoginPwd();
        if (this.smartHeartbeat != null) {
            this.smartHeartbeat.stop();
        }
        if (this.wakeLock.isHeld()) {
            this.wakeLock.release();
        }
        if (this.emaObject != null) {
            this.emaObject.logout();
        }
        if (this.chatManager != null) {
            this.chatManager.onLogout();
        }
        if (this.groupManager != null) {
            this.groupManager.onLogout();
        }
        if (this.contactManager != null) {
            this.contactManager.onLogout();
        }
        if (this.chatroomManager != null) {
            this.chatroomManager.onLogout();
        }
        try {
            EMAdvanceDebugManager.a().f();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (EMChatConfigPrivate.a()) {
            a.c();
        }
        if (this.mContext != null) {
            EMMonitor.getInstance().getMonitorDB().b(this.mContext.getPackageName());
        }
        this.cancelJob();
        this.doStopService();
    }

    public void logout(final boolean bl, final EMCallBack eMCallBack) {
        new Thread(){

            @Override
            public void run() {
                int n = EMClient.this.logout(bl);
                if (n != 0) {
                    if (eMCallBack != null) {
                        eMCallBack.onError(n, "faild to unbind device token");
                    }
                } else if (eMCallBack != null) {
                    eMCallBack.onSuccess();
                }
            }
        }.start();
    }

    void logout(final EMCallBack eMCallBack) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                if (eMCallBack != null) {
                    eMCallBack.onProgress(0, null);
                }
                EMClient.this.logout();
                if (eMCallBack != null) {
                    eMCallBack.onSuccess();
                }
            }
        };
        thread.setPriority(9);
        thread.start();
    }

    public void changeAppkey(String string) throws HyphenateException {
        EMAError eMAError = this.emaObject.changeAppkey(string);
        if (eMAError.errCode() == 0) {
            this.getOptions().updatePath(string);
        }
        this.handleError(eMAError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(final EMConnectionListener eMConnectionListener) {
        if (eMConnectionListener == null) {
            return;
        }
        List<EMConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            if (!this.connectionListeners.contains(eMConnectionListener)) {
                this.connectionListeners.add(eMConnectionListener);
            }
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                if (EMClient.this.isConnected()) {
                    eMConnectionListener.onConnected();
                } else {
                    eMConnectionListener.onDisconnected(2);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(EMConnectionListener eMConnectionListener) {
        if (eMConnectionListener == null) {
            return;
        }
        List<EMConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            this.connectionListeners.remove(eMConnectionListener);
        }
    }

    public EMGroupManager groupManager() {
        if (this.groupManager == null) {
            this.groupManager = new EMGroupManager(this, this.emaObject.getGroupManager());
        }
        return this.groupManager;
    }

    public EMPushManager pushManager() {
        if (this.pushManager == null) {
            this.pushManager = new EMPushManager(this, this.emaObject.getPushMnager());
        }
        return this.pushManager;
    }

    public EMChatRoomManager chatroomManager() {
        if (this.chatroomManager == null) {
            this.chatroomManager = new EMChatRoomManager(this, this.emaObject.getChatRoomManager());
        }
        return this.chatroomManager;
    }

    public EMChatManager chatManager() {
        if (this.chatManager == null) {
            this.chatManager = new EMChatManager(this, this.emaObject.getChatManager());
        }
        return this.chatManager;
    }

    public EMContactManager contactManager() {
        if (this.contactManager == null) {
            this.contactManager = new EMContactManager(this, this.emaObject.getContactManager());
        }
        return this.contactManager;
    }

    public EMCallManager callManager() {
        if (this.callManager == null) {
            this.callManager = new EMCallManager(this, this.emaObject.getCallManager());
        }
        return this.callManager;
    }

    public Context getContext() {
        return this.mContext;
    }

    public String getCurrentUser() {
        if (EMSessionManager.getInstance().currentUser == null || EMSessionManager.getInstance().currentUser.username == null || EMSessionManager.getInstance().currentUser.username.equals("")) {
            return EMSessionManager.getInstance().getLastLoginUser();
        }
        return EMSessionManager.getInstance().currentUser.username;
    }

    public boolean isLoggedInBefore() {
        EMSessionManager eMSessionManager = EMSessionManager.getInstance();
        String string = eMSessionManager.getLastLoginUser();
        String string2 = eMSessionManager.getLastLoginPwd();
        return string != null && string2 != null && !string.equals("") && !string2.equals("");
    }

    public boolean isConnected() {
        return this.emaObject.isConnected();
    }

    public void setDebugMode(boolean bl) {
        String string;
        if (this.sdkInited && (string = EMAdvanceDebugManager.a().e()) != null) {
            bl = Boolean.parseBoolean(string);
        }
        EMLog.debugMode = bl;
        this.getChatConfigPrivate().c(bl);
    }

    @Deprecated
    public boolean updateCurrentUserNick(String string) {
        return this.pushManager().updatePushNickname(string);
    }

    public void uploadLog(EMCallBack eMCallBack) {
        this.chatManager().emaObject.uploadLog();
    }

    public List<EMContact> getRobotsFromServer() throws HyphenateException {
        return EMExtraService.getInstance().getRobotsFromServer();
    }

    public EMOptions getOptions() {
        return this.mChatConfigPrivate.b();
    }

    public String compressLogs() throws HyphenateException {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.compressLogs(eMAError);
        this.handleError(eMAError);
        return string;
    }

    private void initManagers() {
        EMHttpClient.getInstance().onInit(this.mChatConfigPrivate);
        this.chatManager();
        this.contactManager();
        this.groupManager();
        this.chatroomManager();
        this.setNatvieNetworkCallback();
    }

    void autoLogin(String string, String string2, EMCallBack eMCallBack) {
        this._login(string, string2, eMCallBack, true);
    }

    void _login(final String string, final String string2, final EMCallBack eMCallBack, final boolean bl) {
        if (this.getChatConfigPrivate() == null) {
            eMCallBack.onError(1, "");
            return;
        }
        EMLog.e(TAG, "emchat manager login in process:" + Process.myPid());
        this.execute(new Runnable(){

            @Override
            public void run() {
                if (string == null) {
                    eMCallBack.onError(101, "Invalid user name");
                    return;
                }
                EMAError eMAError = new EMAError();
                if (bl) {
                    EMClient.this.onNewLogin();
                    EMClient.this.emaObject.autoLogin(string, string2, eMAError);
                    if (eMAError.errCode() == 0) {
                        EMClient.this.checkPushAvailable();
                        eMCallBack.onSuccess();
                    } else {
                        eMCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                } else {
                    EMClient.this.emaObject.login(string, string2, eMAError);
                    if (eMAError.errCode() == 0) {
                        EMSessionManager.getInstance().setLastLoginUser(string);
                        EMSessionManager.getInstance().setLastLoginPwd(string2);
                        EMClient.this.onNewLogin();
                        EMClient.this.checkPushAvailable();
                        eMCallBack.onSuccess();
                    } else {
                        EMClient.this.doStopService();
                        eMCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                }
                if (eMAError.errCode() == 0) {
                    EMClient.this.setPresence(EMClient.this.getLocationString());
                }
                if (eMAError.errCode() == 202) {
                    EMSessionManager.getInstance().clearLastLoginPwd();
                }
            }
        });
    }

    void checkPushAvailable() {
        boolean bl = EMPushHelper.getInstance().checkAvailablePushService();
        if (bl) {
            EMPushHelper.getInstance().sendDeviceTokenToServer();
        } else {
            this.sendEmptyToken();
        }
    }

    private void sendEmptyToken() {
        for (int i = 0; i < 3; ++i) {
            boolean bl = EMPushHelper.getInstance().sendTokenToServer("");
            if (!bl) continue;
            return;
        }
    }

    void onNewLogin() {
        EMLog.d(TAG, "on new login created");
        String string = EMSessionManager.getInstance().getLastLoginUser();
        PathUtil.getInstance().initDirs(this.getChatConfigPrivate().l(), string, this.mContext);
        EMDBManager.a(string, this.mChatConfigPrivate);
        EMDBManager.a().c();
        this.saveAppname();
        EMPushHelper.getInstance().onInit();
        EMAdvanceDebugManager.a().a(this.mChatConfigPrivate);
        this.mContext.registerReceiver(this.connectivityBroadcastReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        if (this.smartHeartbeat == null) {
            this.smartHeartbeat = EMSmartHeartBeat.create(this.mContext);
        }
        this.smartHeartbeat.onInit();
        if (this.getChatConfigPrivate().a.hasHeartBeatCustomizedParams()) {
            this.smartHeartbeat.setCustomizedParams(this.getChatConfigPrivate().a.getWifiHeartBeatCustomizedParams(), this.getChatConfigPrivate().a.getMobileHeartBeatCustomizedParams());
        }
        this.scheduleJob();
    }

    @TargetApi(value=21)
    void scheduleJob() {
        if (Utils.isSdk21()) {
            try {
                Intent intent = new Intent(this.getContext(), EMJobService.class);
                this.mContext.startService(intent);
                JobInfo.Builder builder = new JobInfo.Builder(11, new ComponentName(this.getContext(), EMJobService.class));
                builder.setPeriodic(60000L);
                builder.setRequiredNetworkType(1);
                builder.setPersisted(true);
                JobScheduler jobScheduler = (JobScheduler)this.mContext.getSystemService("jobscheduler");
                jobScheduler.schedule(builder.build());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @TargetApi(value=21)
    void cancelJob() {
        if (Utils.isSdk21()) {
            try {
                JobScheduler jobScheduler = (JobScheduler)this.mContext.getSystemService("jobscheduler");
                jobScheduler.cancel(11);
                this.mContext.stopService(new Intent(this.mContext, EMJobService.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void loginWithToken(String string, String string2, EMCallBack eMCallBack) {
    }

    public String getAccessToken() {
        return this.getChatConfigPrivate().n();
    }

    private static void loadLibrary() {
        if (!libraryLoaded) {
            try {
                System.loadLibrary("hyphenate_av");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            try {
                System.loadLibrary("hyphenate_av_recorder");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            System.loadLibrary("hyphenate");
            libraryLoaded = true;
        }
    }

    CryptoUtils getCryptoUtils() {
        return this.cryptoUtils;
    }

    void doStartService() {
        if (this.mContext == null) {
            return;
        }
        EMLog.d(TAG, "do start service: context:" + this.mContext);
        this.stopService = false;
        try {
            Intent intent = new Intent(this.mContext, EMChatService.class);
            this.mContext.startService(intent);
        }
        catch (Exception exception) {
            EMLog.d(TAG, "exception in start service, e: " + exception.getMessage());
        }
    }

    void doStopService() {
        try {
            if (this.mContext == null) {
                EMLog.w(TAG, "applicationContext is null, the server is not started before");
                return;
            }
            EMLog.d(TAG, "do stop service");
            this.stopService = true;
            Intent intent = new Intent(this.mContext, EMChatService.class);
            this.mContext.stopService(intent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void saveAppname() {
        EMMonitor.getInstance().getMonitorDB().a(this.mContext.getPackageName());
    }

    void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    void executeOnMainQueue(Runnable runnable) {
        this.mainQueue.submit(runnable);
    }

    EMChatConfigPrivate getChatConfigPrivate() {
        return this.mChatConfigPrivate;
    }

    void setNatvieNetworkCallback() {
        EMANetCallback eMANetCallback = new EMANetCallback(){

            @Override
            public int getNetState() {
                if (!NetUtils.hasDataConnection(EMClient.this.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_NONE.ordinal();
                }
                if (NetUtils.isWifiConnected(EMClient.this.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_WIFI.ordinal();
                }
                return EMAChatClient.EMANetwork.NETWORK_MOBILE.ordinal();
            }
        };
        this.mChatConfigPrivate.a.setNetCallback(eMANetCallback);
    }

    void setEncryptProvider(EMEncryptProvider eMEncryptProvider) {
        this.encryptProvider = eMEncryptProvider;
    }

    EMEncryptProvider getEncryptProvider() {
        if (this.encryptProvider == null) {
            EMLog.d(TAG, "encrypt provider is not set, create default");
            this.encryptProvider = new EMEncryptProvider(){

                @Override
                public byte[] encrypt(byte[] byArray, String string) {
                    try {
                        return EMClient.this.cryptoUtils.encrypt(byArray);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return byArray;
                    }
                }

                @Override
                public byte[] decrypt(byte[] byArray, String string) {
                    try {
                        return EMClient.this.cryptoUtils.decrypt(byArray);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return byArray;
                    }
                }
            };
        }
        return this.encryptProvider;
    }

    boolean sendPing(boolean bl, long l) {
        return this.emaObject.sendPing(bl, l);
    }

    void forceReconnect() {
        this.disconnect();
        this.reconnect();
    }

    void reconnect() {
        this.wakeLock.acquire();
        this.emaObject.reconnect();
        if (this.wakeLock.isHeld()) {
            this.wakeLock.release();
        }
    }

    void disconnect() {
        this.emaObject.disconnect();
    }

    private void handleError(EMAError eMAError) throws HyphenateException {
        if (eMAError.errCode() != 0) {
            throw new HyphenateException(eMAError);
        }
    }

    void onNetworkChanged() {
        try {
            if (NetUtils.isWifiConnected(this.mContext)) {
                EMLog.d(TAG, "has wifi connection");
                this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_WIFI);
                return;
            }
            if (NetUtils.isMobileConnected(this.mContext)) {
                EMLog.d(TAG, "has mobile connection");
                this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_MOBILE);
                return;
            }
            if (NetUtils.isEthernetConnected(this.mContext)) {
                EMLog.d(TAG, "has ethernet connection");
                this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_CABLE);
                return;
            }
            EMLog.d(TAG, "no data connection");
            this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_NONE);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    void onNetworkChanged(EMAChatClient.EMANetwork eMANetwork) {
        this.emaObject.onNetworkChanged(eMANetwork);
    }

    void setAppStateListener(AppStateListener appStateListener) {
        this.appStateListener = appStateListener;
    }

    @TargetApi(value=14)
    private void registerActivityLifecycleCallbacks() {
        if (Utils.isSdk14()) {
            Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

                public void onActivityStopped(Activity activity) {
                    EMClient.this.activitySize--;
                    if (EMClient.this.activitySize == 0 && EMClient.this.appStateListener != null) {
                        EMClient.this.appStateListener.onBackground();
                    }
                }

                public void onActivityResumed(Activity activity) {
                    EMClient.this.activitySize++;
                    if (EMClient.this.activitySize == 1 && EMClient.this.appStateListener != null) {
                        EMClient.this.appStateListener.onForeground();
                    }
                }

                public void onActivityCreated(Activity activity, Bundle bundle) {
                }

                public void onActivityStarted(Activity activity) {
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
                }

                public void onActivityPaused(Activity activity) {
                }

                public void onActivityDestroyed(Activity activity) {
                }
            };
            ((Application)this.mContext).registerActivityLifecycleCallbacks(activityLifecycleCallbacks);
        }
    }

    void setPresence(final String string) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                EMClient.this.emaObject.setPresence(string);
            }
        });
    }

    private String getLocationString() {
        GsmCellLocation gsmCellLocation;
        String string;
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        String string2 = null;
        String string3 = null;
        int n = 0;
        try {
            string = telephonyManager.getSubscriberId();
            if (string != null) {
                string2 = string.substring(0, 3);
                string3 = string.substring(3, 5);
            }
            if ((gsmCellLocation = (GsmCellLocation)telephonyManager.getCellLocation()) != null) {
                n = gsmCellLocation.getCid();
            }
        }
        catch (Exception exception) {
            EMLog.d(TAG, exception.getMessage());
        }
        string = (LocationManager)this.mContext.getSystemService("location");
        gsmCellLocation = null;
        try {
            gsmCellLocation = string.getLastKnownLocation("network");
            if (gsmCellLocation == null) {
                gsmCellLocation = string.getLastKnownLocation("gps");
            }
        }
        catch (Exception exception) {
            EMLog.d(TAG, exception.getMessage());
        }
        JSONObject jSONObject = new JSONObject();
        try {
            if (gsmCellLocation != null) {
                jSONObject.put("lon", gsmCellLocation.getLongitude()).put("lat", gsmCellLocation.getLatitude());
            }
            if (n != 0) {
                jSONObject.put("cellid", n);
            }
            jSONObject.put("wifissid", (Object)NetUtils.getWiFiSSID(this.mContext));
            if (string3 != null) {
                jSONObject.put("mnc", (Object)string3);
            }
            if (string2 != null) {
                jSONObject.put("mcc", (Object)string2);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject.toString();
    }

    static interface AppStateListener {
        public void onForeground();

        public void onBackground();
    }

    class MyConnectionListener
    extends EMAConnectionListener {
        MyConnectionListener() {
        }

        @Override
        public void onConnected() {
            EMClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = EMClient.this.connectionListeners;
                    synchronized (list) {
                        try {
                            for (EMConnectionListener eMConnectionListener : EMClient.this.connectionListeners) {
                                eMConnectionListener.onConnected();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onDisconnected(final int n) {
            EMClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = EMClient.this.connectionListeners;
                    synchronized (list) {
                        try {
                            for (EMConnectionListener eMConnectionListener : EMClient.this.connectionListeners) {
                                eMConnectionListener.onDisconnected(n);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }
    }
}

