/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import java.util.List;

public interface EMAGroupManagerListenerInterface {

    /**
     * \brief Callback user when user is invited to a group.
     *
     * Note: User can accept or decline the invitation.
     * @param  groupId The group that invite the user.
     * @param  inviter The inviter.
     * @param  inviteMessage The invite message.
     * @return NA
     */
    void onReceiveInviteFromGroup(String groupId, String inviter, String inviteMessage);

    /**
     * \brief Callback user when the user accept to join the group.
     *
     * @param  group The group that invite the user.
     * @return NA
     */
   void onReceiveInviteAcceptionFromGroup(EMAGroup group, String invitee);
   
   /**
     * \brief Callback user when the user decline to join the group.
     *
     * @param  group The group that invite the user.
     * @param  invitee User's decline reason.
     * @return NA
     */
   void onReceiveInviteDeclineFromGroup(EMAGroup group, String invitee, String reason);
   
    /**
     * \brief Callback user when user is invited to a group.
     *
     * Note: User has been added to the group when received this callback.
     * @param  group The group that invite the user.
     * @param  inviter The inviter.
     * @param  inviteMessage The invite message.
     * @return NA
     */
    void onAutoAcceptInvitationFromGroup(EMAGroup group, String inviter, String inviteMessage);

    /**
     * \brief Callback user when user is kicked out from a group or the group is destroyed.
     *
     * @param  group The group that user left.
     * @param  reason The leave reason.
     * @return NA
     */
    void onLeaveGroup(EMAGroup group, /*EMAGroup.EMGroupLeaveReason*/ int reason);

    /**
     * \brief Callback user when receive a join group application.
     *
     * @param  group The group that user try to join.
     * @param  from User that try to join the group.
     * @param  message The apply message.
     * @return NA
     */
    void onReceiveJoinGroupApplication(EMAGroup group, String from, String message);

    /**
     * \brief Callback user when receive owner's approval.
     *
     * @param  group The group to join.
     * @return NA
     */
    void onReceiveAcceptionFromGroup(EMAGroup group);

    /**
     * \brief Callback user when receive group owner's rejection.
     *
     * @param  groupId The group that user try to join.
     * @param  reason Owner's reject reason.
     * @return NA
     */
    void onReceiveRejectionFromGroup(String groupId, String reason);

    /**
     * \brief Callback user when login user's group list is updated.
     *
     * @param  groups The login user's group list.
     * @return NA
     */
    void onUpdateMyGroupList(List<EMAGroup> groups);

    /**
     * \brief Callback user when user add to group mute list.
     *
     * @param  group The group that add user to mute list.
     * @return NA
     */
    void onAddMutesFromGroup(EMAGroup group, List<String> mutes, long muteExpire);

    /**
     * \brief Callback user when user remove from group mute list.
     *
     * @param  group The group that remove user from mute list.
     * @return NA
     */
    void onRemoveMutesFromGroup(EMAGroup group, List<String> mutes);

    /**
     * \brief Callback user when promote to group admin.
     *
     * @param  group The group that promote user admin.
     * @return NA
     */
    void onAddAdminFromGroup(EMAGroup group, String admin);

    /**
     * \brief Callback user when cancel admin.
     *
     * @param  group The group that cancel user admin.
     * @return NA
     */
    void onRemoveAdminFromGroup(EMAGroup group, String admin);

    /**
     * \brief Callback user when promote to group owner.
     *
     * @param  group The group that promote user to owner.
     * @return NA
     */
    void onAssignOwnerFromGroup(EMAGroup group, String newOwner, String oldOwner);

}
