/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import java.util.List;
import java.util.Map;

public abstract class EMAGroupManagerListener extends EMABase implements EMAGroupManagerListenerInterface {

	public EMAGroupManagerListener() {
		nativeInit();
	}
	
	@Override
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}
	
	/**
	 * create native listener class which implements EMContactListener interface.
	 */
	native void nativeInit();
	native void nativeFinalize();

	@Override
    public void onReceiveInviteFromGroup(String groupId, String inviter, String inviteMessage) {}
	
	/**
	 * \brief Callback user when the user accept to join the group.
	 *
	 * @param group The group that invite the user.
	 * @param invitee
	 * @return NA
	 */
	@Override
    public
	void onReceiveInviteAcceptionFromGroup(EMAGroup group, String invitee) {}
   
   /**
     * \brief Callback user when the user decline to join the group.
     *
     * @param group  The group that invite the user.
     * @param invitee The user who decline to join
     * @param reason User's decline reason.
     * @return NA
     */
	@Override
    public
	void onReceiveInviteDeclineFromGroup(EMAGroup group, String invitee, String reason) {}
    
	@Override
	public void onAutoAcceptInvitationFromGroup(EMAGroup group, String inviter, String inviteMessage) {}

	@Override
	public void onLeaveGroup(EMAGroup group, int reason) {
	}

	@Override
	public void onReceiveJoinGroupApplication(EMAGroup group, String from, String message) {
	}

	@Override
	public void onReceiveAcceptionFromGroup(EMAGroup group) {
	}

	@Override
	public void onReceiveRejectionFromGroup(String groupId, String reason) {
	}

	@Override
	public void onUpdateMyGroupList(List<EMAGroup> groups) {
	}


	// ============================= group_reform new add api end
	/**
	 * \brief Callback user when user add to group mute list.
	 *
	 * @param group The group that add user to mute list.
	 * @return NA
	 */
	@Override
	public void onAddMutesFromGroup(EMAGroup group, List<String> banPostList, long muteExpire) {}

	/**
	 * \brief Callback user when user remove from group mute list.
	 *
	 * @param group The group that remove user from mute list.
	 * @param banPostList mute list
	 * @return NA
	 */
	@Override
	public void onRemoveMutesFromGroup(EMAGroup group, List<String> banPostList) {}

	/**
	 * \brief Callback user when promote to group admin.
	 *
	 * @param  group The group that promote user admin.
	 * @return NA
	 */
	@Override
	public void onAddAdminFromGroup(EMAGroup group, String admin) {}

	/**
	 * \brief Callback user when cancel admin.
	 *
	 * @param group  The group that cancel user admin.
	 * @return NA
	 */
	@Override
	public void onRemoveAdminFromGroup(EMAGroup group, String admin) {}

	/**
	 * \brief Callback user when promote to group owner.
	 *
	 * @param group The group that promote user to owner.
	 * @return NA
	 */
	@Override
	public void onAssignOwnerFromGroup(EMAGroup group, String newOwner, String oldOwner) {}

}
