/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import android.annotation.SuppressLint;
import android.graphics.Point;
import android.graphics.Rect;
import android.opengl.EGL14;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import com.superrtc.call.EglBase;
import com.superrtc.call.EglBase10;
import com.superrtc.call.EglBase14;
import com.superrtc.call.GlRectDrawer;
import com.superrtc.call.GlTextureFrameBuffer;
import com.superrtc.call.GlUtil;
import com.superrtc.call.Logging;
import com.superrtc.call.RendererCommon;
import com.superrtc.call.VideoRenderer;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.opengles.GL10;

public class VideoRendererGui
implements GLSurfaceView.Renderer {
    private static VideoRendererGui instance = null;
    private static Runnable eglContextReady = null;
    private static final String TAG = "VideoRendererGui";
    private GLSurfaceView surface;
    private static EglBase.Context eglContext = null;
    private boolean onSurfaceCreatedCalled;
    private int screenWidth;
    private int screenHeight;
    private final ArrayList<YuvImageRenderer> yuvImageRenderers;
    private static Thread renderFrameThread;
    private static Thread drawThread;

    private VideoRendererGui(GLSurfaceView gLSurfaceView) {
        this.surface = gLSurfaceView;
        gLSurfaceView.setPreserveEGLContextOnPause(true);
        gLSurfaceView.setEGLContextClientVersion(2);
        gLSurfaceView.setRenderer((GLSurfaceView.Renderer)this);
        gLSurfaceView.setRenderMode(0);
        this.yuvImageRenderers = new ArrayList();
    }

    public static synchronized void setView(GLSurfaceView gLSurfaceView, Runnable runnable) {
        Logging.d(TAG, "VideoRendererGui.setView");
        instance = new VideoRendererGui(gLSurfaceView);
        eglContextReady = runnable;
    }

    private static synchronized EglBase.Context getEglBaseContext() {
        return eglContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void dispose() {
        if (instance == null) {
            return;
        }
        Logging.d(TAG, "VideoRendererGui.dispose");
        ArrayList<YuvImageRenderer> arrayList = VideoRendererGui.instance.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : VideoRendererGui.instance.yuvImageRenderers) {
                yuvImageRenderer.release();
            }
            VideoRendererGui.instance.yuvImageRenderers.clear();
        }
        renderFrameThread = null;
        drawThread = null;
        VideoRendererGui.instance.surface = null;
        eglContext = null;
        eglContextReady = null;
        instance = null;
    }

    public static VideoRenderer createGui(int n, int n2, int n3, int n4, RendererCommon.ScalingType scalingType, boolean bl) throws Exception {
        YuvImageRenderer yuvImageRenderer = VideoRendererGui.create(n, n2, n3, n4, scalingType, bl);
        return new VideoRenderer(yuvImageRenderer);
    }

    public static VideoRenderer.Callbacks createGuiRenderer(int n, int n2, int n3, int n4, RendererCommon.ScalingType scalingType, boolean bl) {
        return VideoRendererGui.create(n, n2, n3, n4, scalingType, bl);
    }

    public static synchronized YuvImageRenderer create(int n, int n2, int n3, int n4, RendererCommon.ScalingType scalingType, boolean bl) {
        return VideoRendererGui.create(n, n2, n3, n4, scalingType, bl, new GlRectDrawer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized YuvImageRenderer create(int n, int n2, int n3, int n4, RendererCommon.ScalingType scalingType, boolean bl, RendererCommon.GlDrawer glDrawer) {
        if (n < 0 || n > 100 || n2 < 0 || n2 > 100 || n3 < 0 || n3 > 100 || n4 < 0 || n4 > 100 || n + n3 > 100 || n2 + n4 > 100) {
            throw new RuntimeException("Incorrect window parameters.");
        }
        if (instance == null) {
            throw new RuntimeException("Attempt to create yuv renderer before setting GLSurfaceView");
        }
        final YuvImageRenderer yuvImageRenderer = new YuvImageRenderer(VideoRendererGui.instance.surface, VideoRendererGui.instance.yuvImageRenderers.size(), n, n2, n3, n4, scalingType, bl, glDrawer);
        ArrayList<YuvImageRenderer> arrayList = VideoRendererGui.instance.yuvImageRenderers;
        synchronized (arrayList) {
            if (VideoRendererGui.instance.onSurfaceCreatedCalled) {
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                VideoRendererGui.instance.surface.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        yuvImageRenderer.createTextures();
                        yuvImageRenderer.setScreenSize(instance.screenWidth, instance.screenHeight);
                        countDownLatch.countDown();
                    }
                });
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
            }
            VideoRendererGui.instance.yuvImageRenderers.add(yuvImageRenderer);
        }
        return yuvImageRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void update(VideoRenderer.Callbacks callbacks, int n, int n2, int n3, int n4, RendererCommon.ScalingType scalingType, boolean bl) {
        Logging.d(TAG, "VideoRendererGui.update");
        if (instance == null) {
            throw new RuntimeException("Attempt to update yuv renderer before setting GLSurfaceView");
        }
        ArrayList<YuvImageRenderer> arrayList = VideoRendererGui.instance.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : VideoRendererGui.instance.yuvImageRenderers) {
                if (yuvImageRenderer != callbacks) continue;
                yuvImageRenderer.setPosition(n, n2, n3, n4, scalingType, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setRendererEvents(VideoRenderer.Callbacks callbacks, RendererCommon.RendererEvents rendererEvents) {
        Logging.d(TAG, "VideoRendererGui.setRendererEvents");
        if (instance == null) {
            throw new RuntimeException("Attempt to set renderer events before setting GLSurfaceView");
        }
        ArrayList<YuvImageRenderer> arrayList = VideoRendererGui.instance.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : VideoRendererGui.instance.yuvImageRenderers) {
                if (yuvImageRenderer != callbacks) continue;
                yuvImageRenderer.rendererEvents = rendererEvents;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void remove(VideoRenderer.Callbacks callbacks) {
        Logging.d(TAG, "VideoRendererGui.remove");
        if (instance == null) {
            throw new RuntimeException("Attempt to remove renderer before setting GLSurfaceView");
        }
        ArrayList<YuvImageRenderer> arrayList = VideoRendererGui.instance.yuvImageRenderers;
        synchronized (arrayList) {
            int n = VideoRendererGui.instance.yuvImageRenderers.indexOf(callbacks);
            if (n == -1) {
                Logging.w(TAG, "Couldn't remove renderer (not present in current list)");
            } else {
                VideoRendererGui.instance.yuvImageRenderers.remove(n).release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void reset(VideoRenderer.Callbacks callbacks) {
        Logging.d(TAG, "VideoRendererGui.reset");
        if (instance == null) {
            throw new RuntimeException("Attempt to reset renderer before setting GLSurfaceView");
        }
        ArrayList<YuvImageRenderer> arrayList = VideoRendererGui.instance.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : VideoRendererGui.instance.yuvImageRenderers) {
                if (yuvImageRenderer != callbacks) continue;
                yuvImageRenderer.reset();
            }
        }
    }

    private static void printStackTrace(Thread thread, String string) {
        StackTraceElement[] stackTraceElementArray;
        if (thread != null && (stackTraceElementArray = thread.getStackTrace()).length > 0) {
            Logging.d(TAG, String.valueOf(string) + " stacks trace:");
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray2[n2];
                Logging.d(TAG, stackTraceElement.toString());
                ++n2;
            }
        }
    }

    public static synchronized void printStackTraces() {
        if (instance == null) {
            return;
        }
        VideoRendererGui.printStackTrace(renderFrameThread, "Render frame thread");
        VideoRendererGui.printStackTrace(drawThread, "Draw thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
        Logging.d(TAG, "VideoRendererGui.onSurfaceCreated");
        Class<VideoRendererGui> clazz = VideoRendererGui.class;
        synchronized (VideoRendererGui.class) {
            eglContext = EglBase14.isEGL14Supported() ? new EglBase14.Context(EGL14.eglGetCurrentContext()) : new EglBase10.Context(((EGL10)EGLContext.getEGL()).eglGetCurrentContext());
            Logging.d(TAG, "VideoRendererGui EGL Context: " + eglContext);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            clazz = this.yuvImageRenderers;
            synchronized (clazz) {
                for (YuvImageRenderer yuvImageRenderer : this.yuvImageRenderers) {
                    yuvImageRenderer.createTextures();
                }
                this.onSurfaceCreatedCalled = true;
            }
            GlUtil.checkNoGLES2Error("onSurfaceCreated done");
            GLES20.glPixelStorei((int)3317, (int)1);
            GLES20.glClearColor((float)0.15f, (float)0.15f, (float)0.15f, (float)1.0f);
            clazz = VideoRendererGui.class;
            synchronized (VideoRendererGui.class) {
                if (eglContextReady != null) {
                    eglContextReady.run();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceChanged(GL10 gL10, int n, int n2) {
        Logging.d(TAG, "VideoRendererGui.onSurfaceChanged: " + n + " x " + n2 + "  ");
        this.screenWidth = n;
        this.screenHeight = n2;
        ArrayList<YuvImageRenderer> arrayList = this.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : this.yuvImageRenderers) {
                yuvImageRenderer.setScreenSize(this.screenWidth, this.screenHeight);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDrawFrame(GL10 gL10) {
        if (drawThread == null) {
            drawThread = Thread.currentThread();
        }
        GLES20.glViewport((int)0, (int)0, (int)this.screenWidth, (int)this.screenHeight);
        GLES20.glClear((int)16384);
        ArrayList<YuvImageRenderer> arrayList = this.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : this.yuvImageRenderers) {
                yuvImageRenderer.draw();
            }
        }
    }

    private static class YuvImageRenderer
    implements VideoRenderer.Callbacks {
        private GLSurfaceView surface;
        private int id;
        private int[] yuvTextures = new int[3];
        private final RendererCommon.YuvUploader yuvUploader = new RendererCommon.YuvUploader();
        private final RendererCommon.GlDrawer drawer;
        private GlTextureFrameBuffer textureCopy;
        private VideoRenderer.I420Frame pendingFrame;
        private final Object pendingFrameLock = new Object();
        private RendererType rendererType;
        private RendererCommon.ScalingType scalingType;
        private boolean mirror;
        private RendererCommon.RendererEvents rendererEvents;
        boolean seenFrame;
        private int framesReceived;
        private int framesDropped;
        private int framesRendered;
        private long startTimeNs = -1L;
        private long drawTimeNs;
        private long copyTimeNs;
        private final Rect layoutInPercentage;
        private final Rect displayLayout = new Rect();
        private float[] layoutMatrix;
        private boolean updateLayoutProperties;
        private final Object updateLayoutLock = new Object();
        private float[] rotatedSamplingMatrix;
        private int screenWidth;
        private int screenHeight;
        private int videoWidth;
        private int videoHeight;
        private int rotationDegree;

        private YuvImageRenderer(GLSurfaceView gLSurfaceView, int n, int n2, int n3, int n4, int n5, RendererCommon.ScalingType scalingType, boolean bl, RendererCommon.GlDrawer glDrawer) {
            Logging.d(VideoRendererGui.TAG, "YuvImageRenderer.Create id: " + n);
            this.surface = gLSurfaceView;
            this.id = n;
            this.scalingType = scalingType;
            this.mirror = bl;
            this.drawer = glDrawer;
            this.layoutInPercentage = new Rect(n2, n3, Math.min(100, n2 + n4), Math.min(100, n3 + n5));
            this.updateLayoutProperties = false;
            this.rotationDegree = 0;
        }

        public synchronized void reset() {
            this.seenFrame = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void release() {
            this.surface = null;
            this.drawer.release();
            Object object = this.pendingFrameLock;
            synchronized (object) {
                if (this.pendingFrame != null) {
                    VideoRenderer.renderFrameDone(this.pendingFrame);
                    this.pendingFrame = null;
                }
            }
        }

        private void createTextures() {
            Logging.d(VideoRendererGui.TAG, "  YuvImageRenderer.createTextures " + this.id + " on GL thread:" + Thread.currentThread().getId());
            int n = 0;
            while (n < 3) {
                this.yuvTextures[n] = GlUtil.generateTexture(3553);
                ++n;
            }
            this.textureCopy = new GlTextureFrameBuffer(6407);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateLayoutMatrix() {
            Object object = this.updateLayoutLock;
            synchronized (object) {
                if (!this.updateLayoutProperties) {
                    return;
                }
                this.displayLayout.set((this.screenWidth * this.layoutInPercentage.left + 99) / 100, (this.screenHeight * this.layoutInPercentage.top + 99) / 100, this.screenWidth * this.layoutInPercentage.right / 100, this.screenHeight * this.layoutInPercentage.bottom / 100);
                Logging.d(VideoRendererGui.TAG, "ID: " + this.id + ". AdjustTextureCoords. Allowed display size: " + this.displayLayout.width() + " x " + this.displayLayout.height() + ". Video: " + this.videoWidth + " x " + this.videoHeight + ". Rotation: " + this.rotationDegree + ". Mirror: " + this.mirror);
                float f = this.rotationDegree % 180 == 0 ? (float)this.videoWidth / (float)this.videoHeight : (float)this.videoHeight / (float)this.videoWidth;
                Point point = RendererCommon.getDisplaySize(this.scalingType, f, this.displayLayout.width(), this.displayLayout.height());
                this.displayLayout.inset((this.displayLayout.width() - point.x) / 2, (this.displayLayout.height() - point.y) / 2);
                Logging.d(VideoRendererGui.TAG, "  Adjusted display size: " + this.displayLayout.width() + " x " + this.displayLayout.height());
                this.layoutMatrix = RendererCommon.getLayoutMatrix(this.mirror, f, (float)this.displayLayout.width() / (float)this.displayLayout.height());
                this.updateLayoutProperties = false;
                Logging.d(VideoRendererGui.TAG, "  AdjustTextureCoords done");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void draw() {
            boolean bl;
            if (!this.seenFrame) {
                return;
            }
            long l = System.nanoTime();
            Object object = this.pendingFrameLock;
            synchronized (object) {
                boolean bl2 = bl = this.pendingFrame != null;
                if (bl && this.startTimeNs == -1L) {
                    this.startTimeNs = l;
                }
                if (bl) {
                    this.rotatedSamplingMatrix = RendererCommon.rotateTextureMatrix(this.pendingFrame.samplingMatrix, this.pendingFrame.rotationDegree);
                    if (this.pendingFrame.yuvFrame) {
                        this.rendererType = RendererType.RENDERER_YUV;
                        this.yuvUploader.uploadYuvData(this.yuvTextures, this.pendingFrame.width, this.pendingFrame.height, this.pendingFrame.yuvStrides, this.pendingFrame.yuvPlanes);
                    } else {
                        this.rendererType = RendererType.RENDERER_TEXTURE;
                        this.textureCopy.setSize(this.pendingFrame.rotatedWidth(), this.pendingFrame.rotatedHeight());
                        GLES20.glBindFramebuffer((int)36160, (int)this.textureCopy.getFrameBufferId());
                        GlUtil.checkNoGLES2Error("glBindFramebuffer");
                        this.drawer.drawOes(this.pendingFrame.textureId, this.rotatedSamplingMatrix, 0, 0, this.textureCopy.getWidth(), this.textureCopy.getHeight());
                        this.rotatedSamplingMatrix = RendererCommon.identityMatrix();
                        GLES20.glBindFramebuffer((int)36160, (int)0);
                        GLES20.glFinish();
                    }
                    this.copyTimeNs += System.nanoTime() - l;
                    VideoRenderer.renderFrameDone(this.pendingFrame);
                    this.pendingFrame = null;
                }
            }
            this.updateLayoutMatrix();
            object = RendererCommon.multiplyMatrices(this.rotatedSamplingMatrix, this.layoutMatrix);
            int n = this.screenHeight - this.displayLayout.bottom;
            if (this.rendererType == RendererType.RENDERER_YUV) {
                this.drawer.drawYuv(this.yuvTextures, (float[])object, this.displayLayout.left, n, this.displayLayout.width(), this.displayLayout.height());
            } else {
                this.drawer.drawRgb(this.textureCopy.getTextureId(), (float[])object, this.displayLayout.left, n, this.displayLayout.width(), this.displayLayout.height());
            }
            if (bl) {
                ++this.framesRendered;
                this.drawTimeNs += System.nanoTime() - l;
                if (this.framesRendered % 300 == 0) {
                    this.logStatistics();
                }
            }
        }

        private void logStatistics() {
            long l = System.nanoTime() - this.startTimeNs;
            Logging.d(VideoRendererGui.TAG, "ID: " + this.id + ". Type: " + (Object)((Object)this.rendererType) + ". Frames received: " + this.framesReceived + ". Dropped: " + this.framesDropped + ". Rendered: " + this.framesRendered);
            if (this.framesReceived > 0 && this.framesRendered > 0) {
                Logging.d(VideoRendererGui.TAG, "Duration: " + (int)((double)l / 1000000.0) + " ms. FPS: " + (double)this.framesRendered * 1.0E9 / (double)l);
                Logging.d(VideoRendererGui.TAG, "Draw time: " + (int)(this.drawTimeNs / (long)(1000 * this.framesRendered)) + " us. Copy time: " + (int)(this.copyTimeNs / (long)(1000 * this.framesReceived)) + " us");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setScreenSize(int n, int n2) {
            Object object = this.updateLayoutLock;
            synchronized (object) {
                if (n == this.screenWidth && n2 == this.screenHeight) {
                    return;
                }
                Logging.d(VideoRendererGui.TAG, "ID: " + this.id + ". YuvImageRenderer.setScreenSize: " + n + " x " + n2);
                this.screenWidth = n;
                this.screenHeight = n2;
                this.updateLayoutProperties = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPosition(int n, int n2, int n3, int n4, RendererCommon.ScalingType scalingType, boolean bl) {
            Rect rect = new Rect(n, n2, Math.min(100, n + n3), Math.min(100, n2 + n4));
            Object object = this.updateLayoutLock;
            synchronized (object) {
                if (rect.equals((Object)this.layoutInPercentage) && scalingType == this.scalingType && bl == this.mirror) {
                    return;
                }
                Logging.d(VideoRendererGui.TAG, "ID: " + this.id + ". YuvImageRenderer.setPosition: (" + n + ", " + n2 + ") " + n3 + " x " + n4 + ". Scaling: " + (Object)((Object)scalingType) + ". Mirror: " + bl);
                this.layoutInPercentage.set(rect);
                this.scalingType = scalingType;
                this.mirror = bl;
                this.updateLayoutProperties = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setSize(int n, int n2, int n3) {
            if (n == this.videoWidth && n2 == this.videoHeight && n3 == this.rotationDegree) {
                return;
            }
            if (this.rendererEvents != null) {
                Logging.d(VideoRendererGui.TAG, "ID: " + this.id + ". Reporting frame resolution changed to " + n + " x " + n2);
                this.rendererEvents.onFrameResolutionChanged(n, n2, n3);
            }
            Object object = this.updateLayoutLock;
            synchronized (object) {
                Logging.d(VideoRendererGui.TAG, "ID: " + this.id + ". YuvImageRenderer.setSize: " + n + " x " + n2 + " rotation " + n3);
                this.videoWidth = n;
                this.videoHeight = n2;
                this.rotationDegree = n3;
                this.updateLayoutProperties = true;
                Logging.d(VideoRendererGui.TAG, "  YuvImageRenderer.setSize done.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void renderFrame(VideoRenderer.I420Frame i420Frame) {
            if (this.surface == null) {
                VideoRenderer.renderFrameDone(i420Frame);
                return;
            }
            if (renderFrameThread == null) {
                renderFrameThread = Thread.currentThread();
            }
            if (!this.seenFrame && this.rendererEvents != null) {
                Logging.d(VideoRendererGui.TAG, "ID: " + this.id + ". Reporting first rendered frame.");
                this.rendererEvents.onFirstFrameRendered();
            }
            ++this.framesReceived;
            Object object = this.pendingFrameLock;
            synchronized (object) {
                if (i420Frame.yuvFrame && (i420Frame.yuvStrides[0] < i420Frame.width || i420Frame.yuvStrides[1] < i420Frame.width / 2 || i420Frame.yuvStrides[2] < i420Frame.width / 2)) {
                    Logging.e(VideoRendererGui.TAG, "Incorrect strides " + i420Frame.yuvStrides[0] + ", " + i420Frame.yuvStrides[1] + ", " + i420Frame.yuvStrides[2]);
                    VideoRenderer.renderFrameDone(i420Frame);
                    return;
                }
                if (this.pendingFrame != null) {
                    ++this.framesDropped;
                    VideoRenderer.renderFrameDone(i420Frame);
                    this.seenFrame = true;
                    return;
                }
                this.pendingFrame = i420Frame;
            }
            this.setSize(i420Frame.width, i420Frame.height, i420Frame.rotationDegree);
            this.seenFrame = true;
            this.surface.requestRender();
        }

        private static enum RendererType {
            RENDERER_YUV,
            RENDERER_TEXTURE;

        }
    }
}

