/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import com.hyphenate.EMChatRoomChangeListener;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMChatRoom;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCursorResult;
import com.hyphenate.chat.EMOptions;
import com.hyphenate.chat.EMPageResult;
import com.hyphenate.chat.EMSessionManager;
import com.hyphenate.chat.adapter.EMAChatRoom;
import com.hyphenate.chat.adapter.EMAChatRoomManager;
import com.hyphenate.chat.adapter.EMAChatRoomManagerListener;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.exceptions.HyphenateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class EMChatRoomManager {
    EMAChatRoomManager emaObject;
    private List<EMChatRoomChangeListener> chatRoomListeners = Collections.synchronizedList(new ArrayList());
    private ExecutorService threadPool = null;
    private List<EMChatRoom> chatRooms = Collections.synchronizedList(new ArrayList());
    EMClient mClient;
    EMAChatRoomManagerListener chatRoomListenerImpl = new EMAChatRoomManagerListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLeaveChatRoom(EMAChatRoom eMAChatRoom, int n) {
            EMClient.getInstance().chatManager().caches.remove(eMAChatRoom.getId());
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                    if (n == 0) {
                        eMChatRoomChangeListener.onRemovedFromChatRoom(eMAChatRoom.getId(), eMAChatRoom.getName(), "");
                        continue;
                    }
                    eMChatRoomChangeListener.onChatRoomDestroyed(eMAChatRoom.getId(), eMAChatRoom.getName());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMemberJoinedChatRoom(EMAChatRoom eMAChatRoom, String string) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                    eMChatRoomChangeListener.onMemberJoined(eMAChatRoom.getId(), string);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMemberLeftChatRoom(EMAChatRoom eMAChatRoom, String string) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                    eMChatRoomChangeListener.onMemberExited(eMAChatRoom.getId(), eMAChatRoom.getName(), string);
                }
            }
        }
    };

    public EMChatRoomManager(EMClient eMClient, EMAChatRoomManager eMAChatRoomManager) {
        this.emaObject = eMAChatRoomManager;
        this.emaObject.addListener(this.chatRoomListenerImpl);
        this.mClient = eMClient;
        this.threadPool = Executors.newCachedThreadPool();
    }

    public void addChatRoomChangeListener(EMChatRoomChangeListener eMChatRoomChangeListener) {
        this.chatRoomListeners.add(eMChatRoomChangeListener);
    }

    @Deprecated
    public void removeChatRoomChangeListener(EMChatRoomChangeListener eMChatRoomChangeListener) {
        this.removeChatRoomListener(eMChatRoomChangeListener);
    }

    public void removeChatRoomListener(EMChatRoomChangeListener eMChatRoomChangeListener) {
        this.chatRoomListeners.remove(eMChatRoomChangeListener);
    }

    public void joinChatRoom(final String string, final EMValueCallBack<EMChatRoom> eMValueCallBack) {
        this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                EMAChatRoom eMAChatRoom = EMChatRoomManager.this.emaObject.joinChatRoom(string, eMAError);
                EMChatRoom eMChatRoom = new EMChatRoom(eMAChatRoom);
                if (eMAError.errCode() == 0 || eMAError.errCode() == 701) {
                    eMValueCallBack.onSuccess(eMChatRoom);
                } else {
                    eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public void leaveChatRoom(final String string) {
        EMChatRoom eMChatRoom = this.getChatRoom(string);
        if (eMChatRoom == null) {
            return;
        }
        EMOptions eMOptions = EMClient.getInstance().getOptions();
        boolean bl = eMOptions.isChatroomOwnerLeaveAllowed();
        String string2 = eMChatRoom.getOwner();
        if (!bl && string2.equals(EMSessionManager.getInstance().getLastLoginUser())) {
            return;
        }
        EMClient.getInstance().chatManager().deleteConversation(string, true);
        this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                EMChatRoomManager.this.emaObject.leaveChatRoom(string, eMAError);
            }
        });
    }

    public EMPageResult<EMChatRoom> fetchPublicChatRoomsFromServer(int n, int n2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMPageResult<EMAChatRoom> eMPageResult = this.emaObject.fetchChatroomsWithPage(n, n2, eMAError);
        this.handleError(eMAError);
        List list = (List)eMPageResult.getData();
        int n3 = eMPageResult.getPageCount();
        EMPageResult<EMChatRoom> eMPageResult2 = new EMPageResult<EMChatRoom>();
        ArrayList<EMChatRoom> arrayList = new ArrayList<EMChatRoom>();
        for (EMAChatRoom eMAChatRoom : list) {
            arrayList.add(new EMChatRoom(eMAChatRoom));
        }
        eMPageResult2.setPageCount(n3);
        eMPageResult2.setData((EMChatRoom)((Object)arrayList));
        this.chatRooms.clear();
        this.chatRooms.addAll(arrayList);
        return eMPageResult2;
    }

    public EMCursorResult<EMChatRoom> fetchPublicChatRoomsFromServer(int n, String string) throws HyphenateException {
        EMAError eMAError = new EMAError();
        List<EMAChatRoom> list = this.emaObject.fetchAllChatrooms(eMAError);
        this.handleError(eMAError);
        EMCursorResult<EMChatRoom> eMCursorResult = new EMCursorResult<EMChatRoom>();
        ArrayList<EMChatRoom> arrayList = new ArrayList<EMChatRoom>();
        for (EMAChatRoom eMAChatRoom : list) {
            arrayList.add(new EMChatRoom(eMAChatRoom));
        }
        eMCursorResult.setCursor(null);
        eMCursorResult.setData((EMChatRoom)((Object)arrayList));
        this.chatRooms.clear();
        this.chatRooms.addAll(arrayList);
        return eMCursorResult;
    }

    public void asyncFetchPublicChatRoomsFromServer(final int n, final String string, final EMValueCallBack<EMCursorResult<EMChatRoom>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMCursorResult<EMChatRoom> eMCursorResult = EMChatRoomManager.this.fetchPublicChatRoomsFromServer(n, string);
                    eMValueCallBack.onSuccess(eMCursorResult);
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void asyncFetchPublicChatRoomsFromServer(final int n, final int n2, final EMValueCallBack<EMPageResult<EMChatRoom>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMPageResult<EMChatRoom> eMPageResult = EMChatRoomManager.this.fetchPublicChatRoomsFromServer(n, n2);
                    eMValueCallBack.onSuccess(eMPageResult);
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom fetchChatRoomFromServer(String string) throws HyphenateException {
        return this.fetchChatRoomFromServer(string, false);
    }

    public EMChatRoom fetchChatRoomFromServer(String string, boolean bl) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.fetchChatroomSpecification(string, eMAError, bl);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncFetchChatRoomFromServer(final String string, final EMValueCallBack<EMChatRoom> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatRoom eMChatRoom = EMChatRoomManager.this.fetchChatRoomFromServer(string);
                    eMValueCallBack.onSuccess(eMChatRoom);
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom getChatRoom(String string) {
        EMAChatRoom eMAChatRoom = this.emaObject.getChatroom(string);
        if (eMAChatRoom == null) {
            return null;
        }
        return new EMChatRoom(eMAChatRoom);
    }

    public List<EMChatRoom> getAllChatRooms() {
        return Collections.unmodifiableList(this.chatRooms);
    }

    void importChatRoom(String string, String string2, String string3, String string4, List<String> list, int n) {
    }

    private void handleError(EMAError eMAError) throws HyphenateException {
        if (eMAError.errCode() != 0) {
            throw new HyphenateException(eMAError);
        }
    }

    void onLogout() {
        this.chatRoomListeners.clear();
    }
}

