/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.util;

import android.util.Base64;

import java.security.MessageDigest;
import java.util.Arrays;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoUtils {

    Cipher cipher = null;
    Cipher decipher = null;
    
    public final static int ALGORIGHM_DES = 0;
    public final static int ALGORIGHM_AES = 1;
    
    byte[] keyBytes = new byte[] {
            0x4a, 0x6f, 0x68, 0x6e, 0x73, 0x6f, 0x6e, 0x4d, 
            0x61, 0x4a, 0x69, 0x46, 0x61, 0x6e, 0x67, 0x4a,
            0x65, 0x72, 0x76, 0x69, 0x73, 0x4c, 0x69, 0x75,
            0x4c, 0x69, 0x75, 0x53, 0x68, 0x61, 0x6f, 0x5a
        };
    
    String key = "TongliforniaJohnson";
    public CryptoUtils() {
    }

    public void init(int algorithm) {
        if (algorithm == ALGORIGHM_DES) {
            initDES();    
        } else {
            initAES();
        }
    }
    
    public void initDES() {
        try {
            final MessageDigest md = MessageDigest.getInstance("md5");
            final byte[] digestOfPassword = md.digest(key.getBytes("utf-8"));
            keyBytes = Arrays.copyOf(digestOfPassword, 24);
            for (int j = 0, k = 16; j < 8;) {
                keyBytes[k++] = keyBytes[j++];
            }
         
            final SecretKey key = new SecretKeySpec(keyBytes, "DESede");
            final IvParameterSpec iv = new IvParameterSpec(new byte[8]);
            cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, key, iv);
            decipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            decipher.init(Cipher.DECRYPT_MODE, key, iv);
            EMLog.d("encrypt", "initital for DES");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    public void initAES() {
        try {
            /*
            KeyGenerator gen = KeyGenerator.getInstance("AES");
            SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
            rand.setSeed(key.getBytes());
            gen.init(256, rand);
            keyBytes = gen.generateKey().getEncoded();
            */
            cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            SecretKeySpec spec = new SecretKeySpec(keyBytes, "AES");
            cipher.init(Cipher.ENCRYPT_MODE, spec);
            decipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            decipher.init(Cipher.DECRYPT_MODE, spec);
            EMLog.d("encrypt", "initital for AES");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    /**
     * encrypt the message using 3DES or AES.
     * notice, we need to use base64encoded on the encrypted bytes inorder to 
     * add this message to xml stream to send out
     * once received, need to use base64decoded first to get the encrypted bytes
     * the decrypt it and return the plain text
     * @param message
     * @return
     * @throws Exception
     */
    public String encryptBase64String(String message) throws Exception {
        byte[] bytes = encrypt(message);
        return new String(Base64.encode(bytes, Base64.DEFAULT));
    }
    
    public String decryptBase64String(String message) throws Exception {
        byte[] input = Base64.decode(message, Base64.DEFAULT);
        byte[] decriptedBytes = decrypt(input);
        return new String(decriptedBytes, "UTF-8");
    }
    
    public byte[] encrypt(String message) throws Exception {
        byte[] stringBytes = message.getBytes("UTF-8");  
        byte[] encryptedBytes = cipher.doFinal(stringBytes);
        return encryptedBytes;
    }
    
    public byte[] encrypt(byte[] input) throws Exception {
        return cipher.doFinal(input);
    }
    
    public byte[] decrypt(byte[] input) throws Exception {
        return decipher.doFinal(input);
    }
    
    /*
    public String decrypt(byte[] message) throws Exception {
        byte[] base64Bytes = decipher.doFinal(Base64.decode(message, Base64.DEFAULT));
        byte[] msgBytes = Base64.decode(base64Bytes, Base64.DEFAULT);
        String str = new String(msgBytes, "UTF-8");
        EMLog.d("encrypt", "decoded string:" + str);
        return str;
    }
    
    public byte[] decryptByte(byte[] input) throws Exception {
        byte[] bytes = decipher.doFinal(input);
        return bytes;
    }
    */
        
    static final String HEXES = "0123456789ABCDEF";
    public static String getHex( byte [] raw ) {
        if ( raw == null ) {
            return null;
        }
        final StringBuilder hex = new StringBuilder( 2 * raw.length );
        for ( final byte b : raw ) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4))
                .append(HEXES.charAt((b & 0x0F)));
        }
        return hex.toString();
    }

    public static byte[] fromHexString(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte) ((Character.digit(s.charAt(i), 16) << 4)
                    + Character.digit(s.charAt(i+1), 16));
        }
        return data;
    }
}
