/************************************************************
 *  * EaseMob CONFIDENTIAL 
 * __________________ 
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
 *  
 * NOTICE: All information contained herein is, and remains 
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material 
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.cloud;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

import com.hyphenate.chat.EMChatManager;
import com.hyphenate.chat.EMClient;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.EMPrivateConstant;
import com.hyphenate.util.NetUtils;

import android.content.Context;
import android.text.TextUtils;
import internal.org.apache.http.entity.mime.content.FileBody;
import internal.org.apache.http.entity.mime.content.StringBody;

/**
 * 此类是内部类，请谨慎调用
 * 相关API可以从EMChatManager找到
 * downloadFile ->  EMChatManager.downloadFile
 * 
 * Use HTTP POST to upload file to cloud storage. also support download and delete file
 * the operations here are synchronized, user need to run in asynctask if needed
 * 
 * @deprecated 此类是内部类，请谨慎调用。相关API可以从EMChatManager找到
 */
@SuppressWarnings("deprecation")
public class HttpFileManager extends CloudFileManager {
	/**
	 * 允许文件最大上传大小
	 */
	private static final long MAX_ALLOWED_FILE_SIZE = 10 * 1024 * 1024;
	private long totalSize;
	private Context appContext;
	boolean tokenRetrieved = false;
	private static final int max_retry_times_on_connection_refused = 20;
	
	public HttpFileManager(){
		appContext = EMClient.getInstance().getContext();
	}
	
	public HttpFileManager(Context appContext, String userServerUrl) {
		this.appContext = appContext.getApplicationContext();
	}
	
	public HttpFileManager(Context context) {
		this.appContext = context.getApplicationContext();
	}
	 
	@Override
	public boolean authorization() {
		// @Johnson. for security reason. we need to add some signon code to
		// login to apache
		// since we exposed file operations.
		return true;
	}
	
	private void sendFiletoServerHttp(final String localFilePath, final String remoteFilePath, final String appId, final String jid,
			Map<String, String> headers, final CloudOperationCallback listener){
		 sendFiletoServerHttpWithCountDown(localFilePath,remoteFilePath,appId,jid,headers,listener,-1,false);
	}
	
	/**
	 * send file using http client
	 */
	private void sendFiletoServerHttpWithCountDown(final String localFilePath, final String remoteFilePath, final String appId, final String jid,
			final Map<String, String> hders, final CloudOperationCallback listener, int countDown, boolean started){

		EMLog.d(TAG, "sendFiletoServerHttpWithCountDown .....");
		
		File sourceFile = new File(localFilePath);
		if (!sourceFile.isFile()) {
			EMLog.e(TAG, "Source file doesn't exist");
			listener.onError("Source file doesn't exist");
			return;
		}

		// 大于10M，不让上传
		if (sourceFile.length() > MAX_ALLOWED_FILE_SIZE) {
			listener.onError("file doesn't bigger than 10 M");
			return;
		}

		final Map<String, String> headers = HttpClientManager.addDomainToHeaders(hders);
		
		HttpResponse response = null;
		String remoteUrl = HttpClientConfig.getFileRemoteUrl(remoteFilePath);
		
		EMLog.d(TAG, " remote path url : " + remoteUrl + " --countDown: " + countDown);
		
		int timeout = HttpClientConfig.getTimeout(headers);
		
		DefaultHttpClient httpclient = HttpClientConfig.getDefaultHttpClient(timeout);
		
		try {
			HttpPost request = new HttpPost(remoteUrl);

			CustomMultiPartEntity multipartEntity = new CustomMultiPartEntity(new CustomMultiPartEntity.ProgressListener() {
				@Override
				public void transferred(long num) {
					int progressCode = (int) ((num / (float) totalSize* 100));
					if(progressCode != 100){
						if(listener != null){
							listener.onProgress(progressCode);
						}
					}
				}
			});

			if (appId != null) {
				multipartEntity.addPart("app", new StringBody(appId));
			}

			if (jid != null) {
				multipartEntity.addPart("id", new StringBody(jid));
			}

			if (headers != null) {
				for (Entry<String, String> item : headers.entrySet()) {
					request.addHeader(item.getKey(), item.getValue());
				}
			}

			String remoteFileName = remoteFilePath;
			if (remoteFileName.indexOf("/") > 0) {
				String path = remoteFileName.substring(0, remoteFileName.lastIndexOf("/"));
				remoteFileName = remoteFileName.substring(remoteFileName.lastIndexOf("/"));
				multipartEntity.addPart("path", new StringBody(path));
			}

			String mimeType = getMimeType(sourceFile);
			
			EMLog.d(TAG, " remote file name : " + remoteFileName);
			
			multipartEntity.addPart("file", new FileBody(sourceFile, remoteFileName, mimeType, "UTF-8"));
			totalSize = multipartEntity.getContentLength();
			
			request.setEntity(multipartEntity);
		    
			if (EMHttpClient.getInstance().chatConfig().useHttps()) {
				HttpClientManager.checkAndProcessSSL(remoteUrl,httpclient);
			}
			
//			EMTimeTag tag = new EMTimeTag();
//			tag.start();
			
			response = httpclient.execute(request);
			
//			tag.stop();
//			
//			if(tag.timeSpent() > 0){
//			    EMPerformanceCollector.collectUploadFileTime(tag, totalSize, remoteUrl);
//			}
			
			int responseCode = response.getStatusLine().getStatusCode();
			EMLog.d(TAG, "server responseCode:" + responseCode + " localFilePath : " + localFilePath);
			
			switch (responseCode) {
				case HttpStatus.SC_OK:
				{
					listener.onProgress(100);
					HttpEntity httpEntity = response.getEntity();
					String lastLine = EntityUtils.toString(httpEntity);
					listener.onSuccess(lastLine);
					return;	
				}
	
			    // in case SC_UNAUTHORIZED, we think this would be caused by invalid token
			    // so firstly, we need to retrieve token again and check, if token is retrieved but still failed
				// we will report a failure
				case HttpStatus.SC_UNAUTHORIZED:
				{
					long tokenSaveTime = EMHttpClient.getInstance().chatConfig().getTokenSaveTime();
					
					if ((System.currentTimeMillis() - tokenSaveTime) <= 10 * 60 * 1000) {
						if (listener != null) {
							listener.onError("unauthorized file");
						}
						return;
					}

					if (tokenRetrieved) {
						listener.onError("unauthorized file");
						return;
					}
					
					boolean getFromSever = true;
					String token = EMClient.getInstance().getOptions().getAccessToken(getFromSever);
				    tokenRetrieved = true;
				    
				    if(token == null){
				    	listener.onError("unauthorized token is null");
				    	return;
				    }
				    
					headers.put("Authorization", "Bearer " + token);
					if(!started){
						new Thread(){
							@Override
							public void run(){
								sendFiletoServerHttpWithCountDown(localFilePath,remoteFilePath,appId, jid, headers, listener,3,true);
							}
						}.start();
					}else{
						if(countDown > 0){
							final int fcountDown = --countDown;
							new Thread(){
								@Override
								public void run(){
									sendFiletoServerHttpWithCountDown(localFilePath,remoteFilePath,appId, jid, headers, listener,fcountDown,true);
								}
							}.start();
						}
					}
					
					return;
				}

				default:
				{
					HttpEntity httpEntitys = response.getEntity();
					String errorString = EntityUtils.toString(httpEntitys);
					
					errorString = "Http response error : " + responseCode + " error msg : " + errorString;
					
					EMLog.e(TAG, errorString);
					
					if(listener != null){
						listener.onError(errorString);
					}
					
					return;	
				}
			}
			 
		} catch (Exception e) {
		    String errorMsg = (e != null && e.getMessage() != null)?e.getMessage():"failed to upload the files";

			EMLog.e(TAG, "sendFiletoServerHttp:" + errorMsg);
			
                if(errorMsg.toLowerCase().contains(EMPrivateConstant.CONNECTION_REFUSED) && NetUtils.hasNetwork(appContext)) {
            		if(!started){
            			String baseUrl = EMHttpClient.getInstance().chatConfig().getNextAvailableBaseUrl();
            			final String url = HttpClientManager.getNewHost(remoteFilePath, baseUrl);
        				new Thread(){
							@Override
							public void run(){
								sendFiletoServerHttpWithCountDown(localFilePath,url,appId, jid, headers, listener,max_retry_times_on_connection_refused,true);
							}
						}.start();
						
        				return;
            			
            		}else{
            			if(countDown > 0){
                			String baseUrl = EMHttpClient.getInstance().chatConfig().getNextAvailableBaseUrl();
                			final String url = HttpClientManager.getNewHost(remoteFilePath, baseUrl);
            				final int fcountDown = --countDown;
            				new Thread(){
								@Override
								public void run(){
									sendFiletoServerHttpWithCountDown(localFilePath,url,appId, jid, headers, listener,fcountDown,true);
								}
							}.start();
            				return;
            			}
            		}
                }
//            }
			
			if(listener != null){
				listener.onError(errorMsg);
			}
		}
	}

	public static String getMimeType(File sourceFile){
		String sourceName=sourceFile.getName();
		if (sourceName.endsWith(".3gp") || sourceName.endsWith(".amr")) {
			return "audio/3gp";
		}if(sourceName.endsWith(".jpe")||sourceName.endsWith(".jpeg")||sourceName.endsWith(".jpg")){
			return "image/jpeg";
		}if(sourceName.endsWith(".amr")){
			return "audio/amr";
		}if(sourceName.endsWith(".mp4")){
			return "video/mp4";
		}else {
			return "image/png";
		}
	}

	@Override
	public void uploadFileInBackground(final String localFilePath, final String remoteFilePath, final String appId, final String jid,
			final Map<String, String> headers, final CloudOperationCallback callback) {
		new Thread() {
			public void run() {
				try {
					sendFiletoServerHttp(localFilePath, remoteFilePath, appId, jid, headers, callback);
				} catch (Exception e) {
					if(e!=null && e.toString() != null){
						EMLog.e(TAG, e.toString());
						
						callback.onError(e.toString());
					}else{
						callback.onError("failed to upload the file : " + localFilePath + " remote path : " + remoteFilePath);   	
					}
				}

			}
		}.start();
	}

	/**
	 * upload file synchronized
	 * 
	 * @param localFilePath
	 * @param remoteFilePath
	 * @param appId
	 * @param jid
	 * @param listener
	 */
	public void uploadFile(final String localFilePath, final String remoteFilePath, final String appId, final String jid,
			final Map<String, String> headers, final CloudOperationCallback callback) {
		try {
			sendFiletoServerHttp(localFilePath, remoteFilePath, appId, jid, headers, callback);
		} catch (Exception e) {
			EMLog.e(TAG, "uploadFile error:" + e.toString());
			
			callback.onError(e.toString());
		}
	}

	/**
	 * download a remote file to local storage.
	 * 
	 * 由于此类不再对外开放
	 * 
	 * 请用 {@link EMChatManager downloadFile}代替
	 * 
	 * @param remoteFilePath
	 *            remote file to download
	 * @param localFilePath
	 *            local file path to store
	 * @param appId
	 * @param jid
	 * @param callback
	 *            operation callback
	 *  @deprecated 已过时,使用 {@link downloadFile((String remoteUrl,String localFilePath,Map<String, String> headers,
	 *		CloudOperationCallback callback))}替代
	 *
	 */
	public void downloadFile(final String remoteFilePath, final String localFilePath, final String appId,
			final Map<String, String> headers, final CloudOperationCallback callback) {
		if (TextUtils.isEmpty(remoteFilePath)) {
			if (callback != null)
				callback.onError("remotefilepath is null or empty");
			EMLog.e(TAG, "remotefilepath is null or empty");
		}else{
			String remoteUrl = HttpClientConfig.getFileRemoteUrl(remoteFilePath);
			downloadFile(remoteUrl, localFilePath, headers, callback);
		}
	}
	
	/**
	 * 由于此类不再对外开放
	 * 
	 * 请用 {@link EMChatManager downloadFile}代替
	 * @param remoteUrl
	 * @param localFilePath
	 * @param headers
	 * @param callback
	 */
	public void downloadFile(String remoteUrl, final String localFilePath, final Map<String, String> headers,
			final CloudOperationCallback callback){
		try{
			downloadFileWithCountDown(remoteUrl,localFilePath,headers,callback,max_retry_times_on_connection_refused);
		}catch(Exception e){
			String errorMsg = "failed to download file : " + remoteUrl;
			
			if(e != null && e.toString() != null){
				errorMsg = e.toString();
			}
			
			if(callback != null){
				callback.onError(errorMsg);
			}
		}
	}
	
	/**
	 * download a remote file to local storage.
	 * @param remoteUrl remote file to download
	 * @param localFilePath local file path to store
	 * @param headers  http headers
	 * @param callback operation listener
	 */
	private void downloadFileWithCountDown(String remoteUrl, final String localFilePath, final Map<String, String> headers,
			final CloudOperationCallback callback, int countDown) {
		
		if(remoteUrl == null || remoteUrl.length() <= 0){
			callback.onError("invalid remoteUrl");
			return;
		}
		
		final Map<String, String> _headers = HttpClientManager.addDomainToHeaders(headers);
		
		remoteUrl = HttpClientConfig.getFileRemoteUrl(remoteUrl);

		EMLog.d(TAG, "remoteUrl:" + remoteUrl + " localFilePath:" + localFilePath);
		remoteUrl = processUrl(remoteUrl);
		
		EMLog.d(TAG, "download file: remote url : " + remoteUrl + " , local file : " + localFilePath);
		
		File file = new File(localFilePath);
		
		EMLog.d(TAG, "local exists:" + file.exists());
		
		if (!file.getParentFile().exists()) {
			file.getParentFile().mkdirs();
		}

//		EMTimeTag tag = new EMTimeTag();
//		tag.start();
		
		int timeout = HttpClientConfig.getTimeout(_headers);
		
		DefaultHttpClient client = HttpClientConfig.getDefaultHttpClient(timeout);

		try {
			HttpGet request = new HttpGet(remoteUrl);
			
			processHeaders(request,_headers);
			
			HttpClientManager.checkAndProcessSSL(remoteUrl, client);
			
			HttpResponse response = client.execute(request);
			int responseCode = response.getStatusLine().getStatusCode();
			
			switch(responseCode){
			    case HttpStatus.SC_OK:
			    {
			    	long size = onDownloadCompleted(response,callback,localFilePath);
					
					if(size <= 0){
						if(callback != null){
							callback.onError("downloaded content size is zero!");
						}
						
						return;
					}
					
//					tag.stop();
//					
//					if(tag.timeSpent() > 0){						
//						EMPerformanceCollector.collectDownloadFileTime(tag, size, remoteUrl);
//					}
					
					if (callback != null) {				
						callback.onSuccess("download successfully");
					}
					
			    	break;
			    }
			    	
			    case HttpStatus.SC_UNAUTHORIZED:
			    {
			    	// in case SC_UNAUTHORIZED, we think this would be caused by invalid token
				    // so firstly, we need to retrieve token again and check, if token is retrieved but still failed
					// we will report a failure

					long tokenSaveTime = EMHttpClient.getInstance().chatConfig().getTokenSaveTime();
					
					// in case we have retrieved 10 minutes before, we just report an error
					if((System.currentTimeMillis()-tokenSaveTime) <= 10*60*1000){
						if (callback != null){
							callback.onError("unauthorized file");	
						}
						return;
					}

					if(tokenRetrieved){
						if (callback != null){
							callback.onError("unauthorized file");	
						}
						return;
					}

					final String fRemoteUrl = remoteUrl;
					
					// we start a new thread to retrieve a new token and download again
					new Thread() {
						@Override
						public void run() {
//							String token = EMInternalConfigManager.getInstance().retryToGetToken();
							boolean getFromServer = true;
							String token = EMClient.getInstance().getOptions().getAccessToken(getFromServer);
							if(token == null){
								callback.onError("unauthorized token is null");
								return;
							}
							
							tokenRetrieved = true;
							if (_headers != null) {
								_headers.put("Authorization", "Bearer " + token);
								downloadFile(fRemoteUrl, localFilePath,
										_headers, callback);
							} else {
								tokenRetrieved = false;
								if (callback != null)
									callback.onError("unauthorized token is null");
							}

						}
					}.start();
					
			    	break;
			    }
			    	
			    default:
			    {
			    	EMLog.e(TAG, "error response code is :" + responseCode);
					
					if (callback != null){
						callback.onError(String.valueOf(responseCode));
					}
					
			    	break;	
			    }
			}
		} catch (Exception e) {
		    String errorMsg = e.getMessage();
		    if(errorMsg == null){
		    	errorMsg = e.toString();
		    	
		    	if(errorMsg == null){
		    		errorMsg = "failed to download file";
		    	}
		    }
		    
            if(errorMsg.toLowerCase().contains(EMPrivateConstant.CONNECTION_REFUSED) && NetUtils.hasNetwork(appContext)) {
            	if(countDown > 0){
        			String baseUrl = EMHttpClient.getInstance().chatConfig().getNextAvailableBaseUrl();
        			final String url = HttpClientManager.getNewHost(remoteUrl, baseUrl);
            		final int fcountDown = --countDown;
            		new Thread(){
            			@Override
            			public void run(){
            				try{
            					downloadFileWithCountDown(url,localFilePath,_headers,callback,fcountDown);
            				}catch(Exception e){
            					if(e != null && e.toString() != null){
            						callback.onError(e.toString());
            					}else{
            						callback.onError("failed to download the file : " + url);
            					}
            				}
            				
            			}
            		}.start();
            		
            		return;
            	}
            }
		    
		    EMLog.e(TAG, errorMsg);
			
			if (callback != null){
				callback.onError(errorMsg);	
			}
		}
	}

	private String processUrl(String remoteUrl){
		if (remoteUrl.contains("+")) {
			remoteUrl = remoteUrl.replaceAll("\\+", "%2B");
		}
		
		if (remoteUrl.contains("#")) {
			remoteUrl = remoteUrl.replaceAll("#", "%23");
		}
		
		return remoteUrl;
	}
	
	private void processHeaders(HttpGet request, Map<String, String> headers){
		request.addHeader("Authorization", "Bearer " + EMClient.getInstance().getOptions().getAccessToken());
		request.addHeader("Accept", "application/octet-stream");
		
		
		if (headers != null) {
			for (Entry<String, String> item : headers.entrySet()) {
				if(item.getKey().equals("Authorization")||item.getKey().equals("Accept")){
					continue;
				}
				request.addHeader(item.getKey(), item.getValue());
			}
		}
	}
	
    private long onDownloadCompleted(HttpResponse response, final CloudOperationCallback callback, final String localFilePath) throws IOException, IllegalStateException{
    	HttpEntity entity = response.getEntity();
    	
    	if(entity == null){
    		return 0;
    	}
    	
    	InputStream input = null;
		OutputStream output = null;
		
    	int count = 0;
    	int current_progress = 0;

    	// get file length
		long fileLength = entity.getContentLength();

		try {
			input = entity.getContent();
		} catch (IllegalStateException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw e;
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw e;
		}
		
		File outputFile = new File(localFilePath);
		
		try {
			output = new FileOutputStream(outputFile);
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			input.close();
			
			throw e;
		}
		
		int bufSize = NetUtils.getDownloadBufSize(appContext);
		byte[] buffer = new byte[bufSize];
		long total = 0;
		
		try {
			while ((count = input.read(buffer)) != -1) {
				total += count;
				int progress = (int) ((total * 100) / fileLength);
				EMLog.d("HttpFileManager", progress + "");
				if (progress == 100 || progress > current_progress + 5) {
					current_progress = progress;
					if (callback != null)
						callback.onProgress(current_progress);
				}
				output.write(buffer, 0, count);
			}
			
			return outputFile.length();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw e;
		} finally{
			output.close();
			input.close();
		}
    }
    
	
	/**
	 * delete a file on remote storage. it is async operation within a thread
	 * @param remoteFilePath
	 * @param callback operation callback
	 * @deprecated 不再对外开放
	 */
	@Override
	public void deleteFileInBackground(final String remoteFilePath, final String appId, final String jid,
			final CloudOperationCallback callback) {
		Thread workerThread = new Thread() {
			public void run() {

				HttpURLConnection conn = null;
				DataOutputStream outputStream = null;
				String lineEnd = "\r\n";
				String twoHyphens = "--";
				String boundary = "*****";
				String remoteUrl = "";
				remoteUrl = HttpClientConfig.getFileRemoteUrl(remoteFilePath);
				try {

					URL url = new URL(remoteUrl);
					conn = (HttpURLConnection) url.openConnection();

					// allow inputs and outputs
					conn.setDoInput(true);
					conn.setDoOutput(true);
					conn.setUseCaches(false);

					conn.setRequestMethod("POST");

					conn.setRequestProperty("Connection", "Keep-Alive");
					conn.setRequestProperty("ENCTYPE", "multipart/form-data");
					conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
					conn.setRequestProperty("file", remoteFilePath);

					outputStream = new DataOutputStream(conn.getOutputStream());
					outputStream.writeBytes(twoHyphens + boundary + lineEnd);
					if (appId != null) {
						outputStream.writeBytes("Content-Disposition: form-data; name=\"app\"" + lineEnd + lineEnd);
						outputStream.writeBytes(appId + lineEnd);
						outputStream.writeBytes(twoHyphens + boundary + lineEnd);
					}
					outputStream.writeBytes("Content-Disposition: form-data; name=\"file\";filename=\"" + remoteFilePath + "\"" + lineEnd);
					outputStream.writeBytes(lineEnd);

					BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
					String line;
					while ((line = rd.readLine()) != null) {
						EMLog.d(TAG, "RESULT Message: " + line);
					}
					rd.close();

					outputStream.close();
					conn.disconnect();
					if (callback != null) {
						callback.onSuccess(null);
					}
				} catch (Exception e) {
					e.printStackTrace();
					if (callback != null) {
						callback.onError(e.toString());
					}
				}
			}
		};
		workerThread.start();

	}
}
