package com.hyphenate.chat.adapter.message;

public class EMAVoiceMessageBody extends EMAFileMessageBody {

	public EMAVoiceMessageBody(String localPath, int duration) {
		super(localPath, EMAMessageBodyType_VOICE);
		nativeInit(localPath, duration);
	}
	
	public EMAVoiceMessageBody(EMAVoiceMessageBody body) {
		super("", EMAMessageBodyType_VOICE);
		nativeInit(body);
	}
	
	// used by jni_util.cpp: getJObject
	private EMAVoiceMessageBody(){
		super("", EMAMessageBodyType_VOICE);
		nativeInit("", 0);
	}
	
	public int duration() {
		return nativeDuration();
	}
	native int nativeDuration();
	
	public void setDuration(int duration) {
		nativeSetDuration(duration);
	}
	native void nativeSetDuration(int duration);
	
	@Override
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}
	
	native void nativeInit(String localPath, int duration);
	native void nativeInit(EMAVoiceMessageBody body);
	native void nativeFinalize();
	
}
