package com.hyphenate.chat.adapter.message;

import com.hyphenate.chat.adapter.EMACallback;

public class EMAFileMessageBody extends EMAMessageBody {

	public final static int EMDownloadStatus_DOWNLOADING = 0;
	public final static int EMDownloadStatus_SUCCESSED = 1;
	public final static int EMDownloadStatus_FAILED = 2;
	public final static int EMDownloadStatus_PENDING = 3;

	public enum EMADownloadStatus {
		DOWNLOADING,
		SUCCESSED,
		FAILED,
		PENDING
	}

	public EMAFileMessageBody(String localPath) {
		this(localPath, EMAMessageBodyType_FILE);
	}

	// used by jni_util.cpp: getJObject
	private EMAFileMessageBody() {
		this("", EMAMessageBodyType_FILE);
	}
	
	public EMAFileMessageBody( String localPath, int type) {
		if (type == EMAMessageBodyType_FILE) {
			nativeInit(localPath, type);
		}
		this.type = type;
	}
	
	public EMAFileMessageBody(EMAFileMessageBody body) {
		nativeInit(body);
	}

	@Override
	public void finalize() throws Throwable {
		if (type == EMAMessageBodyType_FILE) {
			nativeFinalize();
		}
		super.finalize();
	}

	/**
	 * \brief Get display name of the attachment.
	 *
	 * @param  NA
	 * @return The display name.
	 */
	public String displayName() {
		return nativedisplayName();
	}
	native String nativedisplayName();

	/**
	 * \brief Set display name of the attachment.
	 *
	 * @param  The display name.
	 * @return NA
	 */
	public void setDisplayName( String displayName) {
		nativesetDisplayName(displayName);
	}
	native void nativesetDisplayName( String displayName);

	/**
	 * \brief Get local path of the attachment.
	 *
	 * @param  NA
	 * @return The local path.
	 */
	public String getLocalUrl() {
		return nativelocalPath() ;
	}native String nativelocalPath() ;

	/**
	 * \brief Set local path of the attachment.
	 *
	 * Note: Received meesage should NOT change the local path.
	 * @param  The local path.
	 * @return NA
	 */
	public void setLocalPath( String localPath) { 
		nativesetLocalPath(localPath); 
	}
	native void nativesetLocalPath( String localPath);

	/**
	 * \brief Get remote path of the attachment.
	 *
	 * @param  NA
	 * @return The remote path.
	 */
	public String getRemoteUrl() {
		return nativeremotePath();
	}
	native String nativeremotePath();

	/**
	 * \brief Set remote path of the attachment.
	 *
	 * Note: It's internal used, user should never need to call this method.
	 * @param  The remote path.
	 * @return NA
	 */
	public void setRemotePath( String remotePath) {
		nativesetRemotePath( remotePath);
	}
	native void nativesetRemotePath( String remotePath);

	/**
	 * \brief Get secret key of the attachment, it's used to download attachment from server.
	 *
	 * @param  NA
	 * @return The secret key.
	 */
	public String getSecret(){
		return nativesecretKey() ;
	}
	native String nativesecretKey() ;

	/**
	 * \brief Set secret key of the attachment.
	 *
	 * Note: It's internal used, user should never need to call this method.
	 * @param  The secret key.
	 * @return NA
	 */
	public void setSecretKey( String secreyKey) {
		nativesetSecretKey( secreyKey );
	}
	native void nativesetSecretKey( String secreyKey);

	/**
	 * \brief Get file length of the attachment.
	 *
	 * @param  NA
	 * @return The file length.
	 */
	public long fileLength() {
		return nativefileLength();
	}
	native long nativefileLength() ;

	/**
	 * \brief Set file length of the attachment.
	 *
	 * Note: It's usually not necessary to call this method, will calculate file length automatically when setting local path.
	 * @param  The file length.
	 * @return NA
	 */
	public void setFileLength(long length) {
		nativesetFileLength(length);
	}
	native void nativesetFileLength(long length);

	/**
	 * \brief Get file download status of the attachment.
	 *
	 * @param  NA
	 * @return The file download status.
	 */
	public EMADownloadStatus downloadStatus() {
		int s = nativedownloadStatus();
        if (s == EMADownloadStatus.DOWNLOADING.ordinal()) {
            return EMADownloadStatus.DOWNLOADING;
        } else if (s == EMADownloadStatus.SUCCESSED.ordinal()) {
            return EMADownloadStatus.SUCCESSED;
        } else if (s == EMADownloadStatus.FAILED.ordinal()) {
            return EMADownloadStatus.FAILED;
        } else {
            return EMADownloadStatus.PENDING;
        }
	}
	native int nativedownloadStatus();

	/**
	 * \brief Set download status of the attachment.
	 *
	 * Note: Usually, user should NOT call this method directly.
	 * @param  The download status.
	 * @return NA
	 */
	public void setDownloadStatus(EMADownloadStatus status) {
//		int s = 0;
		// TODO:
		// switch (status)
		int s = status.ordinal();
		nativesetDownloadStatus(s);
	}
	native void nativesetDownloadStatus(int status);

	// TODO: jni
	public void setDownloadCallback(EMACallback callback) {
		nativeSetDownloadCallback(callback);
	}
	native void nativeSetDownloadCallback(EMACallback callback);

	native void nativeInit(String localPath, int type);
	native void nativeInit(EMAFileMessageBody body);
	native void nativeFinalize();
}
