package com.hyphenate.chat.adapter;

import java.util.List;

public interface EMAGroupManagerListenerInterface {

    /**
     * \brief Callback user when user is invited to a group.
     *
     * Note: User can accept or decline the invitation.
     * @param  The group that invite the user.
     * @param  The inviter.
     * @param  The invite message.
     * @return NA
     */
    void onReceiveInviteFromGroup(String groupId, String inviter, String inviteMessage);

    /**
     * \brief Callback user when the user accept to join the group.
     *
     * @param  The group that invite the user.
     * @return NA
     */
   void onReceiveInviteAcceptionFromGroup(EMAGroup group, String invitee);
   
   /**
     * \brief Callback user when the user decline to join the group.
     *
     * @param  The group that invite the user.
     * @param  User's decline reason.
     * @return NA
     */
   void onReceiveInviteDeclineFromGroup(EMAGroup group, String invitee, String reason);
   
    /**
     * \brief Callback user when user is invited to a group.
     *
     * Note: User has been added to the group when received this callback.
     * @param  The group that invite the user.
     * @param  The inviter.
     * @param  The invite message.
     * @return NA
     */
    void onAutoAcceptInvitationFromGroup(EMAGroup group, String inviter, String inviteMessage);

    /**
     * \brief Callback user when user is kicked out from a group or the group is destroyed.
     *
     * @param  The group that user left.
     * @param  The leave reason.
     * @return NA
     */
    void onLeaveGroup(EMAGroup group, /*EMAGroup.EMGroupLeaveReason*/ int reason);

    /**
     * \brief Callback user when receive a join group application.
     *
     * @param  The group that user try to join.
     * @param  User that try to join the group.
     * @param  The apply message.
     * @return NA
     */
    void onReceiveJoinGroupApplication(EMAGroup group, String from, String message);

    /**
     * \brief Callback user when receive owner's approval.
     *
     * @param  The group to join.
     * @return NA
     */
    void onReceiveAcceptionFromGroup(EMAGroup group);

    /**
     * \brief Callback user when receive group owner's rejection.
     *
     * @param  The group that user try to join.
     * @param  Owner's reject reason.
     * @return NA
     */
    void onReceiveRejectionFromGroup(String groupId, String reason);

    /**
     * \brief Callback user when login user's group list is updated.
     *
     * @param  The login user's group list.
     * @return NA
     */
    void onUpdateMyGroupList(List<EMAGroup> groups);
}
