package com.hyphenate.chat.adapter;

import java.util.List;

public abstract class EMAGroupManagerListener extends EMABase implements EMAGroupManagerListenerInterface {

	public EMAGroupManagerListener() {
		nativeInit();
	}
	
	@Override
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}
	
	/**
	 * create native listener class which implements EMContactListener interface.
	 */
	native void nativeInit();
	native void nativeFinalize();

	@Override
    public void onReceiveInviteFromGroup(String groupId, String inviter, String inviteMessage) {}
	
	/**
	 * \brief Callback user when the user accept to join the group.
	 *
	 * @param  The group that invite the user.
	 * @return NA
	 */
	@Override
    public
	void onReceiveInviteAcceptionFromGroup(EMAGroup group, String invitee) {}
   
   /**
     * \brief Callback user when the user decline to join the group.
     *
     * @param  The group that invite the user.
     * @param  User's decline reason.
     * @return NA
     */
	@Override
    public
	void onReceiveInviteDeclineFromGroup(EMAGroup group, String invitee, String reason) {}
    
	@Override
	public void onAutoAcceptInvitationFromGroup(EMAGroup group, String inviter, String inviteMessage) {}

	@Override
	public void onLeaveGroup(EMAGroup group, int reason) {
	}

	@Override
	public void onReceiveJoinGroupApplication(EMAGroup group, String from, String message) {
	}

	@Override
	public void onReceiveAcceptionFromGroup(EMAGroup group) {
	}

	@Override
	public void onReceiveRejectionFromGroup(String groupId, String reason) {
	}

	@Override
	public void onUpdateMyGroupList(List<EMAGroup> groups) {
	}


}
