package com.hyphenate.chat.adapter;

import java.util.List;


public class EMAGroup extends EMABase {
	
    public enum EMGroupLeaveReason {
        BE_KICKED,      //User is kicked out by the group owner
        DESTROYED       //Group was destroyed by the group owner.
    }

	public final static int EMGroupLeaveReason_BE_KICKED = 0;
	public final static int EMGroupLeaveReason_DESTROYED = 1;
	
	public EMAGroup(EMAGroup group) {
		nativeInit(group);
	}
	
    public String groupId() {
    	return nativeGroupId();
    }
    
    native String nativeGroupId();
    
    public String getDescription() {
    	return nativeGroupDescription();
	}
    native String nativeGroupDescription();
    
    
    public String getOwner() {
    	return nativeGroupOwner();
    }
    native String nativeGroupOwner();
    
    
    public EMAGroupSetting groupSetting() {
    	return nativeGroupSetting();
    }
    native EMAGroupSetting nativeGroupSetting();
    
    
    public int getAffiliationsCount() {
    	return nativeGroupMembersCount();
    }
    native int nativeGroupMembersCount();
    
    
    public boolean isPushEnabled() {
    	return nativeIsPushEnabled();
    }
    native boolean nativeIsPushEnabled();
    
    
    public boolean isMsgBlocked() {
    	return nativeIsMessageBlocked();
    }
    native boolean nativeIsMessageBlocked();
    
    public List<String> getMembers() {
        return nativeGroupMembers();
    }
    native List<String> nativeGroupMembers();
    
    public List<String> groupBans() {
    	return nativeGroupBans();
    }
    native List<String> nativeGroupBans();
    
    // TODO: begin
	public void setGroupName(String name) {
		nativesetGroupName(name);
	}
	native void nativesetGroupName(String name);
	
	public void setOwner(String owner) {
		nativesetOwner(owner);
	}
	native void nativesetOwner(String owner);
//	public void setLastModifiedTime(long time) {
//		nativesetLastModifiedTime(time);
//	}
//	native void nativesetLastModifiedTime(long time);
//	public void setIsPublic(boolean isPublic) {
//		nativesetIsPublic(isPublic);
//	}
//	native void nativesetIsPublic(boolean isPublic);
	public void setDescription(String desc) {
		nativesetDescription(desc);
	}
	native void nativesetDescription(String desc);
	public void setAffiliationsCount(int count) {
		nativesetAffiliationsCount(count);
	}
	native void nativesetAffiliationsCount(int count);
	public void setMsgBlocked(boolean isBlocked) {
		nativesetMsgBlocked(isBlocked);
	}
	native void nativesetMsgBlocked(boolean isBlocked);
	public void setMaxUsers(int count) {
		nativesetMaxUsers(count);
	}
	native void nativesetMaxUsers(int count);
	public void addMember(String member) {
		nativeaddMember(member);
	}
	native void nativeaddMember(String member);
	// TODO: end
	
//	public void setEid(String eid) {
//		nativesetEid(eid);
//	}
//	native void nativesetEid(String eid);
	
	public EMAGroup() {
		nativeInit();
	}
	
	// TODO
	public String groupSubject() {
		return nativegroupSubject();
	}
	native String nativegroupSubject();
	
	@Override
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}
	
	native void nativeInit();
	native void nativeInit(EMAGroup group);
	native void nativeFinalize();

}
