package com.hyphenate.chat.adapter;

import java.util.List;

import com.hyphenate.chat.adapter.message.EMAMessage;

public class EMAConversation extends EMABase {

	public enum  EMAConversationType {
        CHAT,               //single chat
        GROUPCHAT,          //group chat
        CHATROOM,           //chatroom chat
        DISCUSSIONGROUP,    //discussion group chat
        HELPDESK,           //help desk chat
	}
	public enum EMASearchDirection {
		UP,
		DOWN
	}
		
	public EMAConversation(EMAConversation conversation) {
		nativeInit(conversation);
	}

	public final static int EMAConversationType_CHAT = 0;
	public final static int EMAConversationType_GROUPCHAT = 1;
	public final static int EMAConversationType_CHATROOM = 2;
	public final static int EMAConversationType_DISCUSSIONGROUP = 3;
	public final static int EMAConversationType_HELPDESK = 4;
	
	public String conversationId() {
		return nativeConversationId();
	}
	public EMAConversationType _getType() {
		int t = nativeConversationType();
		if (t == EMAConversationType_CHAT) {
			return EMAConversationType.CHAT;
		}
		if (t == EMAConversationType_GROUPCHAT) {
			return EMAConversationType.GROUPCHAT;
		}
		if (t == EMAConversationType_CHATROOM) {
			return EMAConversationType.CHATROOM;
		}
		if (t == EMAConversationType_DISCUSSIONGROUP) {
			return EMAConversationType.DISCUSSIONGROUP;
		}
		if (t == EMAConversationType_HELPDESK) {
			return EMAConversationType.HELPDESK;
		}
		return EMAConversationType.CHAT;
	}
	public boolean _removeMessage(String msgId) {
		return nativeRemoveMessage(msgId);
	}
	
	public boolean removeMessage(EMAMessage msg) {
		return nativeRemoveMessage(msg);
	}
	
	public boolean insertMessage(EMAMessage msg) {
		return nativeInsertMessage(msg);
	}
	
	public boolean appendMessage(EMAMessage msg) {
		return nativeInsertMessage(msg);
	}
	
	public boolean updateMessage(EMAMessage msg) {
		return nativeUpdateMessage(msg);
	}
	
	public boolean clearAllMessages() {
		return nativeClearAllMessages();
	}
	
	public boolean markMessageAsRead(String msgId, boolean isRead) {
		return nativeMarkMessageAsRead(msgId, isRead);
	}
	public boolean markAllMessagesAsRead(boolean isRead) {
		return nativeMarkAllMessagesAsRead(isRead);
	}
	public int unreadMessagesCount() {
		return nativeUnreadMessagesCount();
	}
	public int messagesCount() {
		return nativeMessagesCount();
	}
	public EMAMessage loadMessage(String msgId) {
		return nativeLoadMessage(msgId);
	}
	public EMAMessage latestMessage() {
		return nativeLatestMessage();
	}
	public List<EMAMessage> loadMoreMessages(String refMsgId, int maxCount, EMASearchDirection direction) {
		return nativeLoadMoreMessages(refMsgId, maxCount, direction.ordinal());
	}
	public List<EMAMessage> searchMessages(long timeStamp, int maxCount, EMASearchDirection direction) {
		return nativeSearchMessages(timeStamp, maxCount, direction.ordinal());
	}
	public List<EMAMessage> searchMessages(int type, long timeStamp, int maxCount, String from, EMASearchDirection direction) {
		return nativeSearchMessages(type, timeStamp, maxCount, from, direction.ordinal());
	}
	public List<EMAMessage> searchMessages(String keywords, long timeStamp, int maxCount, String from, EMASearchDirection direction) {
		return nativeSearchMessages(keywords, timeStamp, maxCount, from, direction.ordinal());
	}
	public List<EMAMessage> searchMessages(long startTimeStamp, long endTimeStamp, int maxCount) {
		return nativeSearchMessages(startTimeStamp, endTimeStamp, maxCount);
	}
	public String extField() {
		return nativeExtField();
	}
	public boolean _setExtField(String ext) {
		return nativeSetExtField(ext);
	}

	//-------------------- native --------------------
	native String nativeConversationId();
	native int nativeConversationType();
	native boolean nativeRemoveMessage(String msgId);
	native boolean nativeRemoveMessage(EMAMessage msg);
	native boolean nativeInsertMessage(EMAMessage msg);
	native boolean nativeAppendMessage(EMAMessage msg);
	native boolean nativeUpdateMessage(EMAMessage msg);
	native boolean nativeClearAllMessages();
	native void nativeClearCachedMessages();
	native boolean nativeMarkMessageAsRead(String msgId, boolean isRead);
	native boolean nativeMarkAllMessagesAsRead(boolean isRead);
	native int nativeUnreadMessagesCount();
	native int nativeMessagesCount();
	native EMAMessage nativeLoadMessage(String msgId);
	native EMAMessage nativeLatestMessage();
	native List<EMAMessage> nativeLoadMoreMessages(String refMsgId, int count, int direction);
	native List<EMAMessage> nativeSearchMessages(long timeStamp, int count, int direction);
	native List<EMAMessage> nativeSearchMessages(int type, long timeStamp, int count, String from, int direction);
	native List<EMAMessage> nativeSearchMessages(String keywords, long timeStamp, int count, String from, int direction);
	native List<EMAMessage> nativeSearchMessages(long startTimeStamp, long endTimeStamp, int maxCount);
	native String nativeExtField();
	native boolean nativeSetExtField(String ext);
	
	public EMAConversation() {
		nativeInit();
	}
	
	@Override
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}
	
	native void nativeInit();
	native void nativeInit(EMAConversation conversation);
	native void nativeFinalize();
}
