package com.hyphenate.chat.adapter;

public interface EMAChatRoomManagerListenerInterface {
  /**
    * \brief Callback user when user is kicked out from a chatroom or the chatroom is destroyed.
    *
    * @param  The chatroom that user left.
    * @param  The leave reason.
    * @return NA
    */
  void onLeaveChatRoom(EMAChatRoom chatroom, int leaveReason);
  
  /**
    * \brief Callback user when a user join the chatroom.
    *
    * @param  The chatroom that user joined.
    * @param  The member.
    * @return NA
    */
  void onMemberJoinedChatRoom(EMAChatRoom chatroom, String member);
  
  /**
    * \brief Callback user when a user leave the chatroom.
    *
    * @param  The chatroom that user left.
    * @param  The member.
    * @return NA
    */
  void onMemberLeftChatRoom(EMAChatRoom chatroom, String member);

}
