package com.hyphenate.chat.adapter;

import java.util.List;

import com.hyphenate.chat.EMCursorResult;
import com.hyphenate.chat.EMPageResult;
import com.hyphenate.chat.EMChatRoom;

public class EMAChatRoomManager extends EMABase {
    /**
     * \brief Add a listener to chatroom manager.
     *
     * @param  A chatroom manager listener.
     * @return NA
     */
   public void addListener(EMAChatRoomManagerListener listener) {
	   nativeAddListener(listener);
   }
   native void nativeAddListener(EMAChatRoomManagerListener listener);
   
   /**
     * \brief Remove a listener.
     *
     * @param  A chatroom manager listener.
     * @return NA
     */
   public void removeListener(EMAChatRoomManagerListener listener) {
	   nativeRemoveListener(listener);
   }
   native void nativeRemoveListener(EMAChatRoomManagerListener listener);
   
   /**
     * \brief Remove all the listeners.
     *
     * @param  NA
     * @return NA
     */
   public void clearListeners() {
	   nativeClearListeners();
   }
   native void nativeClearListeners();
   
   /**
     * \brief Fetch app's chatrooms.
     *
     * @param  EMError used for output.
     * @return Chatroom list.
     */
   public List<EMAChatRoom> fetchAllChatrooms(EMAError error) {
	   return nativeFetchAllChatrooms(error);
   }
   
   native List<EMAChatRoom> nativeFetchAllChatrooms(EMAError error);
   
   public EMPageResult<EMAChatRoom> fetchChatroomsWithPage(int pageNum, int pageSize, EMAError error) {
       return nativefetchChatroomsWithPage(pageNum, pageSize, error);
   }
   native EMPageResult<EMAChatRoom> nativefetchChatroomsWithPage(int pageNum, int pageSize, EMAError error);
   
   /**
     * \brief Get chatroom's specification.
     *
     * @param  Chatroom's ID.
     * @param  EMError used for output.
     * @return The chatroom that update it's specification.
     */
   public EMAChatRoom fetchChatroomSpecification(String chatroomId, EMAError error, boolean fetchMembers) {
	   return nativeFetchChatroomSpecification(chatroomId, error, fetchMembers);
   }
   native EMAChatRoom nativeFetchChatroomSpecification(String chatroomId, EMAError error, boolean fetchMembers);
   
   /**
     * \brief Join a chatroom.
     *
     * @param  Chatroom's ID.
     * @param  EMError used for output.
     * @return The joined chatroom.
     */
   public EMAChatRoom joinChatRoom(String chatroomId, EMAError error) {
	   return nativeJoinChatRoom(chatroomId, error);
   }
   native EMAChatRoom nativeJoinChatRoom(String chatroomId, EMAError error);
   
   /**
     * \brief Leave a chatroom.
     *
     * @param  Chatroom's ID.
     * @param  EMError used for output.
     * @return The leaved chatroom.
     */
   public EMAChatRoom leaveChatRoom(String chatroomId,EMAError error) {
	   return nativeLeaveChatRoom(chatroomId, error);
   }
   native EMAChatRoom nativeLeaveChatRoom(String chatroomId,EMAError error);
   
   public EMAChatRoom getChatroom(String roomid){
	   return nativeGetChatroom(roomid);
   }
   
   native EMAChatRoom nativeGetChatroom(String roomid);

}
