package com.hyphenate.chat.adapter;

import java.util.ArrayList;
import java.util.List;

public class EMAChatRoom extends EMABase {
	
	public final static int EMChatroomLeaveReason_BE_KICKED = 0;
	public final static int EMChatroomLeaveReason_DESTROYED = 1;
	
	public enum EMLeaveReason {
		BE_KICKED,
		DESTROYED
	}
	
	public EMAChatRoom(EMAChatRoom room) {
		nativeInit(room);
	}
	
	public EMAChatRoom(String roomId) {
		nativeInit(roomId);
	}
	
    public String getId() {
    	return nativeChatroomId();
    }
    native String nativeChatroomId();

    public String getName() {
    	return nativeChatroomSubject();
    }
    native String nativeChatroomSubject();

    public String getDescription() {
    	return nativeChatroomDescription();
	}
    native String nativeChatroomDescription();
 
	public EMAChatRoom() {
		nativeInit();
	}
	
	// TODO begin
	public String getOwner() {
		return nativegetOwner();
	}
	native String nativegetOwner();
	
	public int getAffiliationsCount() {
		return nativegetAffiliationsCount();
	}
	native int nativegetAffiliationsCount();
	
	public List<String> getMemberList(){
	    return nativegetMemberList();
	}
	native List<String> nativegetMemberList();

	public int getMaxUsers() {
		return nativegetMaxUsers();
	}
	native int nativegetMaxUsers();
	
	public void setName(String name) {
		nativesetName(name);
	}
	native void nativesetName(String name);
	
	public void setOwner(String owner) {
		nativesetOwner(owner);
	}
	native void nativesetOwner(String owner);
	
	public void setDescription(String desc) {
		nativesetDescription(desc);
	}
	native void nativesetDescription(String desc);
	
	public void setAffiliationsCount(int count) {				
		nativesetAffiliationsCount(count);
	}
	native void nativesetAffiliationsCount(int count);
	
	public void setMaxUsers(int count) {
		nativesetMaxUsers(count);
	}
	native void nativesetMaxUsers(int count);
	// TODO end
	
	public List<String> getMembers() {
		// TODO: jni
		return new ArrayList<String>();
	}
	
	@Override
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}
	
	native void nativeInit();
	native void nativeInit(EMAChatRoom room);
	native void nativeInit(String id);
	native void nativeFinalize();
}
