package com.hyphenate.chat.adapter;

import com.hyphenate.EMCallBack;

public class EMACallback extends EMABase{
	private EMCallBack owner = null;
	
	public EMACallback(EMCallBack owner) {
		this.owner = owner;
		nativeInit();
	}
	
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}
	
	native void nativeInit();
	native void nativeFinalize();

	public void onSuccess() {
		if(owner != null){
			owner.onSuccess();
			owner = null;
		}
	}

	public void onError(int code, String error) {
		if(owner != null){
			owner.onError(code, error);
			owner = null;
		}
	}

	public void onProgress(int progress, String status) {
		if(owner != null){
			owner.onProgress(progress, status);
		}
		
	}
	
	void setOwner(EMCallBack owner){
		this.owner = owner;
	}
}
