package com.hyphenate.chat.adapter;

import java.util.List;

public class EMACallSession extends EMABase {
    public enum Type
    {
        VOICE,      //voice call
        VIDEO,      //video call
    }

    public enum ConnectType
    {
        NONE,       //Initial value
        DIRECT,     //direct
        RELAY,      //relay
    }

    public enum Status
    {
        DISCONNECTED,               //Disconnected, initial value
        RINGING,                    //Ringing
        //ANSWERING,                //Answering
        //PAUSING,                  //Pausing
        CONNECTING,                 //Connecting
        CONNECTED,                  //Connected
        ACCEPTED,                   //Accepted
    }

    public enum EndReason
    {
        HANGUP,                     //hang up
        NORESPONSE,                 //no response
        REJECT,                     //reject
        BUSY,                       //busy
        FAIL,                       //fail
    };
    
    public enum StreamControlType
    {
        PAUSE_VOICE,
        RESUME_VOICE,
        PAUSE_VIDEO,
        RESUME_VIDEO,
    };
    
    public enum Mode
    {
        NORMAL,                     // normal 1v1 
        CONFERENCE_1v1,             // conference 1v1, calling API is same with Normal, use makeCall, distinguish with NORMAL by server's configure 
        CONFERENCE,                 // multiple person joined conference
    };
    
    public enum NetworkStatus
    {
        CONNECTED,
        UNSTABLE,
        DISCONNECTED,        
    };

    
    public Type getType() {
        int ordinal = nativeGetType();
        if (ordinal == Type.VOICE.ordinal()) {
            return Type.VOICE;
        } else {
            return Type.VIDEO;
        }
    }
    native int nativeGetType();
    
    public ConnectType getConnectType() {
        int ordinal = nativeGetConnectType();
        if (ordinal == ConnectType.DIRECT.ordinal()) {
            return ConnectType.DIRECT;
        } else if (ordinal == ConnectType.RELAY.ordinal()) {
            return ConnectType.RELAY;
        } else {
            return ConnectType.NONE;
        }
    }
    native int nativeGetConnectType();
    
    public String getCallId() {
        return nativeGetCallId();
    }
    native String nativeGetCallId();
    
    public String getLocalName() {
        return nativeGetLocalName();
    }
    native String nativeGetLocalName();
    
    public String getRemoteName() {
        return nativeGetRemoteName();
    }
    native String nativeGetRemoteName();
    
    public String getExt() {
        return nativeGetExt();
    }
    native String nativeGetExt();
    
    public Status getStatus() {
        int _status = nativeGetStatus();
        Status status = Status.DISCONNECTED;
        switch (_status) {
        case 0:
            status = Status.DISCONNECTED;
            break;
        case 1:
            status = Status.RINGING;
            break;
        case 2:
            status = Status.CONNECTING;
            break;
        case 3:
            status = Status.CONNECTED;
            break;
        case 4:
            status = Status.ACCEPTED;
            break;
        default:
            break;
        }
        return status;
    }
    
    native int nativeGetStatus();
    
    public EMACallSession() {
        nativeInit();
    }

    public EMACallSession(EMACallSession session) {
        nativeInit(session);
    }

    
    @Override
    public void finalize() throws Throwable {
        nativeFinalize();
        super.finalize();
    }
    
    native void nativeInit();
    native void nativeInit(EMACallSession conversation);
    native void nativeFinalize();

}
