package com.hyphenate.chat.adapter;
import com.hyphenate.chat.EMCallManager;
import com.hyphenate.util.EMLog;
import com.superrtc.sdk.RtcConnection;

import org.json.JSONException;
import org.json.JSONObject;

public class EMACallRtcImpl implements EMACallRtcInterface {
    public static final String TAG = "EMACallRtcImpl";
    
    RtcConnection rtcConnection;
    EMCallManager callManager;
    
    EMACallRtcImpl() {
    }
    
    public void setRtcConnection(EMCallManager call, RtcConnection rtc) {
        callManager = call;
        rtcConnection = rtc;
    }
    
    public RtcConnection getConnection() {
        return rtcConnection;
    }

    @Override
    public String getRtcId() {
        return rtcConnection.getName();
    }

    /* calltype */
    @Override
    public String getDefaultConfig(int typeOridinal) {
        //RtcConnection.Parameters params = RtcConnection.getDefaultParameters();
        
//        JSONObject initjson = new JSONObject();
//        try {
//            initjson.put("video", true);
//            initjson.put("videocodec", params.videoCodec);//"VP8");
//            initjson.put("width", params.videoWidth);//320);
//            initjson.put("heigth", params.videoHeight);//240);
//            initjson.put("framerate",params.videoFps);//15);
//            initjson.put("videomaxrate", 150); //150);
//            initjson.put("audio", true);
//            initjson.put("audiocodec", params.audioCodec); //"OPUS");
//            initjson.put("audiomaxrate", 24);
//            initjson.put("ice_uri", "turn:121.41.87.159:3478");
//            initjson.put("ice_username", "ling");
//            initjson.put("ice_password", "ling1234");
//            initjson.put("relay", "true");
        JSONObject initjson = new JSONObject();
        /*
        try {
            initjson.put("video", true);
            initjson.put("videocodec", "VP8");
            initjson.put("width", 320);
            initjson.put("heigth", 240);
            initjson.put("framerate",15);
            initjson.put("videomaxrate", 150);
            initjson.put("audio", true);
            initjson.put("audiocodec", "OPUS");
            initjson.put("audiomaxrate", 24);
            initjson.put("ice_uri", "turn:121.41.87.159:3478");
            initjson.put("ice_username", "ling2");
            initjson.put("ice_password", "ling1234");
            initjson.put("relay", true);
        } catch (JSONException e) {
            e.printStackTrace();
        }
            */
//        return initjson.toString();
        return "{}";
    }
    
    @Override
    public String getRtcReport() {
        try {
            return rtcConnection.getReportString();
        } catch (JSONException e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    @Override
    public String getSubConfig() {
        return "{}";
    }

    @Override
    public void createOffer() {
        rtcConnection.createOffer();
    }

    @Override
    public void answer() {
        rtcConnection.answer();
    }

    @Override
    public void hangup() {
        EMLog.d(TAG, "hangup");
        rtcConnection.hangup();
        if (callManager != null) {
            callManager.clearRtcConnection();
        }
    }

    @Override
    public void setStatsEnable(boolean statsEnable) {
        rtcConnection.setStatsEnable(statsEnable);
    }

    @Override
    public void setConfigJson(String config) {
        EMLog.d(TAG, "setConfigJson:" + config);
        if (config == null || config.isEmpty()) {
//            EMLog.d(TAG, "setConfigJson is empty");
//            return;
        }
        rtcConnection.setConfigure(config);
    }

    @Override
    public void setRemoteJson(String jsonStr) {
        try {
            EMLog.d(TAG, "setRemoteJson:" + jsonStr);
            rtcConnection.setRemoteJson(new String(jsonStr));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
