package com.hyphenate.chat.adapter;

import java.util.List;

public class EMACallConference extends EMABase {
    
    public String getCallId() {
        return nativeGetCallId();
    }
    native String nativeGetCallId();
    
    public String getLocalName() {
        return nativeGetLocalName();
    }
    native String nativeGetLocalName();
    
    public EMACallSession.Type getType() {
        int type = nativeGetType();
        if (type == EMACallSession.Type.VIDEO.ordinal()) {
            return EMACallSession.Type.VIDEO;
        } else if (type == EMACallSession.Type.VOICE.ordinal()) {
            return EMACallSession.Type.VOICE;
        }
        return EMACallSession.Type.VOICE;
    }
    native int nativeGetType();
    
    
    public List<EMACallStream> getSubscribableStreams() {
        return nativeGetSubscribableStreams();
    }
    native List<EMACallStream> nativeGetSubscribableStreams();
    
    
    public List<EMACallStream> getSubscribedStreams() {
        return nativeGetSubscribedStreams();
    }
    native List<EMACallStream> nativeGetSubscribedStreams();
    
    public void leave() {
        nativeLeave();
    }
    native void nativeLeave();
    
    public void close() {
        nativeClose();
    }
    native void nativeClose();
    
    public EMACallConference() {
        nativeInit();
    }

    public EMACallConference(EMACallConference conference) {
        nativeInit(conference);
    }

    
    @Override
    public void finalize() throws Throwable {
        nativeFinalize();
        super.finalize();
    }
    
    native void nativeInit();
    native void nativeInit(EMACallConference conference);
    native void nativeFinalize();
}
