package com.hyphenate.chat;

import com.hyphenate.util.EMLog;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

public class EMMonitorReceiver extends BroadcastReceiver{

    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if(Intent.ACTION_PACKAGE_REMOVED.equals(action) ){
            if(intent.getBooleanExtra(Intent.EXTRA_REPLACING, false))
                return;
            //update apps.db
            EMLog.d("EMMonitorReceiver", intent.getData().getSchemeSpecificPart() + " be removed");
            EMMonitor.getInstance().getMonitorDB().removeApp(intent.getData().getSchemeSpecificPart());
        }else{
            context.startService(new Intent(context, EMChatService.class));
        }
        
    }

    
}
