package com.hyphenate.chat;

import java.util.ArrayList;
import java.util.List;

import com.hyphenate.chat.core.EMMonitorDB;
import com.hyphenate.util.EasyUtils;

import android.content.Context;

class EMMonitor {
	private static EMMonitor _instance = null;
	private static String FILENAME = "pid";
	private static final String TAG = "EMMonitor";
	private boolean nativeServiceStarted = false;
	
	private boolean wakeuped;
	
	private EMMonitorDB monitorDB;
	
	private EMMonitor(){
	    monitorDB = new EMMonitorDB();
	}
	
	synchronized static EMMonitor getInstance(){
		if(_instance == null){
			_instance = new EMMonitor();
		}
		
		return _instance;
	}
	
	void start(Context context, String servicename){
	    if(!nativeServiceStarted){
	        startMonitor(servicename);
	        nativeServiceStarted = true;
	    }
	}

	boolean isStarted(){
		return nativeServiceStarted && wakeuped;
	}

	
	void startWakeup(Context context, String reason){
	    if(wakeuped || "wakeup".equals(reason))
	        return;
	    
	    wakeuped = true;
	    List<String> toWakeupList = new ArrayList<String>();
	    
        List<String> easembList = monitorDB.getAppList();
        List<String> runningList = EasyUtils.getRunningApps(context);
        for(String app : easembList){
            if(!runningList.contains(app)){
                app = app + "/" + EMChatService.class.getName();
                toWakeupList.add(app);
            }
        }
        if(toWakeupList.size() != 0){
            startWakeup(toWakeupList.toArray(new String[toWakeupList.size()]));
        }
	}
	
	EMMonitorDB getMonitorDB() {
        return monitorDB;
    }
	
    private native void startMonitor(String serviceName);
    
    private native void startWakeup(String[] serviceNameList);
}
