/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.chat;

import android.graphics.Bitmap;

import com.hyphenate.chat.adapter.EMAGroup;
import com.hyphenate.chat.adapter.EMAGroupSetting;

import java.util.ArrayList;
import java.util.List;

public class EMGroup extends EMBase<EMAGroup> {

    public EMGroup(EMAGroup group) {
        emaObject = group;
    }

    /**
     * \~chinese
     * 获取群ID
     * @return 群ID
     * 
     * \~english
     * get group id
     * @return group id
     */
    public String getGroupId() {
    	return emaObject.groupId();
    }
    
    /**
     * \~chinese
     * 获取群名称
     * @return
     * 
     * \~english
     * get group name
     * @return
     */
    public String getGroupName() {
    	return emaObject.groupSubject();
    }
    
    /**
     * \~chinese
     * 获取群组是否为公开群
     * @return
     * 
     * \~english
     * get whether the group is public 
     */
    public boolean isPublic() {

    	EMAGroupSetting setting = emaObject.groupSetting();
    	if (setting == null) {
    		return true;
    	}
    	switch (setting.style()) {
    	case EMAGroupSetting.EMAGroupStyle_PRIVATE_OWNER_INVITE:
    	case EMAGroupSetting.EMAGroupStyle_PRIVATE_MEMBER_INVITE:
    		return false;
    	default:
    		return true;
    	}
    }
    
    /**
     * \~chinese
     * 获取群组是否允许成员邀请
     * @return
     * @deprecated  使用 {@link EMGroup#isMemberAllowToInvite()} 替代
     * 
     * \~english
     * get whether the group member is allow invite the others
     * @return
     * @deprecated  use {@link EMGroup#isMemberAllowToInvite()} instead
     */
    @Deprecated
    public boolean isAllowInvites() {
        return isMemberAllowToInvite();
    }

    /**
     * \~chinese
     * 获取群组是否允许成员邀请
     * @return
     *
     * \~english
     * get whether the group member is allow invite the others
     * @return
     */
    public boolean isMemberAllowToInvite()
    {
    	EMAGroupSetting setting = emaObject.groupSetting();
    	if (setting == null) {
    		return true;
    	}
    	if (setting.style() == EMAGroupSetting.EMAGroupStyle_PRIVATE_MEMBER_INVITE) {
    		return true;
    	}
    	return false;
    }

    // TODO: need comments

    /**
     * \~chinese
     * 成员不能自由加入，与之对应的属性是除了EMGroupStylePublicOpenJoin之外的三种属性
     * @return
     * @deprecated  使用{@link EMGroup#isMemberOnly()}替代
     *
     * \~english
     * members can not auto join the group, need join group application approved or received invitation
     * corresponding group style is EMGroupStylePublicOpenJoin
     * @return
     * @deprecated  use {@link EMGroup#isMemberOnly()} instead
     */
    @Deprecated
    public boolean isMembersOnly() {
        return isMemberOnly();
    }

    /**
     * \~chinese
     * 成员不能自由加入，与之对应的属性是除了EMGroupStylePublicOpenJoin之外的三种属性
     * @return
     *
     * \~english
     * members can not auto join the group, need join group application approved or received invitation
     * corresponding group style is EMGroupStylePublicOpenJoin
     * @return
     */
    public boolean isMemberOnly()
    {
    	EMAGroupSetting setting = emaObject.groupSetting();
    	if (setting == null) {
    		return true;
    	}
    	if (setting.style() == EMAGroupSetting.EMAGroupStyle_PRIVATE_OWNER_INVITE ||
			setting.style() == EMAGroupSetting.EMAGroupStyle_PRIVATE_MEMBER_INVITE ||
			setting.style() == EMAGroupSetting.EMAGroupStyle_PUBLIC_JOIN_APPROVAL) {
    		return true;
    	}
    	return false;
    }
    

    Bitmap getGroupAvator() {
        //need to move this group avator two places
        //1. image utils. generate image by combine several images
        //2. in usersdk, use 1. to generate group avator
        Exception e = new Exception("group avator not supported yet");
        e.printStackTrace();
        return null;
    }
    
    void copyGroup(EMGroup group) {
//    	copyModel(group);
//    	this.isPublic = group.isPublic;
//    	this.allowInvites = group.allowInvites;
//    	this.membersOnly = group.membersOnly;
    }

    /**
     *@deprecated
     */
    public void setStyle(int style) {
    	EMAGroupSetting setting = emaObject.groupSetting();
    	if (setting == null) {
    		return;
    	}
    	setting.setStyle(style);
    }

    /**
     * \~chinese
     * 获取是否已屏蔽消息
     * @return
     * 
     * \~english
     * get whether the message is blocked
     */
    public boolean isMsgBlocked() {
        return emaObject.isMsgBlocked();
    }
     
    /**
     * \~chinese
     * 获取群创建者
     * @return
     * 
     * \~english
     * get the owner
     * @return
     */
    public String getOwner() {
        return emaObject.getOwner();
    }
      
     public String groupSubject() {
        return emaObject.groupSubject();
     }
      
     /**
      * \~chinese
      * 获取群成员列表
      * @return
      * 
      * \~english
      * get the member list
      * @return
      */
     public List<String> getMembers() {
         List<String> members = new ArrayList<String>();
         members.add(emaObject.getOwner());
         members.addAll(emaObject.getMembers());
         return members;
     }
      
     /**
      * \~chinese
      * 获取群简介
      * @return
      * 
      * \~english
      * get group description
      * @return
      */
     public String getDescription() {
        return emaObject.getDescription();
     }
      
     /**
      * @deprecated
      * \~chinese
      * 获取成员数量
      * @return
      * @deprecated  使用{@link EMGroup#getMemberCount()}替代
      * 
      * \~english
      * get the members size
      * @return
      * @deprecated  use {@link EMGroup#getMemberCount()} instead
      */
     @Deprecated
     public int getAffiliationsCount()
     {
        return emaObject.getAffiliationsCount();
     }

     public int getMemberCount()
     {
        return emaObject.getAffiliationsCount();
     }
      
     /**
      * \~chinese
      * 返回群组名称或者群组ID，此方法可用于Adapter排序
      * @return
      * 
      * \~english
      * return group name or group id, this method can be used for adapter sorting
      * @return
      */
     public String toString() {
         String str = getGroupName();
         return str != null ? str : getGroupId();
     }
}
