/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.chat;

import android.os.Parcel;
import android.os.Parcelable;

import com.hyphenate.chat.adapter.message.EMACmdMessageBody;

import java.util.Map;

/**
 * \~chinese
 * 创建一个命令消息
 * <pre>
 * EMCmdMessageBody body = new EMCmdMessageBody("delete", null);
 * </pre>
 * 
 * @version 2.0
 * 
 * \~english
 * create a command message
 * <pre>
 * EMCmdMessageBody body = new EMCmdMessageBody("delete", null);
 * </pre>
 *
 */
public class EMCmdMessageBody extends EMMessageBody implements Parcelable {
	
    /**
     * \~chinese
     * 创建一个命令消息
     * @param action cmd指令
     * 
     * \~english
     * construction of EMCmdMessageBody
     * @param action command
     */
    public EMCmdMessageBody(String action){
    	emaObject = new EMACmdMessageBody(action);
    }

    @Deprecated
    public EMCmdMessageBody(String action, Map<String, String> params){
        emaObject = new EMACmdMessageBody(action);
        ((EMACmdMessageBody)emaObject).setParams(params);
    }
    
    EMCmdMessageBody(EMACmdMessageBody body) {
    	this.emaObject = body;
    }
    
    /*!
     * \~chinese
     * 获取action
     * @return EMCallManager
     *
     * \~english
     * get the action
     * @return the action
     */
    public String action() {
    	return ((EMACmdMessageBody)emaObject).action();
    }

    public Map<String, String> getParams() { return ((EMACmdMessageBody)emaObject).params(); }
 
    public String toString() {
        return "cmd:\"" + ((EMACmdMessageBody)emaObject).action() + "\"";
    }

	@Override
	public int describeContents() {
		// TODO Auto-generated method stub
		return 0;
	}

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(((EMACmdMessageBody)emaObject).action());
    }
    
    public static final Parcelable.Creator<EMCmdMessageBody> CREATOR
            = new Parcelable.Creator<EMCmdMessageBody>() {
        public EMCmdMessageBody createFromParcel(Parcel in) {
            return new EMCmdMessageBody(in);
        }

        public EMCmdMessageBody[] newArray(int size) {
            return new EMCmdMessageBody[size];
        }
    };

    private EMCmdMessageBody(Parcel in) {
    	emaObject = new EMACmdMessageBody(in.readString());
    }

}
