package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMACallSession;

public class EMCallSession extends EMBase<EMACallSession> {
    public enum Type
    {
        VOICE,      //voice call
        VIDEO,      //video call
    }

    public enum ConnectType
    {
        NONE,       //Initial value
        DIRECT,     //direct
        RELAY,      //relay
    }

    public enum Status
    {
        DISCONNECTED,               //Disconnected, initial value
        RINGING,                    //Ringing
        //ANSWERING,                //Answering
        //PAUSING,                  //Pausing
        CONNECTING,                 //Connecting
        CONNECTED,                  //Connected
        ACCEPTED,                   //Accepted
    }

    public enum EndReason
    {
        HANGUP,                     //hang up
        NORESPONSE,                 //no response
        REJECT,                     //reject
        BUSY,                       //busy
        FAIL,                       //fail
        OFFLINE,
    }

    enum SessionInfoType{
        PAUSE_VOICE,
        RESUME_VOICE,
        PAUSE_VIDEO,
        RESUME_VIDEO,
    }
    
    EMACallSession emaObject;
    
    EMCallSession() {
    }
    
    EMCallSession(EMACallSession emaObject) {
        this.emaObject = emaObject;
    }
    
    public String getCallId() {
        return emaObject.getCallId();
    }
    
    static EndReason getEndReason(int ordinal) {
        if (ordinal == EndReason.HANGUP.ordinal()) {
            return EndReason.HANGUP;
        } else if (ordinal == EndReason.NORESPONSE.ordinal()) {
            return EndReason.NORESPONSE;
        } else if (ordinal == EndReason.REJECT.ordinal()) {
            return EndReason.REJECT;
        } else if (ordinal == EndReason.BUSY.ordinal()) {
            return EndReason.BUSY;
        } else if (ordinal == EndReason.FAIL.ordinal()){
            return EndReason.FAIL;
        } else {
            return EndReason.OFFLINE;
        }
    }
    
    static SessionInfoType getSessionInfoType(int type){
        SessionInfoType _type = SessionInfoType.RESUME_VOICE;
        switch (type) {    
        case 0:
            _type = SessionInfoType.PAUSE_VOICE;
            break;
        case 1:
            _type = SessionInfoType.RESUME_VOICE;
            break;
        case 2:
            _type = SessionInfoType.PAUSE_VIDEO;
            break;
        case 3:
            _type = SessionInfoType.RESUME_VIDEO;
            break;

        default:
            break;
        }
        return _type;
    }
    
    public Type getType() {
        EMACallSession.Type type = this.emaObject.getType();
        switch (type) {
        case VOICE:
            return Type.VOICE;
        default:
            return Type.VIDEO;
        }
    }
    
    public ConnectType getConnectType() {
        EMACallSession.ConnectType type = this.emaObject.getConnectType();
        switch (type) {
        case DIRECT:
            return ConnectType.DIRECT;
        case RELAY:
            return ConnectType.RELAY;
        default:
            return ConnectType.NONE;
        }
    }
    
    String password() {
        return "12345678";
    }
    
    public String getRemoteName() {
        return this.emaObject.getRemoteName();
    }
    
    public String getExt() {
        return this.emaObject.getExt();
    }
    
    public String getLocalName() {
        return emaObject.getLocalName();
    }
}
