package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMACallManager;
import com.superrtc.sdk.RtcConnection;

import org.json.JSONObject;

/**
 * Contains call related options.
 * Those configure options works like preference which exists in memory, take effect when make call.
 * Call 'SetXXX' method doesn't take effect during call.
 */
public class EMCallOptions {
    
    EMACallManager emaCallManager = null;

    boolean isUserSetAutoResizing = false;
    boolean isUserSetMaxFrameRate = false;

    boolean userSetAutoResizing = false;
    int userSetMaxFrameRate = -1;

    boolean isChangeVideoResolution = false;
    int changeVideoResolutionWidth = -1;
    int changeVideoResolutionHeight = -1;

    
    EMCallOptions(EMACallManager emaObject) {
        this.emaCallManager = emaObject;
    }

    /**
     * Configure whether send offline notification.
     * Function works when one of GCM, MiPush, HuaweiPush is valid.
     * @param isSend send offline notification to opposite side, telling call is on going.
     */
    public void setIsSendPushIfOffline(boolean isSend) {
        emaCallManager.setIsSendPushIfOffline(isSend);
    }

    /**
     * @see setIsSendPushIfOffline
     * @return
     */
    public boolean getIsSendPushIfOffline() {
        return emaCallManager.getIsSendPushIfOffline();
    }
   
    public long getVideoResolutionWidth() {
        return emaCallManager.getVideoResolutionWidth();
    }
    
    public long getVideoResolutionHeight() {
        return emaCallManager.getVideoResolutionHeight();
    }
    
    public long getMaxVideoKbps() {
        return emaCallManager.getVideoKbps();
    }


    /**
     * Set camera capture resolution
     * When set width, height both as 0, it means use default resolution, such as 480 * 640, which is one of low resolutions camera can supported,
     * will auto adjust the encoding bit rate, and use appropriate value for video width and video height.
     * @param width
     * @param height
     */
    public void setVideoResolution(int width, int height) {
        RtcConnection rtcConnection = EMClient.getInstance().callManager().mRtcConnection;
        if (rtcConnection != null) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(RtcConnection.RtcvideowidthLong, width);
                jsonObject.put(RtcConnection.RtcvideoheigthLong, height);
                rtcConnection.setConfigure(jsonObject.toString());
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        emaCallManager.setVideoResolution(width, height);
    }

    /**
     * default is 0, which means auto adjust encoding bit rate.
     * This kbps can be viewed as a threshold, help to adjust video bit rate.
     * @param kbps
     */
    public void setMaxVideoKbps(long kbps) {
        RtcConnection rtcConnection = EMClient.getInstance().callManager().mRtcConnection;
        if (rtcConnection != null) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(RtcConnection.RtcKVMaxVideoKbpsLong, kbps);
                rtcConnection.setConfigure(jsonObject.toString());
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        emaCallManager.setVideoKbps(kbps);
    }

    /**
     * \~chinese
     * 关闭自动调节分辨率
     *
     * \~english
     * disable auto adjust resolution
     */
    public void enableFixedVideoResolution(boolean enable) {
        isUserSetAutoResizing = true;
        userSetAutoResizing = enable;
        RtcConnection  rtc = EMClient.getInstance().callManager().mRtcConnection;
        if (rtc != null) {
            rtc.enableFixedVideoResolution(enable);
        }
    }

    /**
     * \~chinese
     * 设置最大的视频帧率
     *
     * \~english
     * config maximum of frame rate
     */
    public void setMaxVideoFrameRate(int frameRate) {
        isUserSetMaxFrameRate = true;
        userSetMaxFrameRate = frameRate;
        RtcConnection  rtc = EMClient.getInstance().callManager().mRtcConnection;
        if (rtc != null) {
            rtc.setMaxVideoFrameRate(frameRate);
        }
    }

    /**
     * \chinese
     * 设置最小的网络带宽
     *
     * \~english
     * config minimum of bit rate
     */
    public void setMinVideoKbps(int minVideoKbps) {
        RtcConnection.setMinVideoKbps(minVideoKbps);
    }

    /**
     * \chinese
     * 设置音频采样频率，需要在第一次通话之前设置
     * 参考值8000Hz、11025Hz、22050Hz、16000Hz、44100Hz、48000Hz
     *
     * \english
     * config audio sample rate
     * optional values: 8000Hz, 11025Hz, 22050Hz, 16000Hz, 44100Hz
     */
    public void setAudioSampleRate(int sampleRate) {
        RtcConnection.setAudioSampleRate(sampleRate);
    }

}
