package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMACallConference;
import com.hyphenate.chat.adapter.EMACallSession;
import com.hyphenate.chat.adapter.EMACallStream;

import java.util.ArrayList;
import java.util.List;

class EMCallConference extends EMBase<EMACallConference> {
    EMACallConference emaObject;
    
    EMCallConference() {
    }
    
    EMCallConference(EMACallConference emaObject) {
        this.emaObject = emaObject;
    }

    public String getCallId() {
        return this.emaObject.getCallId();
    }
    
    public String getLocalName() {
        return this.emaObject.getLocalName();
    }
    
    public EMCallSession.Type getType() {
        EMACallSession.Type type = emaObject.getType();
        if (type == EMACallSession.Type.VIDEO) {
            return EMCallSession.Type.VIDEO;
        } else if (type == EMACallSession.Type.VOICE) {
            return EMCallSession.Type.VOICE;
        }
        return EMCallSession.Type.VOICE;
    }
    
    public List<EMCallStream> getSubscribableStreams() {
        List<EMACallStream> emaStreams = emaObject.getSubscribableStreams();
        List<EMCallStream> streams = new ArrayList<EMCallStream>();
        for (EMACallStream stream : emaStreams) {
            streams.add(new EMCallStream(stream));
        }
        return streams;
    }
    
    public List<EMCallStream> getSubscribedStreams() {
        List<EMACallStream> emaStreams = emaObject.getSubscribedStreams();
        List<EMCallStream> streams = new ArrayList<EMCallStream>();
        for (EMACallStream stream : emaStreams) {
            streams.add(new EMCallStream(stream));
        }
        return streams;
    }
    
    public void leave() {
        emaObject.leave();
    }

    public void close() {
        emaObject.close();
    }

}

                