package com.hyphenate;

/*!
 *  \~chinese
 *  群组相关的监听器，侦听群组相关的事件，例如加群申请，希望加入某个群，这个群的群主同意或者拒绝，被踢群等事件。 
 *
 *  \~english
 *  Group change listener, listen group related events. Such as receive join group invite, and join group application, etc...
 */
public interface EMGroupChangeListener {
	/*!
     *  \~chinese
	 * 当前用户收到加入群组邀请
	 * @param groupId 要加入的群的id
	 * @param groupName 要加入的群的名称
	 * @param inviter 邀请人的id
	 * @param reason 邀请加入的reason
     *
     *  \~english
	 * current user receive group invitation
	 * @param groupId The group ID.
	 * @param groupName group's subject 
	 * @param inviter Who invite you join the group
	 * @param reason Literal message coming with the invitation
	 */
	void onInvitationReceived(String groupId, String groupName, String inviter, String reason);
	
	/*!
     *  \~chinese
	 * 用户申请加入群
	 * @param groupId 要加入的群的id
	 * @param groupName 要加入的群的名称
	 * @param applyer 申请人的username
	 * @param reason 申请加入的reason
     *
     *  \~english
     * some one want to join the group.
	 * @param groupId The group ID
	 * @param groupName group's name
	 * @param applicant The applicant want to join the group
	 * @param reason Literal message coming with the application
	 */
	void onRequestToJoinReceived(String groupId, String groupName, String applicant, String reason);


	/*!
     *  \~chinese
	 * 加群申请被对方接受
	 * @param groupId 群组的id
	 * @param groupName 群组的名字
	 * @param accepter 同意人得username
     *
     *  \~english
	 * Join group's application has been approved
	 * @param groupId The group ID
	 * @param groupName group's name
	 * @param accepter who approve the application
	 */
	void onRequestToJoinAccepted(String groupId, String groupName, String accepter);

	/*!
     *  \~chinese
	 * 加群申请被拒绝
	 * @param groupId 群组id
	 * @param groupName 群组名字
	 * @param decliner 拒绝人得username
	 * @param reason 拒绝理由
     *
     *  \~english
     * Join group's application has been declined
	 * @param groupId The group ID
	 * @param groupName group's name
	 * @param decliner decliner's username
	 * @param reason decline reason
	 */
	void onRequestToJoinDeclined(String groupId, String groupName, String decliner, String reason);

	/*!
     *  \~chinese
	 * 群组邀请被接受
	 * @param groupId
	 * @param invitee
	 * @param reason
     *
     *  \~english
     * invite some one to be member of group, and the user has accept the invitation
	 * @param groupId The group ID
	 * @param invitee 
	 * @param reason
	 */
	void onInvitationAccepted(String groupId, String invitee, String reason);
    
	/*!
     *  \~chinese
	 * 群组邀请被拒绝
	 * @param groupId
	 * @param invitee
	 * @param reason
     *
     *  \~english
     * invite some one to be member of group, and the user has decline the invitation
	 * @param groupId The group ID
	 * @param invitee
	 * @param reason refuse reason
	 */
	void onInvitationDeclined(String groupId, String invitee, String reason);
    
	/*!
     *  \~chinese
	 * 当前登录用户被管理员移除出群组
	 * @param groupId 
	 * @param groupName
     *
     *  \~english
     * current user has been remove from the group
	 * @param groupId 
	 * @param groupName
	 */
	void onUserRemoved(String groupId, String groupName);
    
    /*!
     *  \~chinese
     * 群组被解散。
     * sdk 会先删除本地的这个群组，之后通过此回调通知应用，此群组被删除了
     * @param groupId 群组的ID
     * @param groupName 群组的名称
     *
     * \~english
     * group dissolution
     * SDK will delete the group from local DB and local memory cache, then notify user this group has been destroyed
     */
	void onGroupDestroyed(String groupId, String groupName);
    
    /*!
     *  \~chinese
     * 自动同意加入群组
     * sdk会先加入这个群组，并通过此回调通知应用
     * 参考{@link com.hyphenate.chat.EMOptions.setAutoAcceptGroupInvitation(boolean value)}
     * 
     * @param groupId
     * @param inviter
     * @param inviteMessage
     *
     * \~english
     * When receive group join invitation, will auto accept it, and join the group.
     * Please refer to {@link com.hyphenate.chat.EMOptions.setAutoAcceptGroupInvitation(boolean value)}
     */
	void onAutoAcceptInvitationFromGroup(String groupId, String inviter, String inviteMessage);
}
