/************************************************************
  *  * hyphenate CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 hyphenate Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of hyphenate Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from hyphenate Technologies.
  */
package com.hyphenate;

/*!
 *  \~chinese
 *  联系人监听器，监听联系变化，包括添加好友的申请，对方删除好友的通知, 对方同意好友请求，对方拒绝好友请求。
 *  注册联系人监听，请执行EMClient.getInstance().contactManager().setContactListener(EMContactListener listener);
 *
 *  \~english
 *  Contact change listener. if your app will use hyphenate contact management, you have to use this listener by implementing it to receive any change of contact
 */
public interface EMContactListener {
    
    /**
     *  \~chinese
     * 增加联系人时回调此方法
     * @param username 增加的联系人
     * 
     *  \~english
     * this api will be called when there is any contact added
     * @param username new added contact.
     */
    void onContactAdded(String username);
    
    /**
     *  \~chinese
     * 被删除时回调此方法
     *
     *  \~english
     * this api will be called when some contacts of yours are deleted
     * @param username 删除的联系人
     */
    void onContactDeleted(String username);

    /**
     *  \~chinese
     * 收到好友邀请
     * @param username 发起加为好友用户的名称
     * @param reason   对方发起好友邀请时发出的文字性描述
     *
     *  \~english
     * this api will be called when you receive a friend application
     * @param username User who asked to be friend of current user.
     * @param reason   User's invite literal message.
     */
    void onContactInvited(String username, String reason);
    
    /**
     *  \~chinese
     * 好友请求被同意
     * @param username
     *
     *  \~english
     * this api will be called when your application is accepted
     * @param username
     */
    void onFriendRequestAccepted(String username);

    /**
     *  \~chinese
     * 好友请求被拒绝
     * @param username
     *
     *  \~english
     * this api will be called when your application is refused
     * @param username
     */
    void onFriendRequestDeclined(String username);

}
