/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */

package com.hyphenate;

/*!
 * \~chinese
 * Hyphenate 即时通讯状态连接监听器。
 * 如果遇到弱网掉线情况，应用收到onDisconnected，此时不需要处理重连操作，Hyphenate SDK在底层自动处理重练。
 * 回调函数只有onConnected, onDisconnected, 无需考虑连接中，断开中一类的中间状态
 * 
 * 
 * 请注意, 应用不要在这两个回调函数中更新界面，这两个现成属于工作线程，直接更新界面会导致界面的并发错误。</br>
 * {@link com.hyphenate.chat.EMClient.addConnectionListener(final EMConnectionListener)}
 * 
 * \~english
 * Hyphenate IM connection listener
 * During weak signal condition, and onDisconnected triggered, app don't need do reconnection by itself, Hyphenate SDK do it in the internal part
 * We only support 2 states : connected, disconnected
 * 
 * <span>And please be careful, APP should not update UI in this api since this is called from worker thread
 *                        or heavy work which will block other listener to handle this connection event.</span>
 * {@link com.hyphenate.chat.EMClient.addConnectionListener(final EMConnectionListener)}
 *
 */
public interface EMConnectionListener {
    /*!
     * \~chinese
     * 成功连接到Hyphenate IM服务器时触发
     * \~english
     * Triggered callback when successfully connected to Hyphenate IM server
     */
    void onConnected();

    /*!
     * \~chinese
     * 和Hyphenate IM服务器断开连接时触发
     * \~english
     * Triggered callback when disconnected from Hyphenate IM server
     */
    void onDisconnected(final int errorCode);
}
