package com.hyphenate;

/*!
 *  \~chinese
 *  聊天室监听接口  
 *
 *  \~english
 *  chat room change listener
 */

public interface EMChatRoomChangeListener {
    /*!
     * \~chinese
     * 聊天室被解散。
     * 
     * @param roomId
     *            聊天室id
     * @param roomName
     *            聊天室名称
     *
     * \~english
     * callback when chat room is destroyed
     * 
     * @param roomId
     *            chatroom id
     * @param roomName
     *            chatroom subject, chatroom's literal description
     */
    void onChatRoomDestroyed(String roomId, String roomName);

    /*!
     * \~chinese
     * 聊天室加入新成员事件
     * 
     * @param roomId
     *          聊天室id
     * @param participant
     *          新成员username
     *
     * \~english
     * Callback when a user join the chatroom.
     * 
     * @param roomId
     *          chatroom id
     * @param participant
     *          new member's username
     */
    void onMemberJoined(String roomId, String participant);

    /*!
     * \~chinese
     * 聊天室成员主动退出事件
     * 
     * @param roomId
     *          聊天室id
     * @param roomName
     *          聊天室名字
     * @param participant
     *          退出的成员的username
     * 
     * \~english
     * Callback when a user exit the chatroom
     * 
     * @param roomId
     *          the chatroom id which user exited
     * @param roomName
     *          the chatroom's subject, literal description
     * @param participant
     *          the member who leaved
      */
    void onMemberExited(String roomId, String roomName, String participant);

    /*!
     * \~chinese
     * 聊天室人员被移除
     * 
     * @param roomId
     *          聊天室id
     *@param roomName
     *          聊天室名字
     * @param participant
     *          被移除人员的username
     *
     * \~english
     * Callback for chatroom's member being kicked off
     * 
     * @param roomId
     *          chatroom id
     *@param roomName
     *          chatroom
     *          the chatroom's subject, literal description
     * @param participant
     *          the member who leaved
     */
    void onRemovedFromChatRoom(String roomId, String roomName, String participant);
}
