/*
 * Decompiled with CFR 0.152.
 */
package easemob.hyphenate.calluikit.utils;

import android.content.SharedPreferences;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import easemob.hyphenate.calluikit.EaseCallUIKit;
import easemob.hyphenate.calluikit.base.EaseCallKitConfig;
import easemob.hyphenate.calluikit.base.EaseCallUserInfo;
import java.util.Map;
import java.util.Random;
import java.util.UUID;

public class EaseCallKitUtils {
    private static String uuid;

    public static String getRandomString(int length) {
        String str = "abcdefghijklmnopqrstuvwxyz";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(26);
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }

    public static String getPhoneSign() {
        StringBuilder deviceId = new StringBuilder();
        deviceId.append("a");
        try {
            TelephonyManager tm = (TelephonyManager)EaseCallUIKit.getInstance().getAppContext().getSystemService("phone");
            String imei = tm.getDeviceId();
            if (!TextUtils.isEmpty((CharSequence)imei)) {
                deviceId.append("imei");
                deviceId.append(imei);
                return deviceId.toString();
            }
            String sn = tm.getSimSerialNumber();
            if (!TextUtils.isEmpty((CharSequence)sn)) {
                deviceId.append("sn");
                deviceId.append(sn);
                return deviceId.toString();
            }
            String uuid = EaseCallKitUtils.getUUID();
            if (!TextUtils.isEmpty((CharSequence)uuid)) {
                deviceId.append("id");
                deviceId.append(uuid);
                return deviceId.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            deviceId.append("id").append(EaseCallKitUtils.getUUID());
        }
        return deviceId.toString();
    }

    public static String getUUID() {
        SharedPreferences mShare = EaseCallUIKit.getInstance().getAppContext().getSharedPreferences("uuid", 0);
        if (mShare != null) {
            uuid = mShare.getString("uuid", "");
        }
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            uuid = UUID.randomUUID().toString();
            mShare.edit().putString("uuid", uuid).commit();
        }
        return uuid;
    }

    public static String getUserHeadImage(String uersId) {
        EaseCallKitConfig callKitConfig = EaseCallUIKit.getInstance().getCallKitConfig();
        if (callKitConfig != null) {
            EaseCallUserInfo userInfo;
            Map<String, EaseCallUserInfo> userInfoMap = callKitConfig.getUserInfoMap();
            if (userInfoMap != null && (userInfo = userInfoMap.get(uersId)) != null && userInfo.getHeadImage() != null) {
                return userInfo.getHeadImage();
            }
            return callKitConfig.getDefaultHeadImage();
        }
        return null;
    }

    public static String getUserNickName(String uersId) {
        EaseCallKitConfig callKitConfig = EaseCallUIKit.getInstance().getCallKitConfig();
        if (callKitConfig != null) {
            EaseCallUserInfo userInfo;
            Map<String, EaseCallUserInfo> userInfoMap = callKitConfig.getUserInfoMap();
            if (userInfoMap != null && (userInfo = userInfoMap.get(uersId)) != null && userInfo.getNickName() != null) {
                return userInfo.getNickName();
            }
            return uersId;
        }
        return uersId;
    }

    public static String getRingFile() {
        EaseCallKitConfig callKitConfig = EaseCallUIKit.getInstance().getCallKitConfig();
        if (callKitConfig != null && callKitConfig.getRingFile() != null) {
            return callKitConfig.getRingFile();
        }
        return null;
    }
}

