/*
 * Decompiled with CFR 0.152.
 */
package easemob.hyphenate.calluikit.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.hyphenate.util.EMLog;
import easemob.hyphenate.calluikit.EaseCallUIKit;
import easemob.hyphenate.calluikit.base.EaseCallKitConfig;
import easemob.hyphenate.calluikit.base.EaseCallKitListener;
import easemob.hyphenate.calluikit.base.EaseCallKitTokenCallback;
import easemob.hyphenate.calluikit.base.EaseCallUserInfo;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EaseCallKitUtils {
    public static final String TAG = "EaseCallKitUtils";
    private static String uuid;

    public static String getRandomString(int length) {
        String str = "abcdefghijklmnopqrstuvwxyz";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(26);
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }

    public static String getPhoneSign() {
        StringBuilder deviceId = new StringBuilder();
        deviceId.append("a");
        try {
            TelephonyManager tm = (TelephonyManager)EaseCallUIKit.getInstance().getAppContext().getSystemService("phone");
            String imei = tm.getDeviceId();
            if (!TextUtils.isEmpty((CharSequence)imei)) {
                deviceId.append("imei");
                deviceId.append(imei);
                return deviceId.toString();
            }
            String sn = tm.getSimSerialNumber();
            if (!TextUtils.isEmpty((CharSequence)sn)) {
                deviceId.append("sn");
                deviceId.append(sn);
                return deviceId.toString();
            }
            String uuid = EaseCallKitUtils.getUUID();
            if (!TextUtils.isEmpty((CharSequence)uuid)) {
                deviceId.append("id");
                deviceId.append(uuid);
                return deviceId.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            deviceId.append("id").append(EaseCallKitUtils.getUUID());
        }
        return deviceId.toString();
    }

    public static String getUUID() {
        SharedPreferences mShare = EaseCallUIKit.getInstance().getAppContext().getSharedPreferences("uuid", 0);
        if (mShare != null) {
            uuid = mShare.getString("uuid", "");
        }
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            uuid = UUID.randomUUID().toString();
            mShare.edit().putString("uuid", uuid).commit();
        }
        return uuid;
    }

    public static String getUserHeadImage(String uersId) {
        EaseCallKitConfig callKitConfig = EaseCallUIKit.getInstance().getCallKitConfig();
        if (callKitConfig != null) {
            EaseCallUserInfo userInfo;
            Map<String, EaseCallUserInfo> userInfoMap = callKitConfig.getUserInfoMap();
            if (userInfoMap != null && (userInfo = userInfoMap.get(uersId)) != null && userInfo.getHeadImage() != null) {
                return userInfo.getHeadImage();
            }
            return callKitConfig.getDefaultHeadImage();
        }
        return null;
    }

    public static String getUserNickName(String uersId) {
        EaseCallKitConfig callKitConfig = EaseCallUIKit.getInstance().getCallKitConfig();
        if (callKitConfig != null) {
            EaseCallUserInfo userInfo;
            Map<String, EaseCallUserInfo> userInfoMap = callKitConfig.getUserInfoMap();
            if (userInfoMap != null && (userInfo = userInfoMap.get(uersId)) != null && userInfo.getNickName() != null) {
                return userInfo.getNickName();
            }
            return uersId;
        }
        return uersId;
    }

    public static String getRingFile() {
        EaseCallKitConfig callKitConfig = EaseCallUIKit.getInstance().getCallKitConfig();
        if (callKitConfig != null && callKitConfig.getRingFile() != null) {
            return callKitConfig.getRingFile();
        }
        return null;
    }

    public static boolean isAppRunningForeground(Context ctx) {
        ActivityManager activityManager = (ActivityManager)ctx.getSystemService("activity");
        if (Build.VERSION.SDK_INT > 20) {
            List runningProcesses = activityManager.getRunningAppProcesses();
            if (runningProcesses == null) {
                return false;
            }
            String packageName = ctx.getPackageName();
            for (ActivityManager.RunningAppProcessInfo processInfo : runningProcesses) {
                if (processInfo.importance != 100 || !processInfo.processName.equals(packageName)) continue;
                return true;
            }
            return false;
        }
        try {
            List tasks = activityManager.getRunningTasks(1);
            if (tasks == null || tasks.size() < 1) {
                return false;
            }
            boolean b = ctx.getPackageName().equalsIgnoreCase(((ActivityManager.RunningTaskInfo)tasks.get((int)0)).baseActivity.getPackageName());
            EMLog.d((String)"utils", (String)("app running in foregroud\uff1a" + b));
            return b;
        }
        catch (SecurityException e) {
            EMLog.d((String)TAG, (String)"Apk doesn't hold GET_TASKS permission");
            e.printStackTrace();
            return false;
        }
    }

    public static JSONObject convertMapToJSONObject(Map<String, Object> map) {
        JSONObject obj = new JSONObject();
        Set<Map.Entry<String, Object>> entries = map.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            Object result;
            Object value = entry.getValue();
            if (value instanceof Map) {
                result = EaseCallKitUtils.convertMapToJSONObject((Map)value);
            } else if (value instanceof List) {
                result = new JSONArray();
                for (Object item : (List)value) {
                    ((JSONArray)result).put(item);
                }
            } else if (value instanceof Object[]) {
                result = new JSONArray();
                for (Object item : (Object[])value) {
                    ((JSONArray)result).put(item);
                }
            } else {
                result = value;
            }
            try {
                obj.put(entry.getKey(), result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    public static int getSupportedWindowType() {
        if (Build.VERSION.SDK_INT >= 26) {
            return 2038;
        }
        return 2003;
    }

    public static boolean realizeGetToken(EaseCallKitListener listener) {
        if (listener != null) {
            Method cMethod = null;
            try {
                cMethod = listener.getClass().getDeclaredMethod("onGenerateToken", String.class, String.class, String.class, EaseCallKitTokenCallback.class);
                EMLog.d((String)TAG, (String)("realizeGetToken result:" + cMethod.toString()));
                if (cMethod != null) {
                    return true;
                }
            }
            catch (NoSuchMethodException e) {
                EMLog.e((String)TAG, (String)("realizeGetToken result:" + e.getLocalizedMessage()));
                return false;
            }
        }
        return false;
    }
}

