/*
 * Decompiled with CFR 0.152.
 */
package easemob.hyphenate.calluikit.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Chronometer;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.Group;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import com.hyphenate.EMCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCmdMessageBody;
import com.hyphenate.chat.EMConferenceStream;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMMessageBody;
import com.hyphenate.cloud.HttpClientManager;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMLog;
import easemob.hyphenate.calluikit.EaseCallUIKit;
import easemob.hyphenate.calluikit.R;
import easemob.hyphenate.calluikit.base.EaseCallEndReason;
import easemob.hyphenate.calluikit.base.EaseCallFloatWindow;
import easemob.hyphenate.calluikit.base.EaseCallKitConfig;
import easemob.hyphenate.calluikit.base.EaseCallKitListener;
import easemob.hyphenate.calluikit.base.EaseCallKitTokenCallback;
import easemob.hyphenate.calluikit.base.EaseCallType;
import easemob.hyphenate.calluikit.event.AlertEvent;
import easemob.hyphenate.calluikit.event.AnswerEvent;
import easemob.hyphenate.calluikit.event.BaseEvent;
import easemob.hyphenate.calluikit.event.CallCancelEvent;
import easemob.hyphenate.calluikit.event.ConfirmCallEvent;
import easemob.hyphenate.calluikit.event.ConfirmRingEvent;
import easemob.hyphenate.calluikit.event.InviteEvent;
import easemob.hyphenate.calluikit.event.VideoToVoiceeEvent;
import easemob.hyphenate.calluikit.livedatas.EaseLiveDataBus;
import easemob.hyphenate.calluikit.utils.EaseCallAction;
import easemob.hyphenate.calluikit.utils.EaseCallKitUtils;
import easemob.hyphenate.calluikit.utils.EaseCallState;
import easemob.hyphenate.calluikit.utils.EaseMsgUtils;
import easemob.hyphenate.calluikit.widget.EaseImageView;
import easemob.hyphenate.calluikit.widget.MyChronometer;
import io.agora.rtc.IRtcEngineEventHandler;
import io.agora.rtc.RtcEngine;
import io.agora.rtc.models.UserInfo;
import io.agora.rtc.video.VideoCanvas;
import io.agora.rtc.video.VideoEncoderConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.json.JSONObject;

public class EaseVideoCallActivity
extends AppCompatActivity
implements View.OnClickListener {
    private static final String TAG = EaseVideoCallActivity.class.getSimpleName();
    private static final int PERMISSION_REQ_ID = 22;
    private final int REQUEST_CODE_OVERLAY_PERMISSION = 1002;
    private static final String[] REQUESTED_PERMISSIONS = new String[]{"android.permission.RECORD_AUDIO", "android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"};
    private View rootView;
    private Group comingBtnContainer;
    private ImageButton refuseBtn;
    private ImageButton answerBtn;
    private ImageButton hangupBtn;
    private Group voiceContronlLayout;
    private Group groupHangUp;
    private Group groupUseInfo;
    private Group groupOngoingSettings;
    private TextView nickTextView;
    private EMConferenceStream oppositeStream;
    private boolean isMuteState = false;
    private boolean isHandsfreeState;
    private ImageView muteImage;
    private ImageView handsFreeImage;
    private ImageButton switchCameraBtn;
    private MyChronometer chronometer;
    private boolean surfaceStateChange = false;
    private EaseImageView avatarView;
    private TextView call_stateView;
    private Group videoCallingGroup;
    private Group voiceCallingGroup;
    private TextView tv_nick_voice;
    private Group videoCalledGroup;
    private Group voiceCalledGroup;
    private RelativeLayout video_transe_layout;
    private RelativeLayout video_transe_comming_layout;
    private ImageButton btn_voice_trans;
    private TextView tv_call_state_voice;
    private EaseImageView iv_avatar_voice;
    private ImageButton float_btn;
    protected boolean isInComingCall;
    protected String username;
    protected String channelName;
    protected AudioManager audioManager;
    protected Ringtone ringtone;
    private boolean mMuted = false;
    private boolean mCallEnd = false;
    private volatile boolean mConfirm_ring = false;
    private String tokenUrl;
    private int remoteUId = 0;
    private boolean changeFlag = true;
    boolean transVoice = false;
    private String headUrl = null;
    private Bitmap headBitMap;
    private String ringFile;
    private MediaPlayer mediaPlayer;
    protected RelativeLayout localSurface_layout;
    protected RelativeLayout oppositeSurface_layout;
    private VideoCanvas mLocalVideo;
    private VideoCanvas mRemoteVideo;
    private EaseCallType callType;
    private View Voice_View;
    private TimeHandler timehandler;
    private RtcEngine mRtcEngine;
    private boolean isMuteVideo = false;
    private String agoraAppId = null;
    private boolean requestOverlayPermission;
    private final IRtcEngineEventHandler mRtcEventHandler = new IRtcEngineEventHandler(){

        public void onError(int err) {
            super.onError(err);
            EMLog.d((String)TAG, (String)("IRtcEngineEventHandler onError:" + err));
            EaseCallKitListener listener = EaseCallUIKit.getInstance().getCallListener();
            if (listener != null) {
                listener.onCallError(EaseCallUIKit.EaseCallError.RTC_ERROR, err, "rtc error");
            }
        }

        public void onJoinChannelSuccess(String channel, int uid, int elapsed) {
            EMLog.d((String)TAG, (String)("onJoinChannelSuccess channel:" + channel + " uid" + uid));
            EaseVideoCallActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (!EaseVideoCallActivity.this.isInComingCall) {
                        if (EaseCallUIKit.getInstance().getCallType() == EaseCallType.SIGNAL_VIDEO_CALL) {
                            EaseVideoCallActivity.this.handler.sendEmptyMessage(EaseMsgUtils.MSG_MAKE_SIGNAL_VIDEO);
                        } else {
                            EaseVideoCallActivity.this.handler.sendEmptyMessage(EaseMsgUtils.MSG_MAKE_SIGNAL_VOICE);
                        }
                        EaseVideoCallActivity.this.isHandsfreeState = true;
                        EaseVideoCallActivity.this.openSpeakerOn();
                        EaseVideoCallActivity.this.handsFreeImage.setImageResource(R.drawable.em_icon_speaker_on);
                        EaseVideoCallActivity.this.timehandler.startTime();
                    }
                }
            });
        }

        public void onRejoinChannelSuccess(String channel, int uid, int elapsed) {
            super.onRejoinChannelSuccess(channel, uid, elapsed);
        }

        public void onLeaveChannel(IRtcEngineEventHandler.RtcStats stats) {
            super.onLeaveChannel(stats);
        }

        public void onClientRoleChanged(int oldRole, int newRole) {
            super.onClientRoleChanged(oldRole, newRole);
        }

        public void onLocalUserRegistered(int uid, String userAccount) {
            super.onLocalUserRegistered(uid, userAccount);
        }

        public void onUserInfoUpdated(int uid, UserInfo userInfo) {
            super.onUserInfoUpdated(uid, userInfo);
        }

        public void onUserJoined(int uid, int elapsed) {
            super.onUserJoined(uid, elapsed);
            EaseVideoCallActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    EaseVideoCallActivity.this.makeOngoingStatus();
                }
            });
        }

        public void onUserOffline(int uid, int reason) {
            EaseVideoCallActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    EaseVideoCallActivity.this.exitChannel();
                    EaseCallKitListener listener = EaseCallUIKit.getInstance().getCallListener();
                    if (listener != null) {
                        long time = EaseVideoCallActivity.this.getChronometerSeconds(EaseVideoCallActivity.this.chronometer);
                        listener.onEndCallWithReason(EaseVideoCallActivity.this.callType, EaseVideoCallActivity.this.channelName, EaseCallEndReason.EaseCallEndReasonHangup, time * 1000L);
                    }
                }
            });
        }

        public void onFirstRemoteVideoDecoded(final int uid, int width, int height, int elapsed) {
            EaseVideoCallActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    EaseVideoCallActivity.this.remoteUId = uid;
                    if (EaseVideoCallActivity.this.callType == EaseCallType.SIGNAL_VIDEO_CALL) {
                        EaseVideoCallActivity.this.setupRemoteVideo(uid);
                    }
                }
            });
        }

        @Deprecated
        public void onFirstRemoteAudioFrame(final int uid, int elapsed) {
            EaseVideoCallActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    EaseVideoCallActivity.this.remoteUId = uid;
                    EaseVideoCallActivity.this.chronometer.start();
                    EaseVideoCallActivity.this.handsFreeImage.setImageResource(R.drawable.em_icon_speaker_on);
                }
            });
        }

        public void onRemoteVideoStateChanged(final int uid, final int state, int reason, int elapsed) {
            EaseVideoCallActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (uid == EaseVideoCallActivity.this.remoteUId && (state == 0 || state == 5)) {
                        EaseVideoCallActivity.this.callType = EaseCallType.SIGNAL_VOICE_CALL;
                        EaseCallUIKit.getInstance().setCallType(EaseCallType.SIGNAL_VOICE_CALL);
                        EaseCallFloatWindow.getInstance(EaseVideoCallActivity.this.getApplicationContext()).setCallType(EaseVideoCallActivity.this.callType);
                        EaseVideoCallActivity.this.changeVideoVoiceState();
                        if (EaseVideoCallActivity.this.mRtcEngine != null) {
                            EaseVideoCallActivity.this.mRtcEngine.muteLocalVideoStream(true);
                            EaseVideoCallActivity.this.mRtcEngine.enableVideo();
                        }
                    }
                }
            });
        }
    };
    HandlerThread callHandlerThread = new HandlerThread("callHandlerThread");
    protected Handler handler;

    public EaseVideoCallActivity() {
        this.callHandlerThread.start();
        this.handler = new Handler(this.callHandlerThread.getLooper()){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 100: {
                        EaseVideoCallActivity.this.sendInviteeMsg(EaseVideoCallActivity.this.username, EaseCallType.SIGNAL_VOICE_CALL);
                        break;
                    }
                    case 101: {
                        EaseVideoCallActivity.this.sendInviteeMsg(EaseVideoCallActivity.this.username, EaseCallType.SIGNAL_VIDEO_CALL);
                        break;
                    }
                    case 301: {
                        EaseVideoCallActivity.this.handler.removeMessages(100);
                        EaseVideoCallActivity.this.handler.removeMessages(101);
                        EaseVideoCallActivity.this.handler.removeMessages(102);
                        EaseVideoCallActivity.this.callHandlerThread.quit();
                        break;
                    }
                    case 400: {
                        EaseVideoCallActivity.this.tokenUrl = EaseMsgUtils.TOKEN_SERVER;
                        EaseVideoCallActivity.this.tokenUrl = EaseVideoCallActivity.this.tokenUrl + EaseMsgUtils.APPCERT;
                        EaseVideoCallActivity.this.tokenUrl = EaseVideoCallActivity.this.tokenUrl + EaseMsgUtils.ADDAMARK;
                        EaseVideoCallActivity.this.tokenUrl = EaseVideoCallActivity.this.tokenUrl + EaseVideoCallActivity.this.getString(R.string.agora_app_cert);
                        EaseVideoCallActivity.this.tokenUrl = EaseVideoCallActivity.this.tokenUrl + EaseMsgUtils.APPKEY;
                        EaseVideoCallActivity.this.tokenUrl = EaseVideoCallActivity.this.tokenUrl + EaseMsgUtils.ADDAMARK;
                        EaseVideoCallActivity.this.tokenUrl = EaseVideoCallActivity.this.tokenUrl + EaseVideoCallActivity.this.getString(R.string.agora_app_id);
                        EaseVideoCallActivity.this.tokenUrl = EaseVideoCallActivity.this.tokenUrl + EaseMsgUtils.CHANNEL;
                        EaseVideoCallActivity.this.tokenUrl = EaseVideoCallActivity.this.tokenUrl + EaseMsgUtils.ADDAMARK;
                        EaseVideoCallActivity.this.tokenUrl = EaseVideoCallActivity.this.tokenUrl + EaseVideoCallActivity.this.channelName;
                        EaseVideoCallActivity.this.tokenUrl = EaseVideoCallActivity.this.tokenUrl + EaseMsgUtils.USERID;
                        EaseVideoCallActivity.this.tokenUrl = EaseVideoCallActivity.this.tokenUrl + EaseMsgUtils.ADDAMARK;
                        EaseVideoCallActivity.this.tokenUrl = EaseVideoCallActivity.this.tokenUrl + EMClient.getInstance().getCurrentUser();
                        try {
                            Pair reponse = HttpClientManager.sendRequest((String)EaseVideoCallActivity.this.tokenUrl, null, null, (String)HttpClientManager.Method_GET);
                            EMLog.e((String)TAG, (String)("reponse: " + reponse.toString()));
                            String token = null;
                            if (TextUtils.isEmpty(token)) {
                                EMLog.e((String)TAG, (String)("token: " + token));
                                EaseVideoCallActivity.this.exitChannel();
                            }
                            EaseVideoCallActivity.this.mRtcEngine.joinChannel(token, EaseVideoCallActivity.this.channelName, null, 0);
                            break;
                        }
                        catch (IOException exception) {
                            EMLog.e((String)TAG, (String)("IOException errorCode: " + exception.getMessage()));
                            EaseVideoCallActivity.this.exitChannel();
                            break;
                        }
                        catch (HyphenateException exception) {
                            EMLog.e((String)TAG, (String)("errorCode: " + exception.getErrorCode() + " Description:" + exception.getDescription()));
                            EaseVideoCallActivity.this.exitChannel();
                        }
                    }
                }
            }
        };
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_ease_video_call);
        if (savedInstanceState == null) {
            this.initParams(this.getIntent().getExtras());
        } else {
            this.initParams(savedInstanceState);
        }
        this.initView();
        this.addLiveDataObserver();
        if (!this.checkSelfPermission(REQUESTED_PERMISSIONS[0], 22) || !this.checkSelfPermission(REQUESTED_PERMISSIONS[1], 22) || this.checkSelfPermission(REQUESTED_PERMISSIONS[2], 22)) {
            // empty if block
        }
        this.timehandler = new TimeHandler();
    }

    private void initParams(Bundle bundle) {
        if (bundle != null) {
            this.isInComingCall = bundle.getBoolean("isComingCall", false);
            this.username = bundle.getString("username");
            this.channelName = bundle.getString("channelName");
            this.callType = EaseCallUIKit.getInstance().getCallType();
            EaseCallFloatWindow.getInstance(this.getApplicationContext()).setCallType(this.callType);
        }
    }

    private void initView() {
        this.refuseBtn = (ImageButton)this.findViewById(R.id.btn_refuse_call);
        this.answerBtn = (ImageButton)this.findViewById(R.id.btn_answer_call);
        this.hangupBtn = (ImageButton)this.findViewById(R.id.btn_hangup_call);
        this.voiceContronlLayout = (Group)this.findViewById(R.id.ll_voice_control);
        this.comingBtnContainer = (Group)this.findViewById(R.id.ll_coming_call);
        this.avatarView = (EaseImageView)this.findViewById(R.id.iv_avatar);
        this.iv_avatar_voice = (EaseImageView)this.findViewById(R.id.iv_avatar_voice);
        this.muteImage = (ImageView)this.findViewById(R.id.iv_mute);
        this.handsFreeImage = (ImageView)this.findViewById(R.id.iv_handsfree);
        this.switchCameraBtn = (ImageButton)this.findViewById(R.id.btn_switch_camera);
        this.videoCallingGroup = (Group)this.findViewById(R.id.ll_video_calling);
        this.voiceCallingGroup = (Group)this.findViewById(R.id.ll_voice_calling);
        this.video_transe_layout = (RelativeLayout)this.findViewById(R.id.bnt_video_transe);
        this.video_transe_comming_layout = (RelativeLayout)this.findViewById(R.id.bnt_video_transe_comming);
        this.tv_nick_voice = (TextView)this.findViewById(R.id.tv_nick_voice);
        this.tv_call_state_voice = (TextView)this.findViewById(R.id.tv_call_state_voice);
        this.headUrl = EaseCallKitUtils.getUserHeadImage(this.username);
        this.ringFile = EaseCallKitUtils.getRingFile();
        this.loadHeadImage();
        if (this.callType == EaseCallType.SIGNAL_VIDEO_CALL) {
            this.videoCallingGroup.setVisibility(0);
            this.voiceCallingGroup.setVisibility(8);
            if (this.isInComingCall) {
                this.video_transe_layout.setVisibility(8);
                this.video_transe_comming_layout.setVisibility(0);
            } else {
                this.video_transe_layout.setVisibility(0);
                this.video_transe_comming_layout.setVisibility(8);
            }
        } else {
            if (!this.isInComingCall) {
                this.voiceContronlLayout.setVisibility(0);
            }
            this.videoCallingGroup.setVisibility(8);
            this.video_transe_layout.setVisibility(8);
            this.video_transe_comming_layout.setVisibility(8);
            this.voiceCallingGroup.setVisibility(0);
            this.hangupBtn.setVisibility(8);
            this.tv_nick_voice.setText((CharSequence)EaseCallKitUtils.getUserNickName(this.username));
        }
        this.video_transe_layout.setOnClickListener((View.OnClickListener)this);
        this.video_transe_comming_layout.setOnClickListener((View.OnClickListener)this);
        this.videoCalledGroup = (Group)this.findViewById(R.id.ll_video_called);
        this.voiceCalledGroup = (Group)this.findViewById(R.id.ll_voice_control);
        this.btn_voice_trans = (ImageButton)this.findViewById(R.id.btn_voice_trans);
        this.btn_voice_trans.setOnClickListener((View.OnClickListener)this);
        this.refuseBtn.setOnClickListener((View.OnClickListener)this);
        this.answerBtn.setOnClickListener((View.OnClickListener)this);
        this.hangupBtn.setOnClickListener((View.OnClickListener)this);
        this.muteImage.setOnClickListener((View.OnClickListener)this);
        this.handsFreeImage.setOnClickListener((View.OnClickListener)this);
        this.switchCameraBtn.setOnClickListener((View.OnClickListener)this);
        this.localSurface_layout = (RelativeLayout)this.findViewById(R.id.local_surface_layout);
        this.oppositeSurface_layout = (RelativeLayout)this.findViewById(R.id.opposite_surface_layout);
        this.groupHangUp = (Group)this.findViewById(R.id.group_hang_up);
        this.groupUseInfo = (Group)this.findViewById(R.id.group_use_info);
        this.groupOngoingSettings = (Group)this.findViewById(R.id.group_ongoing_settings);
        this.nickTextView = (TextView)this.findViewById(R.id.tv_nick);
        this.chronometer = (MyChronometer)this.findViewById(R.id.chronometer);
        this.call_stateView = (TextView)this.findViewById(R.id.tv_call_state);
        this.nickTextView.setText((CharSequence)EaseCallKitUtils.getUserNickName(this.username));
        this.localSurface_layout.setOnClickListener((View.OnClickListener)this);
        this.Voice_View = this.findViewById(R.id.view_ring);
        this.rootView = ((ViewGroup)this.getWindow().getDecorView().findViewById(0x1020002)).getChildAt(0);
        this.float_btn = (ImageButton)this.findViewById(R.id.btn_call_float);
        this.float_btn.setOnClickListener((View.OnClickListener)this);
        if (this.isInComingCall) {
            this.call_stateView.setText((CharSequence)"\u9080\u8bf7\u4f60\u8fdb\u884c\u97f3\u89c6\u9891\u901a\u8bdd");
            this.tv_call_state_voice.setText((CharSequence)"\u9080\u8bf7\u4f60\u8fdb\u884c\u97f3\u89c6\u9891\u901a\u8bdd");
        } else {
            this.call_stateView.setText((CharSequence)"\u6b63\u5728\u7b49\u5f85\u5bf9\u65b9\u63a5\u53d7\u9080\u8bf7");
            this.tv_call_state_voice.setText((CharSequence)"\u6b63\u5728\u7b49\u5f85\u5bf9\u65b9\u63a5\u53d7\u9080\u8bf7");
        }
        if (this.callType == EaseCallType.SIGNAL_VOICE_CALL) {
            this.rootView.setBackground(this.getResources().getDrawable(R.drawable.call_bg_voice));
            this.localSurface_layout.setVisibility(8);
            this.oppositeSurface_layout.setVisibility(8);
            this.Voice_View.setVisibility(0);
            this.avatarView.setVisibility(0);
        } else {
            this.avatarView.setVisibility(8);
        }
        this.audioManager = (AudioManager)this.getSystemService("audio");
        if (!this.isInComingCall) {
            this.makeCallStatus();
            this.initEngineAndJoinChannel();
        } else {
            AudioManager am;
            int ringerMode;
            this.makeComingStatus();
            Uri ringUri = RingtoneManager.getDefaultUri((int)1);
            this.audioManager.setMode(1);
            this.audioManager.setSpeakerphoneOn(true);
            if (ringUri != null) {
                this.ringtone = RingtoneManager.getRingtone((Context)this, (Uri)ringUri);
            }
            if ((ringerMode = (am = (AudioManager)this.getApplication().getSystemService("audio")).getRingerMode()) == 2) {
                EMLog.e((String)TAG, (String)"playRing start");
                this.playRing();
            }
        }
    }

    private void makeComingStatus() {
        this.voiceContronlLayout.setVisibility(4);
        this.comingBtnContainer.setVisibility(0);
        this.groupUseInfo.setVisibility(0);
        if (this.callType == EaseCallType.SIGNAL_VIDEO_CALL) {
            this.groupOngoingSettings.setVisibility(4);
            this.localSurface_layout.setVisibility(4);
        } else {
            this.avatarView.setVisibility(0);
            this.nickTextView.setVisibility(0);
        }
        this.groupHangUp.setVisibility(4);
        this.groupRequestLayout();
    }

    private void makeOngoingStatus() {
        this.voiceContronlLayout.setVisibility(0);
        this.comingBtnContainer.setVisibility(4);
        this.groupUseInfo.setVisibility(4);
        this.groupHangUp.setVisibility(0);
        if (this.callType == EaseCallType.SIGNAL_VIDEO_CALL) {
            this.groupOngoingSettings.setVisibility(0);
            this.localSurface_layout.setVisibility(0);
            this.videoCalledGroup.setVisibility(0);
            this.voiceCalledGroup.setVisibility(4);
            this.hangupBtn.setVisibility(0);
            this.videoCallingGroup.setVisibility(8);
            this.voiceCallingGroup.setVisibility(8);
        } else {
            this.groupOngoingSettings.setVisibility(0);
            this.avatarView.setVisibility(0);
            this.localSurface_layout.setVisibility(8);
            this.oppositeSurface_layout.setVisibility(8);
            this.nickTextView.setVisibility(0);
            this.videoCalledGroup.setVisibility(4);
            this.voiceCalledGroup.setVisibility(0);
            this.hangupBtn.setVisibility(0);
            this.videoCallingGroup.setVisibility(8);
            this.voiceCallingGroup.setVisibility(0);
            this.tv_nick_voice.setText((CharSequence)EaseCallKitUtils.getUserNickName(this.username));
            this.tv_call_state_voice.setText((CharSequence)"\u901a\u8bdd\u4e2d");
        }
        this.video_transe_layout.setVisibility(8);
        this.video_transe_comming_layout.setVisibility(8);
        this.groupRequestLayout();
    }

    public void makeCallStatus() {
        if (!this.isInComingCall && this.callType == EaseCallType.SIGNAL_VOICE_CALL) {
            this.voiceContronlLayout.setVisibility(0);
        } else {
            this.voiceContronlLayout.setVisibility(4);
        }
        this.comingBtnContainer.setVisibility(4);
        this.groupUseInfo.setVisibility(0);
        this.groupOngoingSettings.setVisibility(4);
        this.localSurface_layout.setVisibility(4);
        this.groupHangUp.setVisibility(0);
        this.groupRequestLayout();
    }

    public void groupRequestLayout() {
        this.comingBtnContainer.requestLayout();
        this.groupHangUp.requestLayout();
        this.groupUseInfo.requestLayout();
        this.groupOngoingSettings.requestLayout();
    }

    private void initEngineAndJoinChannel() {
        this.initializeEngine();
        this.setupVideoConfig();
        this.setupLocalVideo();
        this.joinChannel();
    }

    private void initializeEngine() {
        try {
            EaseCallKitConfig config = EaseCallUIKit.getInstance().getCallKitConfig();
            if (config != null) {
                this.agoraAppId = config.getAgoraAppId();
            }
            this.mRtcEngine = RtcEngine.create((Context)this.getBaseContext(), (String)this.agoraAppId, (IRtcEngineEventHandler)this.mRtcEventHandler);
            EaseCallFloatWindow.getInstance(this.getApplicationContext()).setRtcEngine(this.mRtcEngine);
        }
        catch (Exception e) {
            EMLog.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            throw new RuntimeException("NEED TO check rtc sdk init fatal error\n" + Log.getStackTraceString((Throwable)e));
        }
    }

    private void setupVideoConfig() {
        if (EaseCallUIKit.getInstance().getCallType() == EaseCallType.SIGNAL_VIDEO_CALL) {
            this.mRtcEngine.enableVideo();
            this.mRtcEngine.setVideoEncoderConfiguration(new VideoEncoderConfiguration(VideoEncoderConfiguration.VD_1280x720, VideoEncoderConfiguration.FRAME_RATE.FRAME_RATE_FPS_15, 0, VideoEncoderConfiguration.ORIENTATION_MODE.ORIENTATION_MODE_FIXED_PORTRAIT));
        } else {
            this.mRtcEngine.disableVideo();
        }
    }

    private void setupLocalVideo() {
        SurfaceView view = RtcEngine.CreateRendererView((Context)this.getBaseContext());
        this.oppositeSurface_layout.addView((View)view);
        this.mLocalVideo = new VideoCanvas((View)view, 1, 0);
        this.mRtcEngine.setupLocalVideo(this.mLocalVideo);
    }

    private void setupRemoteVideo(int uid) {
        SurfaceView view = RtcEngine.CreateRendererView((Context)this.getBaseContext());
        this.oppositeSurface_layout.removeAllViews();
        this.oppositeSurface_layout.addView((View)view);
        this.mRemoteVideo = new VideoCanvas((View)view, 1, uid);
        this.mRtcEngine.setupRemoteVideo(this.mRemoteVideo);
        SurfaceView localView = RtcEngine.CreateRendererView((Context)this.getBaseContext());
        this.localSurface_layout.removeAllViews();
        localView.setZOrderMediaOverlay(true);
        this.localSurface_layout.addView((View)localView);
        this.mLocalVideo = new VideoCanvas((View)localView, 1, 0);
        this.mRtcEngine.setupLocalVideo(this.mLocalVideo);
    }

    private void joinChannel() {
        EaseCallKitListener listener = EaseCallUIKit.getInstance().getCallListener();
        if (listener != null && EaseCallKitUtils.realizeGetToken(listener)) {
            listener.onGenerateToken(EMClient.getInstance().getCurrentUser(), this.channelName, EMClient.getInstance().getOptions().getAppKey(), new EaseCallKitTokenCallback(){

                @Override
                public void onSetToken(String token) {
                    if (token == null || token.length() == 0) {
                        EaseVideoCallActivity.this.mRtcEngine.joinChannelWithUserAccount(null, EaseVideoCallActivity.this.channelName, EMClient.getInstance().getCurrentUser());
                    } else {
                        EaseVideoCallActivity.this.mRtcEngine.joinChannelWithUserAccount(token, EaseVideoCallActivity.this.channelName, EMClient.getInstance().getCurrentUser());
                    }
                }

                @Override
                public void onGetTokenError(int error, String errorMsg) {
                    EMLog.e((String)TAG, (String)("onGenerateToken error :" + EMClient.getInstance().getAccessToken()));
                    EaseVideoCallActivity.this.exitChannel();
                }
            });
        } else {
            this.mRtcEngine.joinChannelWithUserAccount(null, this.channelName, EMClient.getInstance().getCurrentUser());
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.btn_refuse_call) {
            this.stopPlayRing();
            if (this.isInComingCall) {
                this.chronometer.stop();
                AnswerEvent event = new AnswerEvent();
                event.result = EaseMsgUtils.CALL_ANSWER_REFUSE;
                event.callId = EaseCallUIKit.getInstance().getCallID();
                event.callerDevId = EaseCallUIKit.getInstance().getClallee_devId();
                event.calleeDevId = EaseCallUIKit.deviceId;
                this.sendCmdMsg(event, this.username);
            }
        } else if (id2 == R.id.btn_answer_call) {
            if (this.isInComingCall) {
                this.stopPlayRing();
                AnswerEvent event = new AnswerEvent();
                event.result = EaseMsgUtils.CALL_ANSWER_ACCEPT;
                event.callId = EaseCallUIKit.getInstance().getCallID();
                event.callerDevId = EaseCallUIKit.getInstance().getClallee_devId();
                event.calleeDevId = EaseCallUIKit.deviceId;
                this.sendCmdMsg(event, this.username);
            }
        } else if (id2 == R.id.btn_hangup_call) {
            this.chronometer.stop();
            if (this.remoteUId == 0) {
                CallCancelEvent cancelEvent = new CallCancelEvent();
                this.sendCmdMsg(cancelEvent, this.username);
            } else {
                this.exitChannel();
                EaseCallKitListener listener = EaseCallUIKit.getInstance().getCallListener();
                if (listener != null) {
                    long time = this.getChronometerSeconds(this.chronometer);
                    listener.onEndCallWithReason(this.callType, this.channelName, EaseCallEndReason.EaseCallEndReasonHangup, time * 1000L);
                }
            }
        } else if (id2 == R.id.local_surface_layout) {
            this.changeSurface();
        } else if (id2 == R.id.btn_call_float) {
            this.showFloatWindow();
        } else if (id2 == R.id.iv_mute) {
            if (this.isMuteState) {
                this.muteImage.setImageResource(R.drawable.call_mute_normal);
                this.mRtcEngine.muteLocalAudioStream(false);
                this.isMuteState = false;
            } else {
                this.muteImage.setImageResource(R.drawable.call_mute_on);
                this.mRtcEngine.muteLocalAudioStream(true);
                this.isMuteState = true;
            }
        } else if (id2 == R.id.iv_handsfree) {
            if (this.isHandsfreeState) {
                this.handsFreeImage.setImageResource(R.drawable.em_icon_speaker_normal);
                this.closeSpeakerOn();
                this.isHandsfreeState = false;
            } else {
                this.handsFreeImage.setImageResource(R.drawable.em_icon_speaker_on);
                this.openSpeakerOn();
                this.isHandsfreeState = true;
            }
        } else if (id2 == R.id.btn_switch_camera) {
            if (this.mRtcEngine != null) {
                this.mRtcEngine.switchCamera();
            }
        } else if (id2 == R.id.btn_voice_trans) {
            if (this.callType == EaseCallType.SIGNAL_VOICE_CALL) {
                this.callType = EaseCallType.SIGNAL_VIDEO_CALL;
                EaseCallUIKit.getInstance().setCallType(EaseCallType.SIGNAL_VIDEO_CALL);
                EaseCallFloatWindow.getInstance(this.getApplicationContext()).setCallType(this.callType);
                this.changeVideoVoiceState();
                if (this.mRtcEngine != null) {
                    this.mRtcEngine.muteLocalVideoStream(false);
                }
            } else {
                this.callType = EaseCallType.SIGNAL_VOICE_CALL;
                EaseCallUIKit.getInstance().setCallType(EaseCallType.SIGNAL_VOICE_CALL);
                EaseCallFloatWindow.getInstance(this.getApplicationContext()).setCallType(this.callType);
                this.changeVideoVoiceState();
                if (this.mRtcEngine != null) {
                    this.mRtcEngine.muteLocalVideoStream(true);
                }
            }
        } else if (id2 == R.id.bnt_video_transe_comming || id2 == R.id.bnt_video_transe) {
            this.callType = EaseCallType.SIGNAL_VOICE_CALL;
            EaseCallUIKit.getInstance().setCallType(EaseCallType.SIGNAL_VOICE_CALL);
            EaseCallFloatWindow.getInstance(this.getApplicationContext()).setCallType(this.callType);
            if (this.mRtcEngine != null) {
                this.mRtcEngine.disableVideo();
                this.mRtcEngine.muteLocalVideoStream(true);
            }
            this.localSurface_layout.setVisibility(8);
            this.oppositeSurface_layout.setVisibility(8);
            this.rootView.setBackground(this.getResources().getDrawable(R.drawable.call_bg_voice));
            this.loadHeadImage();
            this.videoCallingGroup.setVisibility(8);
            this.video_transe_layout.setVisibility(8);
            this.video_transe_comming_layout.setVisibility(8);
            this.voiceCallingGroup.setVisibility(0);
            this.tv_nick_voice.setText((CharSequence)EaseCallKitUtils.getUserNickName(this.username));
            if (!this.isInComingCall) {
                this.voiceContronlLayout.setVisibility(0);
            }
            if (this.isInComingCall) {
                this.stopPlayRing();
                AnswerEvent event = new AnswerEvent();
                event.result = EaseMsgUtils.CALL_ANSWER_ACCEPT;
                event.callId = EaseCallUIKit.getInstance().getCallID();
                event.callerDevId = EaseCallUIKit.getInstance().getClallee_devId();
                event.calleeDevId = EaseCallUIKit.deviceId;
                event.transVoice = true;
                this.sendCmdMsg(event, this.username);
            } else {
                VideoToVoiceeEvent event = new VideoToVoiceeEvent();
                this.sendCmdMsg(event, this.username);
            }
        }
    }

    private void changeSurface() {
        if (this.changeFlag) {
            SurfaceView remoteview = RtcEngine.CreateRendererView((Context)this.getBaseContext());
            this.localSurface_layout.removeAllViews();
            this.localSurface_layout.addView((View)remoteview);
            remoteview.setZOrderMediaOverlay(true);
            this.mRemoteVideo = new VideoCanvas((View)remoteview, 1, this.remoteUId);
            this.mRtcEngine.setupRemoteVideo(this.mRemoteVideo);
            SurfaceView localview = RtcEngine.CreateRendererView((Context)this.getBaseContext());
            this.oppositeSurface_layout.removeAllViews();
            this.oppositeSurface_layout.addView((View)localview);
            this.mLocalVideo = new VideoCanvas((View)localview, 1, 0);
            this.mRtcEngine.setupLocalVideo(this.mLocalVideo);
            this.changeFlag = !this.changeFlag;
        } else {
            SurfaceView localview = RtcEngine.CreateRendererView((Context)this.getBaseContext());
            localview.setZOrderMediaOverlay(true);
            this.localSurface_layout.removeAllViews();
            this.localSurface_layout.addView((View)localview);
            this.mLocalVideo = new VideoCanvas((View)localview, 1, 0);
            this.mRtcEngine.setupLocalVideo(this.mLocalVideo);
            SurfaceView remoteview = RtcEngine.CreateRendererView((Context)this.getBaseContext());
            this.oppositeSurface_layout.removeAllViews();
            this.oppositeSurface_layout.addView((View)remoteview);
            this.mRemoteVideo = new VideoCanvas((View)remoteview, 1, this.remoteUId);
            this.mRtcEngine.setupRemoteVideo(this.mRemoteVideo);
            this.changeFlag = !this.changeFlag;
        }
    }

    private void leaveChannel() {
        if (this.mRtcEngine != null) {
            this.mRtcEngine.leaveChannel();
        }
    }

    private boolean checkSelfPermission(String permission2, int requestCode) {
        if (ContextCompat.checkSelfPermission((Context)this, (String)permission2) != 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])REQUESTED_PERMISSIONS, (int)requestCode);
            return false;
        }
        return true;
    }

    void changeVideoVoiceState() {
        if (this.callType == EaseCallType.SIGNAL_VIDEO_CALL) {
            this.Voice_View.setVisibility(8);
            this.avatarView.setVisibility(8);
            this.localSurface_layout.setVisibility(0);
            this.oppositeSurface_layout.setVisibility(0);
            this.makeOngoingStatus();
        } else {
            this.localSurface_layout.setVisibility(8);
            this.oppositeSurface_layout.setVisibility(8);
            this.rootView.setBackground(this.getResources().getDrawable(R.drawable.call_bg_voice));
            if (this.videoCalledGroup.getVisibility() == 0) {
                this.Voice_View.setVisibility(0);
                this.avatarView.setVisibility(0);
                this.tv_call_state_voice.setText((CharSequence)"\u901a\u8bdd\u4e2d");
                this.makeOngoingStatus();
            } else {
                this.localSurface_layout.setVisibility(8);
                this.oppositeSurface_layout.setVisibility(8);
                this.rootView.setBackground(this.getResources().getDrawable(R.drawable.call_bg_voice));
                if (this.isInComingCall) {
                    this.tv_call_state_voice.setText((CharSequence)"\u9080\u8bf7\u4f60\u8fdb\u884c\u97f3\u89c6\u9891\u901a\u8bdd");
                } else {
                    this.tv_call_state_voice.setText((CharSequence)"\u6b63\u5728\u7b49\u5f85\u5bf9\u65b9\u63a5\u53d7\u9080\u8bf7");
                    if (!this.isInComingCall) {
                        this.voiceContronlLayout.setVisibility(0);
                    }
                }
                this.videoCallingGroup.setVisibility(8);
                this.video_transe_layout.setVisibility(8);
                this.video_transe_comming_layout.setVisibility(8);
                this.voiceCallingGroup.setVisibility(0);
                this.tv_nick_voice.setText((CharSequence)EaseCallKitUtils.getUserNickName(this.username));
            }
            this.loadHeadImage();
        }
    }

    protected void addLiveDataObserver() {
        EaseLiveDataBus.get().with(EaseCallType.SIGNAL_VIDEO_CALL.toString(), BaseEvent.class).observe((LifecycleOwner)this, event -> {
            if (event != null) {
                switch (event.callAction) {
                    case CALL_ALERT: {
                        AlertEvent alertEvent = (AlertEvent)event;
                        ConfirmRingEvent ringEvent = new ConfirmRingEvent();
                        if (alertEvent.callId.equals(EaseCallUIKit.getInstance().getCallID()) && EaseCallUIKit.getInstance().getCallState() != EaseCallState.CALL_ANSWERED) {
                            ringEvent.calleeDevId = alertEvent.calleeDevId;
                            ringEvent.valid = true;
                            this.sendCmdMsg(ringEvent, this.username);
                        } else {
                            ringEvent.calleeDevId = alertEvent.calleeDevId;
                            ringEvent.valid = false;
                            this.sendCmdMsg(ringEvent, this.username);
                        }
                        this.mConfirm_ring = true;
                        break;
                    }
                    case CALL_CANCEL: {
                        if (!this.isInComingCall) {
                            this.timehandler.stopTime();
                        }
                        this.exitChannel();
                        EaseCallKitListener listener = EaseCallUIKit.getInstance().getCallListener();
                        if (listener == null) break;
                        listener.onEndCallWithReason(this.callType, this.channelName, EaseCallEndReason.EaseCallEndReasonRemoteCancel, 0L);
                        break;
                    }
                    case CALL_ANSWER: {
                        AnswerEvent answerEvent = (AnswerEvent)event;
                        ConfirmCallEvent callEvent = new ConfirmCallEvent();
                        boolean transVoice = answerEvent.transVoice;
                        callEvent.calleeDevId = answerEvent.calleeDevId;
                        callEvent.callerDevId = answerEvent.callerDevId;
                        callEvent.result = answerEvent.result;
                        if (answerEvent.result.equals(EaseMsgUtils.CALL_ANSWER_BUSY)) {
                            if (!this.mConfirm_ring) {
                                this.timehandler.stopTime();
                                this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        String info = EaseVideoCallActivity.this.getString(R.string.The_other_is_busy);
                                        Toast.makeText((Context)EaseVideoCallActivity.this.getApplicationContext(), (CharSequence)info, (int)0).show();
                                        EaseVideoCallActivity.this.exitChannel();
                                        EaseCallKitListener listener = EaseCallUIKit.getInstance().getCallListener();
                                        if (listener != null) {
                                            listener.onEndCallWithReason(EaseVideoCallActivity.this.callType, EaseVideoCallActivity.this.channelName, EaseCallEndReason.EaseCallEndReasonBusy, 0L);
                                        }
                                    }
                                });
                                break;
                            }
                            this.timehandler.stopTime();
                            this.sendCmdMsg(callEvent, this.username);
                            break;
                        }
                        if (answerEvent.result.equals(EaseMsgUtils.CALL_ANSWER_ACCEPT)) {
                            EaseCallUIKit.getInstance().setCallState(EaseCallState.CALL_ANSWERED);
                            this.timehandler.stopTime();
                            this.sendCmdMsg(callEvent, this.username);
                            if (!transVoice) break;
                            this.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    EaseVideoCallActivity.this.callType = EaseCallType.SIGNAL_VOICE_CALL;
                                    EaseCallUIKit.getInstance().setCallType(EaseCallType.SIGNAL_VOICE_CALL);
                                    EaseCallFloatWindow.getInstance(EaseVideoCallActivity.this.getApplicationContext()).setCallType(EaseVideoCallActivity.this.callType);
                                    EaseVideoCallActivity.this.changeVideoVoiceState();
                                }
                            });
                            break;
                        }
                        if (!answerEvent.result.equals(EaseMsgUtils.CALL_ANSWER_REFUSE)) break;
                        this.timehandler.stopTime();
                        this.sendCmdMsg(callEvent, this.username);
                        break;
                    }
                    case CALL_INVITE: {
                        InviteEvent inviteEvent = (InviteEvent)event;
                        if (inviteEvent.type != EaseCallType.SIGNAL_VOICE_CALL) break;
                        this.callType = EaseCallType.SIGNAL_VOICE_CALL;
                        EaseCallUIKit.getInstance().setCallType(EaseCallType.SIGNAL_VOICE_CALL);
                        EaseCallFloatWindow.getInstance(this.getApplicationContext()).setCallType(this.callType);
                        if (this.mRtcEngine != null) {
                            this.mRtcEngine.disableVideo();
                        }
                        this.changeVideoVoiceState();
                        break;
                    }
                    case CALL_CONFIRM_RING: {
                        break;
                    }
                    case CALL_CONFIRM_CALLEE: {
                        ConfirmCallEvent confirmEvent = (ConfirmCallEvent)event;
                        String deviceId = confirmEvent.calleeDevId;
                        final String result = confirmEvent.result;
                        this.timehandler.stopTime();
                        if (deviceId.equals(EaseCallUIKit.deviceId)) {
                            if (result.equals(EaseMsgUtils.CALL_ANSWER_ACCEPT)) {
                                EaseCallUIKit.getInstance().setCallState(EaseCallState.CALL_ANSWERED);
                                this.initEngineAndJoinChannel();
                                this.makeOngoingStatus();
                                break;
                            }
                            if (!result.equals(EaseMsgUtils.CALL_ANSWER_REFUSE)) break;
                            this.exitChannel();
                            break;
                        }
                        this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                String info = null;
                                if (result.equals(EaseMsgUtils.CALL_ANSWER_ACCEPT)) {
                                    info = EaseVideoCallActivity.this.getString(R.string.The_other_is_recived);
                                } else if (result.equals(EaseMsgUtils.CALL_ANSWER_REFUSE)) {
                                    info = EaseVideoCallActivity.this.getString(R.string.The_other_is_refused);
                                }
                                Toast.makeText((Context)EaseVideoCallActivity.this.getApplicationContext(), (CharSequence)info, (int)0).show();
                                EaseVideoCallActivity.this.exitChannel();
                                EaseCallKitListener listener = EaseCallUIKit.getInstance().getCallListener();
                                if (listener != null) {
                                    listener.onEndCallWithReason(EaseVideoCallActivity.this.callType, EaseVideoCallActivity.this.channelName, EaseCallEndReason.EaseCallEndReasonHandleOnOtherDevice, 0L);
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    private void sendInviteeMsg(String username, EaseCallType callType) {
        this.mConfirm_ring = false;
        final EMMessage message = callType == EaseCallType.SIGNAL_VIDEO_CALL ? EMMessage.createTxtSendMessage((String)"\u9080\u8bf7\u60a8\u8fdb\u884c\u89c6\u9891\u901a\u8bdd", (String)username) : EMMessage.createTxtSendMessage((String)"\u9080\u8bf7\u60a8\u8fdb\u884c\u8bed\u97f3\u901a\u8bdd", (String)username);
        message.setAttribute(EaseMsgUtils.CALL_ACTION, EaseCallAction.CALL_INVITE.state);
        message.setAttribute(EaseMsgUtils.CALL_CHANNELNAME, this.channelName);
        message.setAttribute(EaseMsgUtils.CALL_TYPE, callType.code);
        message.setAttribute(EaseMsgUtils.CALL_DEVICE_ID, EaseCallUIKit.deviceId);
        JSONObject object = EaseCallUIKit.getInstance().getInviteExt();
        if (object != null) {
            message.setAttribute(EaseMsgUtils.CALL_INVITE_EXT, object);
        } else {
            try {
                JSONObject obj = new JSONObject();
                message.setAttribute(EaseMsgUtils.CALL_INVITE_EXT, obj);
            }
            catch (Exception e) {
                e.getStackTrace();
            }
        }
        if (EaseCallUIKit.getInstance().getCallID() == null) {
            EaseCallUIKit.getInstance().setCallID(EaseCallKitUtils.getRandomString(10));
        }
        message.setAttribute(EaseMsgUtils.CLL_ID, EaseCallUIKit.getInstance().getCallID());
        message.setAttribute(EaseMsgUtils.CLL_TIMESTRAMEP, System.currentTimeMillis());
        message.setAttribute(EaseMsgUtils.CALL_MSG_TYPE, EaseMsgUtils.CALL_MSG_INFO);
        final EMConversation conversation = EMClient.getInstance().chatManager().getConversation(username, EMConversation.EMConversationType.Chat, true);
        message.setMessageStatusCallback(new EMCallBack(){

            public void onSuccess() {
                EMLog.d((String)TAG, (String)"Invite call success");
                conversation.removeMessage(message.getMsgId());
            }

            public void onError(int code, String error) {
                EMLog.e((String)TAG, (String)("Invite call error " + code + ", " + error));
                conversation.removeMessage(message.getMsgId());
                EaseCallKitListener listener = EaseCallUIKit.getInstance().getCallListener();
                if (listener != null) {
                    listener.onCallError(EaseCallUIKit.EaseCallError.IM_ERROR, code, error);
                }
            }

            public void onProgress(int progress, String status) {
            }
        });
        EMClient.getInstance().chatManager().sendMessage(message);
    }

    private void sendCmdMsg(final BaseEvent event, String username) {
        final EMMessage message = EMMessage.createSendMessage((EMMessage.Type)EMMessage.Type.CMD);
        String action = "rtcCall";
        EMCmdMessageBody cmdBody = new EMCmdMessageBody(action);
        message.setTo(username);
        message.addBody((EMMessageBody)cmdBody);
        if (event.callAction.equals((Object)EaseCallAction.CALL_VIDEO_TO_VOICE) || event.callAction.equals((Object)EaseCallAction.CALL_CANCEL)) {
            cmdBody.deliverOnlineOnly(false);
        } else {
            cmdBody.deliverOnlineOnly(true);
        }
        message.setAttribute(EaseMsgUtils.CALL_ACTION, event.callAction.state);
        message.setAttribute(EaseMsgUtils.CALL_DEVICE_ID, EaseCallUIKit.deviceId);
        message.setAttribute(EaseMsgUtils.CLL_ID, EaseCallUIKit.getInstance().getCallID());
        message.setAttribute(EaseMsgUtils.CLL_TIMESTRAMEP, System.currentTimeMillis());
        message.setAttribute(EaseMsgUtils.CALL_MSG_TYPE, EaseMsgUtils.CALL_MSG_INFO);
        if (event.callAction == EaseCallAction.CALL_CONFIRM_RING) {
            message.setAttribute(EaseMsgUtils.CALL_STATUS, ((ConfirmRingEvent)event).valid.booleanValue());
            message.setAttribute(EaseMsgUtils.CALLED_DEVICE_ID, ((ConfirmRingEvent)event).calleeDevId);
        } else if (event.callAction == EaseCallAction.CALL_CONFIRM_CALLEE) {
            message.setAttribute(EaseMsgUtils.CALL_RESULT, ((ConfirmCallEvent)event).result);
            message.setAttribute(EaseMsgUtils.CALLED_DEVICE_ID, ((ConfirmCallEvent)event).calleeDevId);
        } else if (event.callAction == EaseCallAction.CALL_ANSWER) {
            message.setAttribute(EaseMsgUtils.CALL_RESULT, ((AnswerEvent)event).result);
            message.setAttribute(EaseMsgUtils.CALLED_DEVICE_ID, ((AnswerEvent)event).calleeDevId);
            message.setAttribute(EaseMsgUtils.CALL_DEVICE_ID, ((AnswerEvent)event).callerDevId);
            message.setAttribute(EaseMsgUtils.CALLED_TRANSE_VOICE, ((AnswerEvent)event).transVoice);
        }
        final EMConversation conversation = EMClient.getInstance().chatManager().getConversation(username, EMConversation.EMConversationType.Chat, true);
        message.setMessageStatusCallback(new EMCallBack(){

            public void onSuccess() {
                EMLog.d((String)TAG, (String)"Invite call success");
                conversation.removeMessage(message.getMsgId());
                if (event.callAction == EaseCallAction.CALL_CANCEL) {
                    EaseVideoCallActivity.this.exitChannel();
                    boolean cancel = ((CallCancelEvent)event).cancel;
                    if (cancel) {
                        EaseVideoCallActivity.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                EaseCallKitListener listener = EaseCallUIKit.getInstance().getCallListener();
                                if (listener != null) {
                                    listener.onEndCallWithReason(EaseVideoCallActivity.this.callType, EaseVideoCallActivity.this.channelName, EaseCallEndReason.EaseCallEndReasonCancel, 0L);
                                }
                            }
                        });
                    } else {
                        EaseVideoCallActivity.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                EaseCallKitListener listener = EaseCallUIKit.getInstance().getCallListener();
                                if (listener != null) {
                                    listener.onEndCallWithReason(EaseVideoCallActivity.this.callType, EaseVideoCallActivity.this.channelName, EaseCallEndReason.EaseCallEndReasonRemoteNoResponse, 0L);
                                }
                            }
                        });
                    }
                } else if (event.callAction == EaseCallAction.CALL_CONFIRM_CALLEE) {
                    if (!((ConfirmCallEvent)event).result.equals(EaseMsgUtils.CALL_ANSWER_ACCEPT)) {
                        EaseVideoCallActivity.this.exitChannel();
                        String result = ((ConfirmCallEvent)event).result;
                        if (result.equals(EaseMsgUtils.CALL_ANSWER_REFUSE)) {
                            EaseVideoCallActivity.this.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    EaseCallKitListener listener = EaseCallUIKit.getInstance().getCallListener();
                                    if (listener != null) {
                                        listener.onEndCallWithReason(EaseVideoCallActivity.this.callType, EaseVideoCallActivity.this.channelName, EaseCallEndReason.EaseCallEndReasonRefuse, 0L);
                                    }
                                }
                            });
                        }
                    }
                } else if (event.callAction == EaseCallAction.CALL_ANSWER) {
                    EaseVideoCallActivity.this.timehandler.startTime();
                }
            }

            public void onError(int code, String error) {
                EaseCallKitListener listener;
                EMLog.e((String)TAG, (String)("Invite call error " + code + ", " + error));
                if (conversation != null) {
                    conversation.removeMessage(message.getMsgId());
                }
                if ((listener = EaseCallUIKit.getInstance().getCallListener()) != null) {
                    listener.onCallError(EaseCallUIKit.EaseCallError.IM_ERROR, code, error);
                }
                if (event.callAction == EaseCallAction.CALL_CANCEL) {
                    EaseVideoCallActivity.this.exitChannel();
                } else if (event.callAction == EaseCallAction.CALL_CONFIRM_CALLEE && !((ConfirmCallEvent)event).result.equals(EaseMsgUtils.CALL_ANSWER_ACCEPT)) {
                    EaseVideoCallActivity.this.exitChannel();
                }
            }

            public void onProgress(int progress, String status) {
            }
        });
        EMClient.getInstance().chatManager().sendMessage(message);
    }

    public long getChronometerSeconds(Chronometer cmt) {
        long totalss = 0L;
        String string2 = cmt.getText().toString();
        if (string2.length() == 7) {
            String[] split = string2.split(":");
            String string22 = split[0];
            int hour = Integer.parseInt(string22);
            int Hours = hour * 3600;
            String string3 = split[1];
            int min = Integer.parseInt(string3);
            int Mins = min * 60;
            int SS = Integer.parseInt(split[2]);
            totalss = Hours + Mins + SS;
            return totalss;
        }
        if (string2.length() == 5) {
            String[] split = string2.split(":");
            String string3 = split[0];
            int min = Integer.parseInt(string3);
            int Mins = min * 60;
            int SS = Integer.parseInt(split[1]);
            totalss = Mins + SS;
            return totalss;
        }
        return totalss;
    }

    private void loadHeadImage() {
        if (this.headUrl != null) {
            if (this.headUrl.startsWith("http://") || this.headUrl.startsWith("https://")) {
                new AsyncTask<String, Void, Bitmap>(){

                    protected Bitmap doInBackground(String ... params) {
                        Bitmap bitmap = null;
                        try {
                            String url = params[0];
                            URL HttpURL = new URL(url);
                            HttpURLConnection conn = (HttpURLConnection)HttpURL.openConnection();
                            conn.setDoInput(true);
                            conn.connect();
                            InputStream is = conn.getInputStream();
                            bitmap = BitmapFactory.decodeStream((InputStream)is);
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return bitmap;
                    }

                    protected void onPostExecute(Bitmap bitmap) {
                        if (bitmap != null) {
                            if (EaseCallUIKit.getInstance().getCallType() == EaseCallType.SIGNAL_VIDEO_CALL) {
                                EaseVideoCallActivity.this.avatarView.setImageBitmap(bitmap);
                            } else {
                                EaseVideoCallActivity.this.iv_avatar_voice.setImageBitmap(bitmap);
                            }
                        }
                    }
                }.execute((Object[])new String[]{this.headUrl});
            } else {
                if (this.headBitMap == null) {
                    this.headBitMap = BitmapFactory.decodeFile((String)this.headUrl);
                }
                if (EaseCallUIKit.getInstance().getCallType() == EaseCallType.SIGNAL_VIDEO_CALL) {
                    this.avatarView.setImageBitmap(this.headBitMap);
                } else {
                    this.iv_avatar_voice.setImageBitmap(this.headBitMap);
                }
            }
        }
    }

    private void playRing() {
        if (this.ringFile != null) {
            this.mediaPlayer = new MediaPlayer();
            try {
                this.mediaPlayer.setDataSource(this.ringFile);
                if (!this.mediaPlayer.isPlaying()) {
                    this.mediaPlayer.prepare();
                    this.mediaPlayer.start();
                    Log.e((String)TAG, (String)"playRing play file");
                }
            }
            catch (IOException e) {
                this.mediaPlayer = null;
            }
        } else {
            EMLog.d((String)TAG, (String)"playRing start play");
            if (this.ringtone != null) {
                this.ringtone.play();
                Log.e((String)TAG, (String)"playRing play ringtone");
            }
            EMLog.d((String)TAG, (String)"playRing start play end");
        }
    }

    private void stopPlayRing() {
        if (this.ringFile != null) {
            if (this.mediaPlayer != null) {
                this.mediaPlayer.stop();
                this.mediaPlayer = null;
            }
        } else if (this.ringtone != null) {
            this.ringtone.stop();
        }
    }

    private void showFloatWindow() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (Settings.canDrawOverlays((Context)this)) {
                this.doShowFloatWindow();
            } else if (!this.requestOverlayPermission) {
                try {
                    Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
                    intent.setData(Uri.parse((String)("package:" + this.getPackageName())));
                    this.startActivityForResult(intent, 1002);
                    this.requestOverlayPermission = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.doShowFloatWindow();
        }
    }

    private void doShowFloatWindow() {
        EaseCallFloatWindow.getInstance(this.getApplicationContext()).show();
        boolean surface = true;
        if (this.isInComingCall && EaseCallUIKit.getInstance().getCallState() != EaseCallState.CALL_ANSWERED) {
            surface = false;
        }
        if (this.changeFlag) {
            EaseCallFloatWindow.getInstance(this.getApplicationContext()).updateCallWindow(false, this.remoteUId, surface);
        } else {
            EaseCallFloatWindow.getInstance(this.getApplicationContext()).updateCallWindow(true, 0, surface);
        }
        this.moveTaskToBack(false);
    }

    protected void openSpeakerOn() {
        try {
            if (!this.audioManager.isSpeakerphoneOn()) {
                this.audioManager.setSpeakerphoneOn(true);
            }
            this.audioManager.setMode(3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void closeSpeakerOn() {
        try {
            if (this.audioManager != null) {
                if (this.audioManager.isSpeakerphoneOn()) {
                    this.audioManager.setSpeakerphoneOn(false);
                }
                this.audioManager.setMode(3);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void exitChannel() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                EMLog.i((String)TAG, (String)("exit channel channelName: " + EaseVideoCallActivity.this.channelName));
                if (EaseVideoCallActivity.this.isInComingCall) {
                    EaseVideoCallActivity.this.stopPlayRing();
                }
                EaseVideoCallActivity.this.finish();
            }
        });
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (intent != null) {
            int uId = intent.getIntExtra("uId", 0);
            if (EaseCallUIKit.getInstance().getCallState() == EaseCallState.CALL_ANSWERED) {
                if (uId == 0) {
                    SurfaceView localview = RtcEngine.CreateRendererView((Context)this.getBaseContext());
                    this.oppositeSurface_layout.removeAllViews();
                    this.oppositeSurface_layout.addView((View)localview);
                    this.mLocalVideo = new VideoCanvas((View)localview, 1, 0);
                    this.mRtcEngine.setupLocalVideo(this.mLocalVideo);
                    SurfaceView remoteview = RtcEngine.CreateRendererView((Context)this.getBaseContext());
                    this.localSurface_layout.removeAllViews();
                    this.localSurface_layout.addView((View)remoteview);
                    this.mRemoteVideo = new VideoCanvas((View)remoteview, 1, this.remoteUId);
                    this.mRtcEngine.setupRemoteVideo(this.mRemoteVideo);
                } else {
                    SurfaceView remoteView = RtcEngine.CreateRendererView((Context)this.getBaseContext());
                    this.oppositeSurface_layout.removeAllViews();
                    this.oppositeSurface_layout.addView((View)remoteView);
                    this.mRemoteVideo = new VideoCanvas((View)remoteView, 1, this.remoteUId);
                    this.mRtcEngine.setupRemoteVideo(this.mRemoteVideo);
                    SurfaceView localView = RtcEngine.CreateRendererView((Context)this.getBaseContext());
                    this.localSurface_layout.removeAllViews();
                    this.localSurface_layout.addView((View)localView);
                    this.mLocalVideo = new VideoCanvas((View)localView, 1, 0);
                    this.mRtcEngine.setupLocalVideo(this.mLocalVideo);
                }
            } else if (!this.isInComingCall) {
                SurfaceView localview = RtcEngine.CreateRendererView((Context)this.getBaseContext());
                this.oppositeSurface_layout.removeAllViews();
                this.oppositeSurface_layout.addView((View)localview);
                this.mLocalVideo = new VideoCanvas((View)localview, 1, 0);
                this.mRtcEngine.setupLocalVideo(this.mLocalVideo);
            }
        }
        EaseCallFloatWindow.getInstance(this.getApplicationContext()).dismiss();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        EMLog.i((String)TAG, (String)("onActivityResult: " + requestCode + ", result code: " + resultCode));
        if (requestCode == 1002 && Build.VERSION.SDK_INT >= 23) {
            this.requestOverlayPermission = false;
            if (Settings.canDrawOverlays((Context)this)) {
                this.doShowFloatWindow();
            } else {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.alert_window_permission_denied), (int)0).show();
            }
            return;
        }
    }

    protected void releaseHandler() {
        this.handler.sendEmptyMessage(EaseMsgUtils.MSG_RELEASE_HANDLER);
    }

    protected void onResume() {
        EMLog.d((String)TAG, (String)"onResumed");
        super.onResume();
    }

    protected void onPause() {
        EMLog.d((String)TAG, (String)"onPause");
        super.onPause();
    }

    protected void onDestroy() {
        EMLog.d((String)TAG, (String)"onDestroy");
        super.onDestroy();
        this.releaseHandler();
        if (this.timehandler != null) {
            this.timehandler.stopTime();
        }
        this.leaveChannel();
        RtcEngine.destroy();
        if (this.headBitMap != null) {
            this.headBitMap.recycle();
        }
        EaseCallUIKit.getInstance().setCallState(EaseCallState.CALL_IDEL);
        EaseCallUIKit.getInstance().setCallID(null);
    }

    private class TimeHandler
    extends Handler {
        private final int MSG_TIMER = 0;
        private DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        private int timePassed = 0;

        public TimeHandler() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        public void startTime() {
            this.timePassed = 0;
            this.sendEmptyMessageDelayed(0, 1000L);
        }

        public void stopTime() {
            this.removeMessages(0);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 0) {
                ++this.timePassed;
                String time = this.dateFormat.format(this.timePassed * 1000);
                EaseCallKitConfig callKitConfig = EaseCallUIKit.getInstance().getCallKitConfig();
                long intervalTime = callKitConfig != null ? callKitConfig.getCallTimeOut() : 30000L;
                if ((long)(this.timePassed * 1000) == intervalTime) {
                    EaseVideoCallActivity.this.timehandler.stopTime();
                    if (!EaseVideoCallActivity.this.isInComingCall) {
                        CallCancelEvent cancelEvent = new CallCancelEvent();
                        cancelEvent.cancel = false;
                        cancelEvent.remoteTimeout = true;
                        EaseVideoCallActivity.this.sendCmdMsg(cancelEvent, EaseVideoCallActivity.this.username);
                    } else {
                        EaseVideoCallActivity.this.exitChannel();
                        EaseCallKitListener listener = EaseCallUIKit.getInstance().getCallListener();
                        if (listener != null) {
                            listener.onEndCallWithReason(EaseVideoCallActivity.this.callType, EaseVideoCallActivity.this.channelName, EaseCallEndReason.EaseCallEndReasonRemoteNoResponse, 0L);
                        }
                    }
                }
                this.sendEmptyMessageDelayed(0, 1000L);
                return;
            }
            super.handleMessage(msg);
        }
    }
}

