/*
 * Decompiled with CFR 0.152.
 */
package easemob.hyphenate.calluikit.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.provider.Settings;
import android.util.Log;
import android.view.SurfaceView;
import android.view.View;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import com.hyphenate.EMCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCmdMessageBody;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMMessageBody;
import com.hyphenate.util.EMLog;
import easemob.hyphenate.calluikit.EaseCallUIKit;
import easemob.hyphenate.calluikit.R;
import easemob.hyphenate.calluikit.base.EaseCallEndReason;
import easemob.hyphenate.calluikit.base.EaseCallFloatWindow;
import easemob.hyphenate.calluikit.base.EaseCallKitConfig;
import easemob.hyphenate.calluikit.base.EaseCallKitListener;
import easemob.hyphenate.calluikit.base.EaseCallKitTokenCallback;
import easemob.hyphenate.calluikit.base.EaseCallMemberView;
import easemob.hyphenate.calluikit.base.EaseCallMemberViewGroup;
import easemob.hyphenate.calluikit.base.EaseCallType;
import easemob.hyphenate.calluikit.event.AlertEvent;
import easemob.hyphenate.calluikit.event.AnswerEvent;
import easemob.hyphenate.calluikit.event.BaseEvent;
import easemob.hyphenate.calluikit.event.CallCancelEvent;
import easemob.hyphenate.calluikit.event.ConfirmCallEvent;
import easemob.hyphenate.calluikit.event.ConfirmRingEvent;
import easemob.hyphenate.calluikit.livedatas.EaseLiveDataBus;
import easemob.hyphenate.calluikit.ui.EaseCommingCallView;
import easemob.hyphenate.calluikit.ui.EaseVideoCallActivity;
import easemob.hyphenate.calluikit.utils.EaseCallAction;
import easemob.hyphenate.calluikit.utils.EaseCallKitUtils;
import easemob.hyphenate.calluikit.utils.EaseCallState;
import easemob.hyphenate.calluikit.utils.EaseMsgUtils;
import io.agora.rtc.IRtcEngineEventHandler;
import io.agora.rtc.RtcEngine;
import io.agora.rtc.models.UserInfo;
import io.agora.rtc.video.VideoCanvas;
import io.agora.rtc.video.VideoEncoderConfiguration;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.json.JSONObject;

public class EaseMultipleVideoActivity
extends AppCompatActivity
implements View.OnClickListener {
    private static final String TAG = EaseVideoCallActivity.class.getSimpleName();
    private final int REQUEST_CODE_OVERLAY_PERMISSION = 1002;
    private TimeHandler timehandler;
    private TimeHandler timeUpdataTimer;
    private RtcEngine mRtcEngine;
    private EaseCommingCallView incomingCallView;
    private EaseCallMemberViewGroup callConferenceViewGroup;
    private TextView callTimeView;
    private ImageButton micSwitch;
    private ImageButton cameraSwitch;
    private ImageButton speakerSwitch;
    private ImageButton changeCameraSwitch;
    private ImageButton hangupBtn;
    private ImageView inviteBtn;
    private ImageView floatBtn;
    protected boolean isInComingCall;
    protected String username;
    protected String channelName;
    protected AudioManager audioManager;
    protected Ringtone ringtone;
    private String ringFile;
    private MediaPlayer mediaPlayer;
    private RelativeLayout viewGroupLayout;
    private volatile boolean mConfirm_ring = false;
    private String tokenUrl;
    private EaseCallType callType;
    private boolean isMuteState = false;
    private boolean isVideoMute = true;
    private EaseCallMemberView localMemberView;
    private Map<String, Long> inViteUserMap = new HashMap<String, Long>();
    private List<Integer> uidList = new ArrayList<Integer>();
    private String invite_ext;
    private boolean requestOverlayPermission;
    private String agoraAppId = null;
    private static final int PERMISSION_REQ_ID = 22;
    private static final String[] REQUESTED_PERMISSIONS = new String[]{"android.permission.RECORD_AUDIO", "android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"};
    private final HashMap<Integer, EaseCallMemberView> mUidsList = new HashMap();
    private final HashMap<Integer, UserInfo> userInfoList = new HashMap();
    private final HashMap<String, EaseCallMemberView> placeholderList = new HashMap();
    private final IRtcEngineEventHandler mRtcEventHandler = new IRtcEngineEventHandler(){

        public void onError(int err) {
            super.onError(err);
            EMLog.d((String)TAG, (String)("IRtcEngineEventHandler onError:" + err));
            EaseCallKitListener listener = EaseCallUIKit.getInstance().getCallListener();
            if (listener != null) {
                listener.onCallError(EaseCallUIKit.EaseCallError.RTC_ERROR, err, "rtc error");
            }
        }

        public void onJoinChannelSuccess(String channel, int uid, int elapsed) {
            ArrayList<String> userList;
            EMLog.d((String)TAG, (String)("onJoinChannelSuccess channel:" + channel + " uid" + uid));
            EaseMultipleVideoActivity.this.timeUpdataTimer.startTime(1);
            if (!EaseMultipleVideoActivity.this.isInComingCall && (userList = EaseCallUIKit.getInstance().getInviteeUsers()) != null && userList.size() > 0) {
                EaseMultipleVideoActivity.this.handler.sendEmptyMessage(EaseMsgUtils.MSG_MAKE_CONFERENCE_VIDEO);
                EaseMultipleVideoActivity.this.isInComingCall = false;
                EaseMultipleVideoActivity.this.timehandler.startTime(0);
            }
        }

        public void onRejoinChannelSuccess(String channel, int uid, int elapsed) {
            super.onRejoinChannelSuccess(channel, uid, elapsed);
        }

        public void onLeaveChannel(IRtcEngineEventHandler.RtcStats stats) {
            super.onLeaveChannel(stats);
        }

        public void onClientRoleChanged(int oldRole, int newRole) {
            super.onClientRoleChanged(oldRole, newRole);
        }

        public void onLocalUserRegistered(int uid, String userAccount) {
            super.onLocalUserRegistered(uid, userAccount);
        }

        public void onUserInfoUpdated(final int uid, final UserInfo userInfo) {
            EaseMultipleVideoActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    EMLog.d((String)TAG, (String)("onUserOffline " + ((long)uid & 0xFFFFFFFFL) + " account:" + userInfo.userAccount));
                    EaseMultipleVideoActivity.this.userInfoList.put(uid, userInfo);
                    EaseCallMemberView placeView = (EaseCallMemberView)((Object)EaseMultipleVideoActivity.this.placeholderList.remove(userInfo.userAccount));
                    if (placeView != null) {
                        EaseMultipleVideoActivity.this.callConferenceViewGroup.removeView((View)placeView);
                    }
                    if (EaseMultipleVideoActivity.this.mUidsList.containsKey(uid)) {
                        EaseCallMemberView memberView = (EaseCallMemberView)((Object)EaseMultipleVideoActivity.this.mUidsList.get(uid));
                        if (memberView != null) {
                            memberView.setUserInfo(userInfo);
                        }
                    } else {
                        EaseCallMemberView memberView = new EaseCallMemberView(EaseMultipleVideoActivity.this.getApplicationContext());
                        memberView.setUserInfo(userInfo);
                        EaseMultipleVideoActivity.this.callConferenceViewGroup.addView((View)memberView);
                        EaseMultipleVideoActivity.this.mUidsList.put(uid, memberView);
                    }
                }
            });
        }

        public void onUserJoined(int uid, int elapsed) {
            super.onUserJoined(uid, elapsed);
        }

        public void onUserOffline(final int uid, final int reason) {
            EaseMultipleVideoActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    EMLog.d((String)TAG, (String)("onUserOffline " + ((long)uid & 0xFFFFFFFFL) + " " + reason));
                    if (EaseMultipleVideoActivity.this.isFinishing()) {
                        return;
                    }
                    EaseCallMemberView memberView = (EaseCallMemberView)((Object)EaseMultipleVideoActivity.this.mUidsList.remove(uid));
                    if (memberView == null) {
                        return;
                    }
                    EaseMultipleVideoActivity.this.callConferenceViewGroup.removeView((View)memberView);
                    int uid2 = 0;
                    if (EaseMultipleVideoActivity.this.mUidsList.size() > 0) {
                        Set uidSet = EaseMultipleVideoActivity.this.mUidsList.keySet();
                        Iterator iterator = uidSet.iterator();
                        while (iterator.hasNext()) {
                            int id2;
                            uid2 = id2 = ((Integer)iterator.next()).intValue();
                        }
                        EaseMultipleVideoActivity.this.updateFloatWindow((EaseCallMemberView)((Object)EaseMultipleVideoActivity.this.mUidsList.get(uid2)));
                    }
                }
            });
        }

        public void onFirstRemoteVideoDecoded(final int uid, final int width, final int height, final int elapsed) {
            EaseMultipleVideoActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    EMLog.d((String)TAG, (String)("onFirstRemoteVideoDecoded" + ((long)uid & 0xFFFFFFFFL) + " " + width + " " + height + " " + elapsed));
                    if (EaseMultipleVideoActivity.this.isFinishing()) {
                        return;
                    }
                    if (EaseMultipleVideoActivity.this.mUidsList.containsKey(uid)) {
                        EaseCallMemberView memberView = (EaseCallMemberView)((Object)EaseMultipleVideoActivity.this.mUidsList.get(uid));
                        if (EaseMultipleVideoActivity.this.userInfoList.containsKey(uid)) {
                            memberView.setUserInfo((UserInfo)EaseMultipleVideoActivity.this.userInfoList.get(uid));
                        }
                        if (memberView != null) {
                            EaseCallMemberView placeView = (EaseCallMemberView)((Object)EaseMultipleVideoActivity.this.placeholderList.remove(memberView.getUserAccount()));
                            if (placeView != null) {
                                EaseMultipleVideoActivity.this.callConferenceViewGroup.removeView((View)placeView);
                            }
                            if (memberView.getSurfaceView() == null) {
                                SurfaceView surfaceView = RtcEngine.CreateRendererView((Context)EaseMultipleVideoActivity.this.getApplicationContext());
                                memberView.addSurfaceView(surfaceView);
                                surfaceView.setZOrderOnTop(false);
                                memberView.setVideoOff(false);
                                surfaceView.setZOrderMediaOverlay(false);
                                EaseMultipleVideoActivity.this.mRtcEngine.setupRemoteVideo(new VideoCanvas((View)surfaceView, 1, uid));
                            } else {
                                memberView.setVideoOff(false);
                            }
                        }
                    } else {
                        EaseCallMemberView placeView;
                        SurfaceView surfaceView = RtcEngine.CreateRendererView((Context)EaseMultipleVideoActivity.this.getApplicationContext());
                        EaseCallMemberView memberView = new EaseCallMemberView(EaseMultipleVideoActivity.this.getApplicationContext());
                        if (EaseMultipleVideoActivity.this.userInfoList.containsKey(uid)) {
                            memberView.setUserInfo((UserInfo)EaseMultipleVideoActivity.this.userInfoList.get(uid));
                        }
                        if ((placeView = (EaseCallMemberView)((Object)EaseMultipleVideoActivity.this.placeholderList.remove(memberView.getUserAccount()))) != null) {
                            EaseMultipleVideoActivity.this.callConferenceViewGroup.removeView((View)placeView);
                        }
                        memberView.addSurfaceView(surfaceView);
                        EaseMultipleVideoActivity.this.callConferenceViewGroup.addView((View)memberView);
                        memberView.setVideoOff(false);
                        EaseMultipleVideoActivity.this.mUidsList.put(uid, memberView);
                        surfaceView.setZOrderOnTop(false);
                        surfaceView.setZOrderMediaOverlay(false);
                        EaseMultipleVideoActivity.this.mRtcEngine.setupRemoteVideo(new VideoCanvas((View)surfaceView, 1, uid));
                    }
                }
            });
        }

        @Deprecated
        public void onFirstRemoteAudioFrame(final int uid, final int elapsed) {
            EaseMultipleVideoActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    EMLog.d((String)TAG, (String)("onFirstRemoteVideoDecoded" + ((long)uid & 0xFFFFFFFFL) + " " + elapsed));
                    if (EaseMultipleVideoActivity.this.isFinishing()) {
                        return;
                    }
                    if (EaseMultipleVideoActivity.this.mUidsList.containsKey(uid)) {
                        EaseCallMemberView placeView;
                        EaseCallMemberView memberView = (EaseCallMemberView)((Object)EaseMultipleVideoActivity.this.mUidsList.get(uid));
                        if (memberView != null) {
                            memberView.setAudioOff(false);
                        }
                        if (EaseMultipleVideoActivity.this.userInfoList.containsKey(uid)) {
                            memberView.setUserInfo((UserInfo)EaseMultipleVideoActivity.this.userInfoList.get(uid));
                        }
                        if ((placeView = (EaseCallMemberView)((Object)EaseMultipleVideoActivity.this.placeholderList.remove(memberView.getUserAccount()))) != null) {
                            EaseMultipleVideoActivity.this.callConferenceViewGroup.removeView((View)placeView);
                        }
                    } else {
                        EaseCallMemberView placeView;
                        EaseCallMemberView memberView = new EaseCallMemberView(EaseMultipleVideoActivity.this.getApplicationContext());
                        if (EaseMultipleVideoActivity.this.userInfoList.containsKey(uid)) {
                            memberView.setUserInfo((UserInfo)EaseMultipleVideoActivity.this.userInfoList.get(uid));
                        }
                        if ((placeView = (EaseCallMemberView)((Object)EaseMultipleVideoActivity.this.placeholderList.remove(memberView.getUserAccount()))) != null) {
                            EaseMultipleVideoActivity.this.callConferenceViewGroup.removeView((View)placeView);
                        }
                        memberView.setAudioOff(false);
                        EaseMultipleVideoActivity.this.callConferenceViewGroup.addView((View)memberView);
                        EaseMultipleVideoActivity.this.mUidsList.put(uid, memberView);
                    }
                }
            });
        }

        public void onRemoteVideoStateChanged(final int uid, final int state, int reason, int elapsed) {
            EaseMultipleVideoActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    EaseCallMemberView memberView = (EaseCallMemberView)((Object)EaseMultipleVideoActivity.this.mUidsList.get(uid));
                    if (memberView != null) {
                        EaseCallMemberView floatView;
                        if (state == 0 || state == 5) {
                            memberView.setVideoOff(true);
                        } else if (state == 2 || state == 6) {
                            memberView.setVideoOff(false);
                        }
                        if ((state == 0 || state == 5 || state == 2 || state == 6) && (floatView = EaseCallFloatWindow.getInstance(EaseMultipleVideoActivity.this.getApplicationContext()).getCallMemberView()) != null && floatView.getUserId() == uid) {
                            EaseMultipleVideoActivity.this.updateFloatWindow((EaseCallMemberView)((Object)EaseMultipleVideoActivity.this.mUidsList.get(uid)));
                        }
                    }
                }
            });
        }

        public void onRemoteAudioStateChanged(final int uid, final int state, int reason, int elapsed) {
            EaseMultipleVideoActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    EaseCallMemberView memberView = (EaseCallMemberView)((Object)EaseMultipleVideoActivity.this.mUidsList.get(uid));
                    if (memberView != null) {
                        if (state == 5 || state == 0) {
                            memberView.setAudioOff(true);
                        } else if (state == 2 || state == 6) {
                            memberView.setAudioOff(false);
                        }
                    }
                }
            });
        }

        public void onAudioVolumeIndication(final IRtcEngineEventHandler.AudioVolumeInfo[] speakers, int totalVolume) {
            EaseMultipleVideoActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (speakers != null && speakers.length > 0) {
                        Set uidSet = EaseMultipleVideoActivity.this.mUidsList.keySet();
                        EaseMultipleVideoActivity.this.uidList.clear();
                        for (Integer uId : uidSet) {
                            EaseMultipleVideoActivity.this.uidList.add(new Integer(uId));
                        }
                        for (IRtcEngineEventHandler.AudioVolumeInfo info : speakers) {
                            EaseCallMemberView memberView;
                            Integer uId = info.uid;
                            int volume = info.volume;
                            EMLog.d((String)TAG, (String)("onAudioVolumeIndication" + ((long)uId.intValue() & 0xFFFFFFFFL) + "  volume: " + volume));
                            if (!EaseMultipleVideoActivity.this.uidList.contains(uId) || (memberView = (EaseCallMemberView)((Object)EaseMultipleVideoActivity.this.mUidsList.get(uId))) == null || memberView.getAudioOff()) continue;
                            memberView.setSpeak(true, volume);
                            EaseMultipleVideoActivity.this.uidList.remove(uId);
                        }
                        if (EaseMultipleVideoActivity.this.uidList.size() > 0) {
                            Iterator iterator = EaseMultipleVideoActivity.this.uidList.iterator();
                            while (iterator.hasNext()) {
                                int uid = (Integer)iterator.next();
                                EaseCallMemberView memberView = (EaseCallMemberView)((Object)EaseMultipleVideoActivity.this.mUidsList.get(uid));
                                if (memberView == null || memberView.getAudioOff()) continue;
                                memberView.setSpeak(false, 0);
                            }
                        }
                    }
                }
            });
        }
    };
    private EaseCommingCallView.OnActionListener onActionListener = new EaseCommingCallView.OnActionListener(){

        @Override
        public void onPickupClick(View v) {
            EaseMultipleVideoActivity.this.stopPlayRing();
            EaseMultipleVideoActivity.this.incomingCallView.setVisibility(8);
            if (EaseMultipleVideoActivity.this.isInComingCall) {
                AnswerEvent event = new AnswerEvent();
                event.result = EaseMsgUtils.CALL_ANSWER_ACCEPT;
                event.callId = EaseCallUIKit.getInstance().getCallID();
                event.callerDevId = EaseCallUIKit.getInstance().getClallee_devId();
                event.calleeDevId = EaseCallUIKit.deviceId;
                EaseMultipleVideoActivity.this.sendCmdMsg(event, EaseMultipleVideoActivity.this.username);
            }
        }

        @Override
        public void onRejectClick(View v) {
            if (EaseMultipleVideoActivity.this.isInComingCall) {
                EaseMultipleVideoActivity.this.stopPlayRing();
                AnswerEvent event = new AnswerEvent();
                event.result = EaseMsgUtils.CALL_ANSWER_REFUSE;
                event.callId = EaseCallUIKit.getInstance().getCallID();
                event.callerDevId = EaseCallUIKit.getInstance().getClallee_devId();
                event.calleeDevId = EaseCallUIKit.deviceId;
                EaseMultipleVideoActivity.this.sendCmdMsg(event, EaseMultipleVideoActivity.this.username);
            }
        }
    };
    private EaseCallMemberViewGroup.OnScreenModeChangeListener onScreenModeChangeListener = new EaseCallMemberViewGroup.OnScreenModeChangeListener(){

        @Override
        public void onScreenModeChange(boolean isFullScreenMode, @Nullable View fullScreenView) {
            if (isFullScreenMode) {
                // empty if block
            }
        }
    };
    private EaseCallMemberViewGroup.OnItemClickListener onItemClickListener = new EaseCallMemberViewGroup.OnItemClickListener(){

        @Override
        public void onItemClick(View v, int position) {
        }
    };
    HandlerThread callHandlerThread = new HandlerThread("callHandlerThread");
    protected Handler handler;

    public EaseMultipleVideoActivity() {
        this.callHandlerThread.start();
        this.handler = new Handler(this.callHandlerThread.getLooper()){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 100: {
                        break;
                    }
                    case 101: {
                        break;
                    }
                    case 102: {
                        ArrayList<String> sendInviteeMsg = EaseCallUIKit.getInstance().getInviteeUsers();
                        EaseMultipleVideoActivity.this.sendInviteeMsg(sendInviteeMsg, EaseCallType.CONFERENCE_CALL);
                        break;
                    }
                    case 301: {
                        EaseMultipleVideoActivity.this.handler.removeMessages(100);
                        EaseMultipleVideoActivity.this.handler.removeMessages(101);
                        EaseMultipleVideoActivity.this.handler.removeMessages(102);
                        EaseMultipleVideoActivity.this.callHandlerThread.quit();
                        break;
                    }
                    case 400: {
                        EaseMultipleVideoActivity.this.tokenUrl = EaseMsgUtils.TOKEN_SERVER;
                        EaseMultipleVideoActivity.this.tokenUrl = EaseMultipleVideoActivity.this.tokenUrl + EaseMsgUtils.APPCERT;
                        EaseMultipleVideoActivity.this.tokenUrl = EaseMultipleVideoActivity.this.tokenUrl + EaseMsgUtils.ADDAMARK;
                        EaseMultipleVideoActivity.this.tokenUrl = EaseMultipleVideoActivity.this.tokenUrl + EaseMultipleVideoActivity.this.getString(R.string.agora_app_cert);
                        EaseMultipleVideoActivity.this.tokenUrl = EaseMultipleVideoActivity.this.tokenUrl + EaseMsgUtils.APPKEY;
                        EaseMultipleVideoActivity.this.tokenUrl = EaseMultipleVideoActivity.this.tokenUrl + EaseMsgUtils.ADDAMARK;
                        EaseMultipleVideoActivity.this.tokenUrl = EaseMultipleVideoActivity.this.tokenUrl + EaseMultipleVideoActivity.this.getString(R.string.agora_app_id);
                        EaseMultipleVideoActivity.this.tokenUrl = EaseMultipleVideoActivity.this.tokenUrl + EaseMsgUtils.CHANNEL;
                        EaseMultipleVideoActivity.this.tokenUrl = EaseMultipleVideoActivity.this.tokenUrl + EaseMsgUtils.ADDAMARK;
                        EaseMultipleVideoActivity.this.tokenUrl = EaseMultipleVideoActivity.this.tokenUrl + EaseMultipleVideoActivity.this.channelName;
                        EaseMultipleVideoActivity.this.tokenUrl = EaseMultipleVideoActivity.this.tokenUrl + EaseMsgUtils.USERID;
                        EaseMultipleVideoActivity.this.tokenUrl = EaseMultipleVideoActivity.this.tokenUrl + EaseMsgUtils.ADDAMARK;
                        EaseMultipleVideoActivity.this.tokenUrl = EaseMultipleVideoActivity.this.tokenUrl + EMClient.getInstance().getCurrentUser();
                    }
                }
            }
        };
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_ease_multiple_video);
        if (savedInstanceState == null) {
            this.initParams(this.getIntent().getExtras());
        } else {
            this.initParams(savedInstanceState);
        }
        this.initView();
        this.addLiveDataObserver();
        if (!this.checkSelfPermission(REQUESTED_PERMISSIONS[0], 22) || !this.checkSelfPermission(REQUESTED_PERMISSIONS[1], 22) || this.checkSelfPermission(REQUESTED_PERMISSIONS[2], 22)) {
            // empty if block
        }
        this.timehandler = new TimeHandler();
        this.timeUpdataTimer = new TimeHandler();
        EaseCallFloatWindow.getInstance(this.getApplicationContext()).setCallType(EaseCallType.CONFERENCE_CALL);
    }

    private void initView() {
        this.incomingCallView = (EaseCommingCallView)this.findViewById(R.id.incoming_call_view);
        this.viewGroupLayout = (RelativeLayout)this.findViewById(R.id.viewGroupLayout);
        this.callConferenceViewGroup = (EaseCallMemberViewGroup)this.findViewById(R.id.surface_view_group);
        this.inviteBtn = (ImageView)this.findViewById(R.id.btn_invite);
        this.callTimeView = (TextView)this.findViewById(R.id.tv_call_time);
        this.micSwitch = (ImageButton)this.findViewById(R.id.btn_mic_switch);
        this.cameraSwitch = (ImageButton)this.findViewById(R.id.btn_camera_switch);
        this.speakerSwitch = (ImageButton)this.findViewById(R.id.btn_speaker_switch);
        this.changeCameraSwitch = (ImageButton)this.findViewById(R.id.btn_change_camera_switch);
        this.hangupBtn = (ImageButton)this.findViewById(R.id.btn_hangup);
        this.floatBtn = (ImageView)this.findViewById(R.id.btn_float);
        this.incomingCallView.setOnActionListener(this.onActionListener);
        this.callConferenceViewGroup.setOnItemClickListener(this.onItemClickListener);
        this.callConferenceViewGroup.setOnScreenModeChangeListener(this.onScreenModeChangeListener);
        this.inviteBtn.setOnClickListener((View.OnClickListener)this);
        this.micSwitch.setOnClickListener((View.OnClickListener)this);
        this.speakerSwitch.setOnClickListener((View.OnClickListener)this);
        this.cameraSwitch.setOnClickListener((View.OnClickListener)this);
        this.changeCameraSwitch.setOnClickListener((View.OnClickListener)this);
        this.hangupBtn.setOnClickListener((View.OnClickListener)this);
        this.floatBtn.setOnClickListener((View.OnClickListener)this);
        this.audioManager = (AudioManager)this.getSystemService("audio");
        this.micSwitch.setActivated(false);
        this.cameraSwitch.setActivated(true);
        this.speakerSwitch.setActivated(true);
        this.openSpeakerOn();
        this.ringFile = EaseCallKitUtils.getRingFile();
        if (this.isInComingCall) {
            this.audioManager = (AudioManager)this.getSystemService("audio");
            Uri ringUri = RingtoneManager.getDefaultUri((int)1);
            this.audioManager.setMode(1);
            this.audioManager.setSpeakerphoneOn(true);
            this.ringtone = RingtoneManager.getRingtone((Context)this, (Uri)ringUri);
            AudioManager am = (AudioManager)this.getApplication().getSystemService("audio");
            int ringerMode = am.getRingerMode();
            if (ringerMode == 2) {
                this.playRing();
            }
            this.incomingCallView.setInviteInfo(this.username);
            this.incomingCallView.setVisibility(0);
        } else {
            this.incomingCallView.setVisibility(8);
            this.initEngineAndJoinChannel();
        }
    }

    private void initParams(Bundle bundle) {
        if (bundle != null) {
            this.isInComingCall = bundle.getBoolean("isComingCall", false);
            this.username = bundle.getString("username");
            this.channelName = bundle.getString("channelName");
            this.callType = EaseCallUIKit.getInstance().getCallType();
        }
    }

    private void initEngineAndJoinChannel() {
        this.initializeEngine();
        this.setupVideoConfig();
        this.setupLocalVideo();
        this.joinChannel();
    }

    private void initializeEngine() {
        try {
            EaseCallKitConfig config = EaseCallUIKit.getInstance().getCallKitConfig();
            if (config != null) {
                this.agoraAppId = config.getAgoraAppId();
            }
            this.mRtcEngine = RtcEngine.create((Context)this.getBaseContext(), (String)this.agoraAppId, (IRtcEngineEventHandler)this.mRtcEventHandler);
            EaseCallFloatWindow.getInstance(this.getApplicationContext()).setRtcEngine(this.mRtcEngine);
        }
        catch (Exception e) {
            EMLog.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            throw new RuntimeException("NEED TO check rtc sdk init fatal error\n" + Log.getStackTraceString((Throwable)e));
        }
    }

    private void setupVideoConfig() {
        this.mRtcEngine.enableVideo();
        this.mRtcEngine.muteLocalVideoStream(true);
        this.mRtcEngine.setVideoEncoderConfiguration(new VideoEncoderConfiguration(VideoEncoderConfiguration.VD_1280x720, VideoEncoderConfiguration.FRAME_RATE.FRAME_RATE_FPS_15, 0, VideoEncoderConfiguration.ORIENTATION_MODE.ORIENTATION_MODE_FIXED_PORTRAIT));
        int res = this.mRtcEngine.enableAudioVolumeIndication(500, 3, false);
    }

    private void setupLocalVideo() {
        SurfaceView surfaceView = RtcEngine.CreateRendererView((Context)this.getApplicationContext());
        this.localMemberView = new EaseCallMemberView(this.getApplicationContext());
        this.localMemberView.addSurfaceView(surfaceView);
        this.localMemberView.setVideoOff(true);
        UserInfo info = new UserInfo();
        info.userAccount = EMClient.getInstance().getCurrentUser();
        info.uid = 0;
        this.localMemberView.setUserInfo(info);
        this.callConferenceViewGroup.addView((View)this.localMemberView);
        this.mUidsList.put(0, this.localMemberView);
        surfaceView.setZOrderOnTop(false);
        surfaceView.setZOrderMediaOverlay(false);
        this.mRtcEngine.setupLocalVideo(new VideoCanvas((View)surfaceView, 1, 0));
    }

    private void joinChannel() {
        EaseCallKitListener listener = EaseCallUIKit.getInstance().getCallListener();
        if (listener != null && EaseCallKitUtils.realizeGetToken(listener)) {
            listener.onGenerateToken(EMClient.getInstance().getCurrentUser(), this.channelName, EMClient.getInstance().getOptions().getAppKey(), new EaseCallKitTokenCallback(){

                @Override
                public void onSetToken(String token) {
                    if (token == null || token.length() == 0) {
                        EaseMultipleVideoActivity.this.mRtcEngine.joinChannelWithUserAccount(null, EaseMultipleVideoActivity.this.channelName, EMClient.getInstance().getCurrentUser());
                    } else {
                        EaseMultipleVideoActivity.this.mRtcEngine.joinChannelWithUserAccount(token, EaseMultipleVideoActivity.this.channelName, EMClient.getInstance().getCurrentUser());
                    }
                }

                @Override
                public void onGetTokenError(int error, String errorMsg) {
                    EMLog.e((String)TAG, (String)("onGenerateToken error :" + EMClient.getInstance().getAccessToken()));
                    EaseMultipleVideoActivity.this.exitChannel();
                }
            });
        } else {
            this.mRtcEngine.joinChannelWithUserAccount(null, this.channelName, EMClient.getInstance().getCurrentUser());
        }
    }

    public void onClick(View view) {
        EaseCallKitListener listener;
        int id2 = view.getId();
        if (view.getId() == R.id.btn_mic_switch) {
            if (this.isMuteState) {
                this.localMemberView.setAudioOff(false);
                this.mRtcEngine.muteLocalAudioStream(false);
                this.micSwitch.setBackground(this.getResources().getDrawable(R.drawable.audio_unmute));
                this.isMuteState = false;
            } else {
                this.localMemberView.setAudioOff(true);
                this.mRtcEngine.muteLocalAudioStream(true);
                this.micSwitch.setBackground(this.getResources().getDrawable(R.drawable.audio_mute));
                this.isMuteState = true;
            }
        } else if (view.getId() == R.id.btn_speaker_switch) {
            if (this.speakerSwitch.isActivated()) {
                this.speakerSwitch.setActivated(false);
                this.speakerSwitch.setBackground(this.getResources().getDrawable(R.drawable.voice_off));
                this.closeSpeakerOn();
            } else {
                this.speakerSwitch.setActivated(true);
                this.speakerSwitch.setBackground(this.getResources().getDrawable(R.drawable.voice_on));
                this.openSpeakerOn();
            }
        } else if (view.getId() == R.id.btn_camera_switch) {
            if (this.isVideoMute) {
                this.localMemberView.setVideoOff(false);
                this.cameraSwitch.setBackground(this.getResources().getDrawable(R.drawable.video_on));
                this.mRtcEngine.muteLocalVideoStream(false);
                this.isVideoMute = false;
            } else {
                this.localMemberView.setVideoOff(true);
                this.mRtcEngine.muteLocalVideoStream(true);
                this.cameraSwitch.setBackground(this.getResources().getDrawable(R.drawable.video_0ff));
                this.isVideoMute = true;
            }
        } else if (view.getId() == R.id.btn_change_camera_switch) {
            if (this.mRtcEngine != null) {
                this.mRtcEngine.switchCamera();
            }
        } else if (view.getId() == R.id.btn_hangup) {
            this.exitChannel();
            EaseCallKitListener listener2 = EaseCallUIKit.getInstance().getCallListener();
            if (listener2 != null) {
                long time = this.timeUpdataTimer.timePassed;
                listener2.onEndCallWithReason(this.callType, this.channelName, EaseCallEndReason.EaseCallEndReasonHangup, this.timeUpdataTimer.timePassed * 1000);
            }
        } else if (view.getId() == R.id.btn_float) {
            this.showFloatWindow();
        } else if (view.getId() == R.id.btn_invite && (listener = EaseCallUIKit.getInstance().getCallListener()) != null) {
            Set<Integer> userset = this.mUidsList.keySet();
            int size = userset.size();
            JSONObject object = EaseCallUIKit.getInstance().getInviteExt();
            if (size > 0) {
                String[] users = new String[size];
                int i = 0;
                for (Integer user : userset) {
                    if (this.mUidsList.get(user) == null) continue;
                    users[i++] = this.mUidsList.get(user).getUserAccount();
                }
                listener.onInviteUsers(this.getApplicationContext(), users, object);
            } else {
                listener.onInviteUsers(this.getApplicationContext(), null, object);
            }
        }
    }

    protected void addLiveDataObserver() {
        EaseLiveDataBus.get().with(EaseCallType.SIGNAL_VIDEO_CALL.toString(), BaseEvent.class).observe((LifecycleOwner)this, event -> {
            if (event != null) {
                switch (event.callAction) {
                    case CALL_ALERT: {
                        AlertEvent alertEvent = (AlertEvent)event;
                        ConfirmRingEvent ringEvent = new ConfirmRingEvent();
                        String user = alertEvent.userId;
                        if (alertEvent.callId.equals(EaseCallUIKit.getInstance().getCallID()) && this.inViteUserMap.containsKey(user)) {
                            ringEvent.calleeDevId = alertEvent.calleeDevId;
                            ringEvent.valid = true;
                            ringEvent.userId = alertEvent.userId;
                            this.sendCmdMsg(ringEvent, alertEvent.userId);
                        } else {
                            ringEvent.calleeDevId = alertEvent.calleeDevId;
                            ringEvent.valid = false;
                            this.sendCmdMsg(ringEvent, alertEvent.userId);
                        }
                        this.mConfirm_ring = true;
                        break;
                    }
                    case CALL_CANCEL: {
                        if (!this.isInComingCall) {
                            this.timehandler.stopTime();
                        }
                        this.exitChannel();
                        break;
                    }
                    case CALL_ANSWER: {
                        final AnswerEvent answerEvent = (AnswerEvent)event;
                        ConfirmCallEvent callEvent = new ConfirmCallEvent();
                        callEvent.calleeDevId = answerEvent.calleeDevId;
                        callEvent.result = answerEvent.result;
                        final String userId = answerEvent.userId;
                        this.inViteUserMap.remove(userId);
                        if (answerEvent.result.equals(EaseMsgUtils.CALL_ANSWER_BUSY)) {
                            if (!this.mConfirm_ring) {
                                this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        EaseCallMemberView placeView = (EaseCallMemberView)((Object)EaseMultipleVideoActivity.this.placeholderList.remove(userId));
                                        if (placeView != null) {
                                            EaseMultipleVideoActivity.this.callConferenceViewGroup.removeView((View)placeView);
                                        }
                                        String info = answerEvent.userId;
                                        info = info + EaseMultipleVideoActivity.this.getString(R.string.The_other_is_busy);
                                        Toast.makeText((Context)EaseMultipleVideoActivity.this.getApplicationContext(), (CharSequence)info, (int)0).show();
                                    }
                                });
                                break;
                            }
                            this.sendCmdMsg(callEvent, this.username);
                            break;
                        }
                        if (answerEvent.result.equals(EaseMsgUtils.CALL_ANSWER_ACCEPT)) {
                            EaseCallUIKit.getInstance().setCallState(EaseCallState.CALL_ANSWERED);
                            this.sendCmdMsg(callEvent, answerEvent.userId);
                            break;
                        }
                        if (!answerEvent.result.equals(EaseMsgUtils.CALL_ANSWER_REFUSE)) break;
                        this.sendCmdMsg(callEvent, answerEvent.userId);
                        this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                EaseCallMemberView placeView = (EaseCallMemberView)((Object)EaseMultipleVideoActivity.this.placeholderList.remove(userId));
                                if (placeView != null) {
                                    EaseMultipleVideoActivity.this.callConferenceViewGroup.removeView((View)placeView);
                                }
                            }
                        });
                        break;
                    }
                    case CALL_CONFIRM_RING: {
                        break;
                    }
                    case CALL_CONFIRM_CALLEE: {
                        ConfirmCallEvent confirmEvent = (ConfirmCallEvent)event;
                        String deviceId = confirmEvent.calleeDevId;
                        final String result = confirmEvent.result;
                        this.timehandler.stopTime();
                        if (deviceId.equals(EaseCallUIKit.deviceId)) {
                            if (result.equals(EaseMsgUtils.CALL_ANSWER_ACCEPT)) {
                                this.initEngineAndJoinChannel();
                                break;
                            }
                            if (!result.equals(EaseMsgUtils.CALL_ANSWER_REFUSE)) break;
                            this.exitChannel();
                            EaseCallKitListener listener = EaseCallUIKit.getInstance().getCallListener();
                            if (listener == null) break;
                            listener.onEndCallWithReason(this.callType, this.channelName, EaseCallEndReason.EaseCallEndReasonRefuse, 0L);
                            break;
                        }
                        this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                String info = null;
                                if (result.equals(EaseMsgUtils.CALL_ANSWER_ACCEPT)) {
                                    info = EaseMultipleVideoActivity.this.getString(R.string.The_other_is_recived);
                                } else if (result.equals(EaseMsgUtils.CALL_ANSWER_REFUSE)) {
                                    info = EaseMultipleVideoActivity.this.getString(R.string.The_other_is_refused);
                                }
                                Toast.makeText((Context)EaseMultipleVideoActivity.this.getApplicationContext(), (CharSequence)info, (int)0).show();
                                EaseMultipleVideoActivity.this.exitChannel();
                                EaseCallKitListener listener = EaseCallUIKit.getInstance().getCallListener();
                                if (listener != null) {
                                    listener.onEndCallWithReason(EaseMultipleVideoActivity.this.callType, EaseMultipleVideoActivity.this.channelName, EaseCallEndReason.EaseCallEndReasonHandleOnOtherDevice, 0L);
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    protected void openSpeakerOn() {
        try {
            if (!this.audioManager.isSpeakerphoneOn()) {
                this.audioManager.setSpeakerphoneOn(true);
            }
            this.audioManager.setMode(3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void closeSpeakerOn() {
        try {
            if (this.audioManager != null) {
                if (this.audioManager.isSpeakerphoneOn()) {
                    this.audioManager.setSpeakerphoneOn(false);
                }
                this.audioManager.setMode(3);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void leaveChannel() {
        if (this.mRtcEngine != null) {
            this.mRtcEngine.leaveChannel();
        }
    }

    private void updateConferenceTime(String time) {
        this.callTimeView.setText((CharSequence)time);
    }

    private void sendInviteeMsg(ArrayList<String> userArray, EaseCallType callType) {
        for (final String username : userArray) {
            long totalMilliSeconds = System.currentTimeMillis();
            EaseCallKitConfig callKitConfig = EaseCallUIKit.getInstance().getCallKitConfig();
            long intervalTime = callKitConfig != null ? callKitConfig.getCallTimeOut() : 30000L;
            this.inViteUserMap.put(username, totalMilliSeconds += intervalTime);
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    EaseCallMemberView memberView = new EaseCallMemberView(EaseMultipleVideoActivity.this.getApplicationContext());
                    UserInfo userInfo = new UserInfo();
                    userInfo.userAccount = username;
                    memberView.setUserInfo(userInfo);
                    memberView.setLoading(true);
                    EaseMultipleVideoActivity.this.callConferenceViewGroup.addView((View)memberView);
                    EaseMultipleVideoActivity.this.placeholderList.put(username, memberView);
                }
            });
            final EMMessage message = EMMessage.createTxtSendMessage((String)"\u9080\u8bf7\u60a8\u8fdb\u884c\u591a\u4eba\u97f3\u89c6\u9891\u901a\u8bdd", (String)username);
            message.setAttribute(EaseMsgUtils.CALL_ACTION, EaseCallAction.CALL_INVITE.state);
            message.setAttribute(EaseMsgUtils.CALL_CHANNELNAME, this.channelName);
            message.setAttribute(EaseMsgUtils.CALL_TYPE, callType.code);
            message.setAttribute(EaseMsgUtils.CALL_DEVICE_ID, EaseCallUIKit.deviceId);
            JSONObject object = EaseCallUIKit.getInstance().getInviteExt();
            if (object != null) {
                message.setAttribute(EaseMsgUtils.CALL_INVITE_EXT, object);
            } else {
                try {
                    JSONObject obj = new JSONObject();
                    message.setAttribute(EaseMsgUtils.CALL_INVITE_EXT, obj);
                }
                catch (Exception e) {
                    e.getStackTrace();
                }
            }
            if (EaseCallUIKit.getInstance().getCallID() == null) {
                EaseCallUIKit.getInstance().setCallID(EaseCallKitUtils.getRandomString(10));
            }
            message.setAttribute(EaseMsgUtils.CLL_ID, EaseCallUIKit.getInstance().getCallID());
            message.setAttribute(EaseMsgUtils.CLL_TIMESTRAMEP, System.currentTimeMillis());
            message.setAttribute(EaseMsgUtils.CALL_MSG_TYPE, EaseMsgUtils.CALL_MSG_INFO);
            final EMConversation conversation = EMClient.getInstance().chatManager().getConversation(username, EMConversation.EMConversationType.Chat, true);
            message.setMessageStatusCallback(new EMCallBack(){

                public void onSuccess() {
                    EMLog.d((String)TAG, (String)("Invite call success username:" + username));
                    conversation.removeMessage(message.getMsgId());
                }

                public void onError(int code, String error) {
                    EMLog.e((String)TAG, (String)("Invite call error " + code + ", " + error + " username:" + username));
                    conversation.removeMessage(message.getMsgId());
                    EaseCallKitListener listener = EaseCallUIKit.getInstance().getCallListener();
                    if (listener != null) {
                        listener.onCallError(EaseCallUIKit.EaseCallError.IM_ERROR, code, error);
                    }
                }

                public void onProgress(int progress, String status) {
                }
            });
            EMClient.getInstance().chatManager().sendMessage(message);
        }
        EaseCallUIKit.getInstance().InitInviteeUsers();
    }

    private void sendCmdMsg(final BaseEvent event, String username) {
        final EMMessage message = EMMessage.createSendMessage((EMMessage.Type)EMMessage.Type.CMD);
        String action = "rtcCall";
        EMCmdMessageBody cmdBody = new EMCmdMessageBody(action);
        message.setTo(username);
        message.addBody((EMMessageBody)cmdBody);
        if (event.callAction.equals((Object)EaseCallAction.CALL_CANCEL)) {
            cmdBody.deliverOnlineOnly(false);
        } else {
            cmdBody.deliverOnlineOnly(true);
        }
        message.setAttribute(EaseMsgUtils.CALL_ACTION, event.callAction.state);
        message.setAttribute(EaseMsgUtils.CALL_DEVICE_ID, EaseCallUIKit.deviceId);
        message.setAttribute(EaseMsgUtils.CLL_ID, EaseCallUIKit.getInstance().getCallID());
        message.setAttribute(EaseMsgUtils.CLL_TIMESTRAMEP, System.currentTimeMillis());
        message.setAttribute(EaseMsgUtils.CALL_MSG_TYPE, EaseMsgUtils.CALL_MSG_INFO);
        if (event.callAction == EaseCallAction.CALL_CONFIRM_RING) {
            message.setAttribute(EaseMsgUtils.CALL_STATUS, ((ConfirmRingEvent)event).valid.booleanValue());
            message.setAttribute(EaseMsgUtils.CALLED_DEVICE_ID, ((ConfirmRingEvent)event).calleeDevId);
        } else if (event.callAction == EaseCallAction.CALL_CONFIRM_CALLEE) {
            message.setAttribute(EaseMsgUtils.CALL_RESULT, ((ConfirmCallEvent)event).result);
            message.setAttribute(EaseMsgUtils.CALLED_DEVICE_ID, ((ConfirmCallEvent)event).calleeDevId);
        } else if (event.callAction == EaseCallAction.CALL_ANSWER) {
            message.setAttribute(EaseMsgUtils.CALL_RESULT, ((AnswerEvent)event).result);
            message.setAttribute(EaseMsgUtils.CALLED_DEVICE_ID, ((AnswerEvent)event).calleeDevId);
            message.setAttribute(EaseMsgUtils.CALL_DEVICE_ID, ((AnswerEvent)event).callerDevId);
        }
        final EMConversation conversation = EMClient.getInstance().chatManager().getConversation(username, EMConversation.EMConversationType.Chat, true);
        message.setMessageStatusCallback(new EMCallBack(){

            public void onSuccess() {
                EMLog.d((String)TAG, (String)"Invite call success");
                conversation.removeMessage(message.getMsgId());
                if (event.callAction != EaseCallAction.CALL_CANCEL && event.callAction == EaseCallAction.CALL_ANSWER) {
                    EaseMultipleVideoActivity.this.timehandler.startTime(0);
                }
            }

            public void onError(int code, String error) {
                EMLog.e((String)TAG, (String)("Invite call error " + code + ", " + error));
                conversation.removeMessage(message.getMsgId());
                EaseCallKitListener listener = EaseCallUIKit.getInstance().getCallListener();
                if (listener != null) {
                    listener.onCallError(EaseCallUIKit.EaseCallError.IM_ERROR, code, error);
                }
                if (event.callAction == EaseCallAction.CALL_CANCEL) {
                    EaseMultipleVideoActivity.this.exitChannel();
                }
            }

            public void onProgress(int progress, String status) {
            }
        });
        EMClient.getInstance().chatManager().sendMessage(message);
    }

    private boolean checkSelfPermission(String permission2, int requestCode) {
        if (ContextCompat.checkSelfPermission((Context)this, (String)permission2) != 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])REQUESTED_PERMISSIONS, (int)requestCode);
            return false;
        }
        return true;
    }

    private void playRing() {
        if (this.ringFile != null) {
            this.mediaPlayer = new MediaPlayer();
            try {
                this.mediaPlayer.setDataSource(this.ringFile);
                if (!this.mediaPlayer.isPlaying()) {
                    this.mediaPlayer.prepare();
                    this.mediaPlayer.start();
                }
            }
            catch (IOException e) {
                this.mediaPlayer = null;
            }
        } else {
            this.ringtone.play();
        }
    }

    private void stopPlayRing() {
        if (this.ringFile != null) {
            if (this.mediaPlayer != null) {
                this.mediaPlayer.stop();
                this.mediaPlayer = null;
            }
        } else if (this.ringtone != null) {
            this.ringtone.stop();
        }
    }

    void exitChannel() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                EMLog.i((String)TAG, (String)("exit channel channelName: " + EaseMultipleVideoActivity.this.channelName));
                if (EaseMultipleVideoActivity.this.isInComingCall) {
                    EaseMultipleVideoActivity.this.stopPlayRing();
                    EMLog.i((String)TAG, (String)("exit channel stopPlayRing " + EaseMultipleVideoActivity.this.channelName));
                } else if (EaseMultipleVideoActivity.this.inViteUserMap.size() > 0) {
                    if (EaseMultipleVideoActivity.this.timehandler != null) {
                        EaseMultipleVideoActivity.this.timehandler.stopTime();
                    }
                    Set userSet = EaseMultipleVideoActivity.this.inViteUserMap.keySet();
                    for (String userName : userSet) {
                        CallCancelEvent cancelEvent = new CallCancelEvent();
                        EaseMultipleVideoActivity.this.sendCmdMsg(cancelEvent, userName);
                        EaseMultipleVideoActivity.this.inViteUserMap.remove(userName);
                        EaseCallMemberView memberView = (EaseCallMemberView)((Object)EaseMultipleVideoActivity.this.placeholderList.remove(userName));
                        if (memberView == null) continue;
                        EaseMultipleVideoActivity.this.callConferenceViewGroup.removeView((View)memberView);
                    }
                }
                EaseMultipleVideoActivity.this.finish();
            }
        });
    }

    private void showFloatWindow() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (Settings.canDrawOverlays((Context)this)) {
                this.doShowFloatWindow();
            } else if (!this.requestOverlayPermission) {
                try {
                    Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
                    intent.setData(Uri.parse((String)("package:" + this.getPackageName())));
                    this.startActivityForResult(intent, 1002);
                    this.requestOverlayPermission = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.doShowFloatWindow();
        }
    }

    private void doShowFloatWindow() {
        EaseCallFloatWindow.getInstance(this.getApplicationContext()).show();
        int uid = 0;
        if (this.mUidsList.size() > 0) {
            Set<Integer> uidSet = this.mUidsList.keySet();
            Iterator<Integer> iterator = uidSet.iterator();
            while (iterator.hasNext()) {
                int id2;
                uid = id2 = iterator.next().intValue();
            }
            EaseCallMemberView memberView = this.mUidsList.get(uid);
            EaseCallFloatWindow.getInstance(this.getApplicationContext()).update(memberView);
        }
        this.moveTaskToBack(false);
    }

    private void updateFloatWindow(EaseCallMemberView memberView) {
        if (memberView != null) {
            EaseCallFloatWindow.getInstance(this.getApplicationContext()).update(memberView);
        }
    }

    protected void onNewIntent(Intent intent) {
        boolean isFloatWindow;
        super.onNewIntent(intent);
        ArrayList<String> users = EaseCallUIKit.getInstance().getInviteeUsers();
        if (users != null && users.size() > 0) {
            this.handler.sendEmptyMessage(EaseMsgUtils.MSG_MAKE_CONFERENCE_VIDEO);
        }
        if (isFloatWindow = intent.getBooleanExtra("isFloatWindow", false)) {
            int uId = intent.getIntExtra("uId", 0);
            EaseCallMemberView memberView = this.mUidsList.get(uId);
            if (memberView != null) {
                SurfaceView surfaceView = RtcEngine.CreateRendererView((Context)this.getApplicationContext());
                memberView.addSurfaceView(surfaceView);
                surfaceView.setZOrderOnTop(false);
                surfaceView.setZOrderMediaOverlay(false);
                if (uId == 0) {
                    this.mRtcEngine.setupLocalVideo(new VideoCanvas((View)surfaceView, 1, uId));
                } else {
                    this.mRtcEngine.setupRemoteVideo(new VideoCanvas((View)surfaceView, 1, uId));
                }
            }
            EaseCallFloatWindow.getInstance(this.getApplicationContext()).dismiss();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        EMLog.i((String)TAG, (String)("onActivityResult: " + requestCode + ", result code: " + resultCode));
        if (requestCode == 1002 && Build.VERSION.SDK_INT >= 23) {
            this.requestOverlayPermission = false;
            if (Settings.canDrawOverlays((Context)this)) {
                this.doShowFloatWindow();
            } else {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.alert_window_permission_denied), (int)0).show();
            }
            return;
        }
    }

    protected void releaseHandler() {
        this.handler.sendEmptyMessage(EaseMsgUtils.MSG_RELEASE_HANDLER);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.releaseHandler();
        if (this.timehandler != null) {
            this.timehandler.stopTime();
        }
        if (this.timeUpdataTimer != null) {
            this.timeUpdataTimer.stopTime();
        }
        if (this.mUidsList != null) {
            this.mUidsList.clear();
        }
        if (this.userInfoList != null) {
            this.userInfoList.clear();
        }
        this.leaveChannel();
        RtcEngine.destroy();
        EaseCallUIKit.getInstance().setCallState(EaseCallState.CALL_IDEL);
        EaseCallUIKit.getInstance().setCallID(null);
        EaseCallUIKit.getInstance().setMultipleVideoActivity(null);
    }

    private class TimeHandler
    extends Handler {
        private DateFormat dateFormat = new SimpleDateFormat("mm:ss");
        private int timePassed = 0;

        public TimeHandler() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        public void startTime(int timeType) {
            this.timePassed = 0;
            this.sendEmptyMessageDelayed(timeType, 1000L);
        }

        public void stopTime() {
            this.removeMessages(1);
            this.removeMessages(0);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 0) {
                ++this.timePassed;
                String time = this.dateFormat.format(this.timePassed * 1000);
                if (!EaseMultipleVideoActivity.this.isInComingCall) {
                    long totalMilliSeconds = System.currentTimeMillis();
                    Set userSet = EaseMultipleVideoActivity.this.inViteUserMap.keySet();
                    for (String userName : userSet) {
                        if (totalMilliSeconds < (Long)EaseMultipleVideoActivity.this.inViteUserMap.get(userName)) continue;
                        CallCancelEvent cancelEvent = new CallCancelEvent();
                        EaseMultipleVideoActivity.this.sendCmdMsg(cancelEvent, userName);
                        EaseMultipleVideoActivity.this.inViteUserMap.remove(userName);
                        EaseCallMemberView memberView = (EaseCallMemberView)((Object)EaseMultipleVideoActivity.this.placeholderList.remove(userName));
                        if (memberView == null) continue;
                        EaseMultipleVideoActivity.this.callConferenceViewGroup.removeView((View)memberView);
                    }
                    if (EaseMultipleVideoActivity.this.inViteUserMap.size() == 0) {
                        EaseMultipleVideoActivity.this.timehandler.stopTime();
                    }
                } else {
                    EaseCallKitConfig callKitConfig = EaseCallUIKit.getInstance().getCallKitConfig();
                    long intervalTime = callKitConfig != null ? callKitConfig.getCallTimeOut() : 30000L;
                    if ((long)(this.timePassed * 1000) == intervalTime) {
                        EaseMultipleVideoActivity.this.timehandler.stopTime();
                        EaseMultipleVideoActivity.this.exitChannel();
                        EaseCallKitListener listener = EaseCallUIKit.getInstance().getCallListener();
                        if (listener != null) {
                            listener.onEndCallWithReason(EaseMultipleVideoActivity.this.callType, EaseMultipleVideoActivity.this.channelName, EaseCallEndReason.EaseCallEndReasonRemoteNoResponse, 0L);
                        }
                    }
                }
                this.sendEmptyMessageDelayed(0, 1000L);
            } else if (msg.what == 1) {
                ++this.timePassed;
                String time = this.dateFormat.format(this.timePassed * 1000);
                EaseMultipleVideoActivity.this.updateConferenceTime(time);
                this.sendEmptyMessageDelayed(1, 1000L);
            }
            super.handleMessage(msg);
        }
    }
}

