/*
 * Decompiled with CFR 0.152.
 */
package easemob.hyphenate.calluikit.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hyphenate.util.EMLog;
import easemob.hyphenate.calluikit.R;
import easemob.hyphenate.calluikit.ui.EaseVideoCallActivity;
import easemob.hyphenate.calluikit.utils.EaseCallKitUtils;
import easemob.hyphenate.calluikit.widget.EaseImageView;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class EaseCommingCallView
extends FrameLayout {
    private static final String TAG = EaseVideoCallActivity.class.getSimpleName();
    private ImageButton mBtnReject;
    private ImageButton mBtnPickup;
    private TextView mInviterName;
    private OnActionListener mOnActionListener;
    private EaseImageView avatar_view;
    private Bitmap headBitMap;
    private String headUrl;

    public EaseCommingCallView(@NonNull Context context) {
        this(context, null);
    }

    public EaseCommingCallView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EaseCommingCallView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.activity_comming_call, (ViewGroup)this);
        this.mBtnReject = (ImageButton)this.findViewById(R.id.btn_reject);
        this.mBtnPickup = (ImageButton)this.findViewById(R.id.btn_pickup);
        this.mInviterName = (TextView)this.findViewById(R.id.tv_nick);
        this.avatar_view = (EaseImageView)this.findViewById(R.id.iv_avatar);
        this.mBtnReject.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (EaseCommingCallView.this.mOnActionListener != null) {
                    EaseCommingCallView.this.mOnActionListener.onRejectClick(v);
                }
            }
        });
        this.mBtnPickup.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (EaseCommingCallView.this.mOnActionListener != null) {
                    EaseCommingCallView.this.mOnActionListener.onPickupClick(v);
                }
            }
        });
    }

    public void setInviteInfo(String username) {
        this.mInviterName.setText((CharSequence)EaseCallKitUtils.getUserNickName(username));
        this.headUrl = EaseCallKitUtils.getUserHeadImage(username);
        this.loadHeadImage();
    }

    private void loadHeadImage() {
        if (this.headUrl != null) {
            if (this.headUrl.startsWith("http://") || this.headUrl.startsWith("https://")) {
                new AsyncTask<String, Void, Bitmap>(){

                    protected Bitmap doInBackground(String ... params) {
                        Bitmap bitmap = null;
                        try {
                            String url = params[0];
                            URL HttpURL = new URL(url);
                            HttpURLConnection conn = (HttpURLConnection)HttpURL.openConnection();
                            conn.setDoInput(true);
                            conn.connect();
                            InputStream is = conn.getInputStream();
                            bitmap = BitmapFactory.decodeStream((InputStream)is);
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return bitmap;
                    }

                    protected void onPostExecute(Bitmap bitmap) {
                        if (bitmap != null && !bitmap.isRecycled()) {
                            EaseCommingCallView.this.avatar_view.setImageBitmap(bitmap);
                        }
                    }
                }.execute((Object[])new String[]{this.headUrl});
            } else {
                if (this.headBitMap == null) {
                    this.headBitMap = BitmapFactory.decodeFile((String)this.headUrl);
                }
                if (this.headBitMap != null && !this.headBitMap.isRecycled()) {
                    this.avatar_view.setImageBitmap(this.headBitMap);
                } else {
                    EMLog.d((String)TAG, (String)"headBitMap is isRecycled");
                }
            }
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
    }

    public void setOnActionListener(OnActionListener listener) {
        this.mOnActionListener = listener;
    }

    float[] getScreenInfo(Context context) {
        WindowManager manager = (WindowManager)context.getSystemService("window");
        float[] info = new float[5];
        if (manager != null) {
            DisplayMetrics dm = new DisplayMetrics();
            manager.getDefaultDisplay().getMetrics(dm);
            info[0] = dm.widthPixels;
            info[1] = dm.heightPixels;
            info[2] = dm.densityDpi;
            info[3] = dm.density;
            info[4] = dm.scaledDensity;
        }
        return info;
    }

    public static interface OnActionListener {
        public void onRejectClick(View var1);

        public void onPickupClick(View var1);
    }
}

