/*
 * Decompiled with CFR 0.152.
 */
package easemob.hyphenate.calluikit.base;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import easemob.hyphenate.calluikit.R;
import easemob.hyphenate.calluikit.utils.EaseCallKitUtils;
import io.agora.rtc.models.UserInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class EaseCallMemberView
extends RelativeLayout {
    private Context context;
    private RelativeLayout surfaceViewLayout;
    private ImageView avatarView;
    private ImageView audioOffView;
    private ImageView talkingView;
    private TextView nameView;
    private SurfaceView surfaceView;
    private ValueAnimator animator;
    private UserInfo userInfo;
    private boolean isVideoOff = true;
    private boolean isAudioOff = false;
    private boolean isDesktop = false;
    private boolean isFullScreenMode = false;
    private String streamId;
    private Bitmap headBitMap;
    private String headUrl;
    private EaseCallMemberView memberView;
    private LinearLayout loading_dialog;

    public EaseCallMemberView(Context context) {
        this(context, null);
    }

    public EaseCallMemberView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EaseCallMemberView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        LayoutInflater.from((Context)context).inflate(R.layout.avtivity_call_member, (ViewGroup)this);
        this.init();
    }

    private void init() {
        this.surfaceViewLayout = (RelativeLayout)this.findViewById(R.id.item_surface_layout);
        this.avatarView = (ImageView)this.findViewById(R.id.img_call_avatar);
        this.audioOffView = (ImageView)this.findViewById(R.id.icon_mute);
        this.talkingView = (ImageView)this.findViewById(R.id.icon_talking);
        this.nameView = (TextView)this.findViewById(R.id.text_name);
        this.loading_dialog = (LinearLayout)this.findViewById(R.id.member_loading);
    }

    public void setLoading(Boolean loading) {
        if (loading.booleanValue()) {
            this.loading_dialog.setVisibility(0);
        } else {
            this.loading_dialog.setVisibility(8);
        }
    }

    public void addSurfaceView(SurfaceView surfaceView) {
        this.surfaceViewLayout.addView((View)surfaceView);
        this.surfaceView = surfaceView;
    }

    public void setUserInfo(UserInfo info) {
        this.userInfo = info;
        if (this.userInfo != null) {
            this.nameView.setText((CharSequence)EaseCallKitUtils.getUserNickName(info.userAccount));
            this.headUrl = EaseCallKitUtils.getUserHeadImage(info.userAccount);
            if (this.headUrl != null) {
                this.loadHeadImage();
            } else {
                this.avatarView.setBackgroundResource(R.drawable.call_memberview_background);
            }
        }
    }

    public String getUserAccount() {
        if (this.userInfo != null) {
            return this.userInfo.userAccount;
        }
        return null;
    }

    public int getUserId() {
        if (this.userInfo != null) {
            return this.userInfo.uid;
        }
        return 0;
    }

    public SurfaceView getSurfaceView() {
        return this.surfaceView;
    }

    public void setAudioOff(boolean state) {
        this.isAudioOff = state;
        if (this.isFullScreenMode) {
            return;
        }
        if (this.isAudioOff) {
            this.audioOffView.setVisibility(0);
            this.audioOffView.setImageResource(R.drawable.ease_mic_level_off);
        } else {
            this.audioOffView.setVisibility(8);
            this.audioOffView.setImageResource(R.drawable.ease_mic_level_on);
        }
    }

    public boolean getAudioOff() {
        return this.isAudioOff;
    }

    public void setSpeak(boolean speak, int volume) {
        if (speak) {
            int value = 1;
            value = volume / 15;
            if (value > 14) {
                value = 14;
            }
            this.audioOffView.setVisibility(0);
            if (value == 1) {
                this.audioOffView.setImageResource(R.drawable.ease_mic_level_01);
            } else if (value == 2) {
                this.audioOffView.setImageResource(R.drawable.ease_mic_level_02);
            } else if (value == 3) {
                this.audioOffView.setImageResource(R.drawable.ease_mic_level_03);
            } else if (value == 4) {
                this.audioOffView.setImageResource(R.drawable.ease_mic_level_04);
            } else if (value == 5) {
                this.audioOffView.setImageResource(R.drawable.ease_mic_level_05);
            } else if (value == 6) {
                this.audioOffView.setImageResource(R.drawable.ease_mic_level_06);
            } else if (value == 7) {
                this.audioOffView.setImageResource(R.drawable.ease_mic_level_07);
            } else if (value == 8) {
                this.audioOffView.setImageResource(R.drawable.ease_mic_level_08);
            } else if (value == 9) {
                this.audioOffView.setImageResource(R.drawable.ease_mic_level_09);
            } else if (value == 10) {
                this.audioOffView.setImageResource(R.drawable.ease_mic_level_10);
            } else if (value == 11) {
                this.audioOffView.setImageResource(R.drawable.ease_mic_level_11);
            } else if (value == 12) {
                this.audioOffView.setImageResource(R.drawable.ease_mic_level_12);
            } else if (value == 13) {
                this.audioOffView.setImageResource(R.drawable.ease_mic_level_13);
            } else if (value == 14) {
                this.audioOffView.setImageResource(R.drawable.ease_mic_level_14);
            }
        } else {
            this.audioOffView.setVisibility(8);
        }
    }

    public boolean isAudioOff() {
        return this.isAudioOff;
    }

    public void setVideoOff(boolean state) {
        this.isVideoOff = state;
        if (this.isVideoOff) {
            this.avatarView.setVisibility(0);
            this.surfaceViewLayout.setVisibility(8);
        } else {
            this.avatarView.setVisibility(8);
            this.surfaceViewLayout.setVisibility(0);
        }
    }

    public boolean isVideoOff() {
        return this.isVideoOff;
    }

    public void setDesktop(boolean desktop) {
        this.isDesktop = desktop;
        if (this.isDesktop) {
            this.avatarView.setVisibility(8);
        }
    }

    public void setUsername(String username) {
        this.headUrl = EaseCallKitUtils.getUserHeadImage(username);
        if (this.headUrl != null) {
            this.avatarView.setImageResource(R.drawable.call_memberview_background);
        } else {
            this.avatarView.setImageResource(R.drawable.call_memberview_background);
        }
        this.nameView.setText((CharSequence)EaseCallKitUtils.getUserNickName(username));
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setFullScreen(boolean fullScreen) {
        this.isFullScreenMode = fullScreen;
        if (fullScreen) {
            this.talkingView.setVisibility(8);
            this.nameView.setVisibility(8);
            this.audioOffView.setVisibility(8);
        } else {
            this.nameView.setVisibility(0);
            if (this.isAudioOff) {
                this.audioOffView.setVisibility(0);
            }
        }
    }

    private void loadHeadImage() {
        if (this.headUrl != null) {
            if (this.headUrl.startsWith("http://") || this.headUrl.startsWith("https://")) {
                new AsyncTask<String, Void, Bitmap>(){

                    protected Bitmap doInBackground(String ... params) {
                        Bitmap bitmap = null;
                        try {
                            String url = params[0];
                            URL HttpURL = new URL(url);
                            HttpURLConnection conn = (HttpURLConnection)HttpURL.openConnection();
                            conn.setDoInput(true);
                            conn.connect();
                            InputStream is = conn.getInputStream();
                            bitmap = BitmapFactory.decodeStream((InputStream)is);
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return bitmap;
                    }

                    protected void onPostExecute(Bitmap bitmap) {
                        if (bitmap != null) {
                            EaseCallMemberView.this.avatarView.setImageBitmap(bitmap);
                            EaseCallMemberView.this.avatarView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                        }
                    }
                }.execute((Object[])new String[]{this.headUrl});
            } else {
                if (this.headBitMap == null) {
                    this.headBitMap = BitmapFactory.decodeFile((String)this.headUrl);
                }
                this.avatarView.setImageBitmap(this.headBitMap);
                this.avatarView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            }
        }
    }
}

