/*
 * Decompiled with CFR 0.152.
 */
package com.hypertrack.hyperlog;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.hypertrack.hyperlog.DeviceLogDatabaseHelper;
import com.hypertrack.hyperlog.DeviceLogList;
import com.hypertrack.hyperlog.DeviceLogModel;
import com.hypertrack.hyperlog.HTTPMultiPartPostRequest;
import com.hypertrack.hyperlog.HyperLogCallback;
import com.hypertrack.hyperlog.LogFormat;
import com.hypertrack.hyperlog.error.ErrorResponse;
import com.hypertrack.hyperlog.utils.DateTimeUtility;
import com.hypertrack.hyperlog.utils.Utils;
import com.hypertrack.hyperlog.utils.VolleyUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HyperLog {
    private static final String TAG = "HyperLog";
    private static int logLevel = 5;
    private static DeviceLogList mDeviceLogList;
    private static String URL;
    private static final int EXPIRY_TIME = 604800;
    private static LogFormat mLogFormat;

    public static void initialize(@NonNull Context context) {
        HyperLog.initialize(context, 604800, new LogFormat(context));
    }

    public static void initialize(@NonNull Context context, @NonNull LogFormat logFormat) {
        HyperLog.initialize(context, 604800, logFormat);
    }

    public static void initialize(@NonNull Context context, int expiryTimeInSeconds) {
        HyperLog.initialize(context, expiryTimeInSeconds, new LogFormat(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initialize(@NonNull Context context, int expiryTimeInSeconds, @NonNull LogFormat logFormat) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null.");
        }
        if (mDeviceLogList != null) return;
        Class<HyperLog> clazz = HyperLog.class;
        synchronized (HyperLog.class) {
            if (mDeviceLogList != null) return;
            mLogFormat = logFormat != null ? logFormat : new LogFormat(context);
            DeviceLogDatabaseHelper logDataSource = DeviceLogDatabaseHelper.getInstance(context);
            mDeviceLogList = new DeviceLogList(logDataSource);
            mDeviceLogList.clearOldLogs(expiryTimeInSeconds);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static void setLogFormat(@NonNull LogFormat logFormat) {
        if (mLogFormat != null) {
            mLogFormat = logFormat;
        }
    }

    private static boolean isInitialize() {
        if (mDeviceLogList == null) {
            HyperLog.e(TAG, "HyperLog isn't initialized.");
            return false;
        }
        return true;
    }

    public static void setURL(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            throw new IllegalArgumentException("API URL cannot be null or empty");
        }
        URL = url;
    }

    public static void setLogLevel(int logLevel) {
        HyperLog.logLevel = logLevel;
    }

    public static void v(String tag, String message, Throwable tr) {
        if (2 >= logLevel) {
            Log.v((String)tag, (String)(message + '\n' + Log.getStackTraceString((Throwable)tr)));
        }
    }

    public static void v(String tag, String message) {
        if (2 >= logLevel) {
            Log.v((String)tag, (String)message);
        }
    }

    public static void d(String tag, String message, Throwable tr) {
        if (3 >= logLevel) {
            Log.d((String)tag, (String)(message + '\n' + Log.getStackTraceString((Throwable)tr)));
        }
    }

    public static void d(String tag, String message) {
        if (3 >= logLevel) {
            Log.d((String)tag, (String)message);
        }
    }

    public static void i(String tag, String message, Throwable tr) {
        if (4 >= logLevel) {
            Log.i((String)tag, (String)(message + '\n' + Log.getStackTraceString((Throwable)tr)));
        }
        HyperLog.r(mLogFormat.formatLogMessage(4, message));
    }

    public static void i(String tag, String message) {
        HyperLog.i(tag, message, null);
    }

    public static void w(String tag, String message, Throwable tr) {
        if (5 >= logLevel) {
            Log.w((String)tag, (String)(message + '\n' + Log.getStackTraceString((Throwable)tr)));
        }
        HyperLog.r(mLogFormat.formatLogMessage(5, message));
    }

    public static void w(String tag, String message) {
        HyperLog.w(tag, message, null);
    }

    public static void e(String tag, String message, Throwable tr) {
        if (6 >= logLevel) {
            Log.e((String)tag, (String)(message + '\n' + Log.getStackTraceString((Throwable)tr)));
        }
        HyperLog.r(mLogFormat.formatLogMessage(6, message));
    }

    public static void e(String tag, String message) {
        HyperLog.e(tag, message, null);
    }

    public static void exception(String tag, String message, Throwable tr) {
        if (6 >= logLevel) {
            Log.e((String)tag, (String)"**********************************************");
            Log.e((String)tag, (String)("EXCEPTION: " + HyperLog.getMethodName() + ", " + message + '\n' + Log.getStackTraceString((Throwable)tr)));
            Log.e((String)tag, (String)"**********************************************");
        }
        HyperLog.r(mLogFormat.formatLogMessage(6, "EXCEPTION: " + HyperLog.getMethodName() + ", " + message));
    }

    public static void exception(String tag, String message) {
        HyperLog.exception(tag, message, null);
    }

    public static void exception(String tag, Exception e) {
        if (e == null) {
            return;
        }
        HyperLog.exception(tag, e.getMessage(), null);
    }

    public static void a(String message) {
        HyperLog.r(mLogFormat.formatLogMessage(7, message));
    }

    private static String getMethodName() {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        StackTraceElement e = stacktrace[1];
        return e.getMethodName();
    }

    private static void r(final String message) {
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!HyperLog.isInitialize()) {
                            return;
                        }
                        mDeviceLogList.addDeviceLog(message);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }).start();
        }
        catch (Exception | OutOfMemoryError e) {
            e.printStackTrace();
        }
    }

    public static List<DeviceLogModel> getDeviceLogs() {
        return HyperLog.getDeviceLogs(true);
    }

    public static List<DeviceLogModel> getDeviceLogs(boolean deleteLogs) {
        return HyperLog.getDeviceLogs(deleteLogs, 1);
    }

    public static List<DeviceLogModel> getDeviceLogs(boolean deleteLogs, int batchNo) {
        List<DeviceLogModel> deviceLogs = new ArrayList<DeviceLogModel>();
        if (!HyperLog.isInitialize()) {
            return deviceLogs;
        }
        deviceLogs = mDeviceLogList.getDeviceLogs(batchNo);
        if (deleteLogs) {
            mDeviceLogList.clearDeviceLogs(deviceLogs);
        }
        return deviceLogs;
    }

    public static List<String> getDeviceLogsAsStringList() {
        return HyperLog.getDeviceLogsAsStringList(true);
    }

    public static List<String> getDeviceLogsAsStringList(boolean deleteLogs) {
        return HyperLog.getDeviceLogsAsStringList(deleteLogs, 1);
    }

    public static List<String> getDeviceLogsAsStringList(boolean deleteLogs, int batchNo) {
        ArrayList<String> logsList = new ArrayList<String>();
        if (!HyperLog.isInitialize()) {
            return logsList;
        }
        if (!HyperLog.hasPendingDeviceLogs()) {
            return logsList;
        }
        return HyperLog.getDeviceLogsAsStringList(HyperLog.getDeviceLogs(deleteLogs, batchNo));
    }

    private static List<String> getDeviceLogsAsStringList(List<DeviceLogModel> deviceLogList) {
        ArrayList<String> logsList = new ArrayList<String>();
        if (deviceLogList == null) {
            return logsList;
        }
        for (DeviceLogModel deviceLog : deviceLogList) {
            logsList.add(deviceLog.getDeviceLog());
        }
        return logsList;
    }

    public static File getDeviceLogsInFile(Context mContext) {
        return HyperLog.getDeviceLogsInFile(mContext, null);
    }

    public static File getDeviceLogsInFile(Context mContext, boolean deleteLogs) {
        return HyperLog.getDeviceLogsInFile(mContext, null, deleteLogs);
    }

    public static File getDeviceLogsInFile(Context mContext, String fileName) {
        return HyperLog.getDeviceLogsInFile(mContext, fileName, true);
    }

    public static File getDeviceLogsInFile(Context mContext, String fileName, boolean deleteLogs) {
        if (!HyperLog.isInitialize()) {
            return null;
        }
        File file = null;
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            fileName = DateTimeUtility.getCurrentTime() + ".txt";
            fileName = fileName.replaceAll("[^a-zA-Z0-9_\\\\-\\\\.]", "_");
        }
        for (int logsBatchCount = HyperLog.getDeviceLogBatchCount(); logsBatchCount != 0; --logsBatchCount) {
            List<DeviceLogModel> deviceLogList = HyperLog.getDeviceLogs(deleteLogs);
            if (deviceLogList == null || deviceLogList.isEmpty() || (file = Utils.writeStringsToFile(mContext, HyperLog.getDeviceLogsAsStringList(deviceLogList), fileName)) == null) continue;
            if (deleteLogs) {
                mDeviceLogList.clearDeviceLogs(deviceLogList);
            }
            HyperLog.i(TAG, "Log File has been created at " + file.getAbsolutePath());
        }
        return file;
    }

    public static boolean hasPendingDeviceLogs() {
        if (!HyperLog.isInitialize()) {
            return false;
        }
        long deviceLogsCount = mDeviceLogList.count();
        return deviceLogsCount > 0L;
    }

    public static long logCount() {
        if (!HyperLog.isInitialize()) {
            return 0L;
        }
        return mDeviceLogList.count();
    }

    public static int getDeviceLogBatchCount() {
        if (!HyperLog.isInitialize()) {
            return 0;
        }
        return mDeviceLogList.getDeviceLogBatchCount();
    }

    public static void pushLogs(Context mContext, boolean compress, HyperLogCallback callback) {
        HyperLog.pushLogs(mContext, null, null, compress, callback);
    }

    public static void pushLogs(Context mContext, String fileName, boolean compress, HyperLogCallback callback) {
        HyperLog.pushLogs(mContext, fileName, null, compress, callback);
    }

    public static void pushLogs(Context mContext, HashMap<String, String> additionalHeaders, boolean compress, HyperLogCallback callback) {
        HyperLog.pushLogs(mContext, null, additionalHeaders, compress, callback);
    }

    public static void pushLogs(Context mContext, String fileName, HashMap<String, String> additionalHeaders, boolean compress, final HyperLogCallback callback) {
        int logsBatchCount;
        if (!HyperLog.isInitialize()) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)URL)) {
            throw new IllegalArgumentException("API endpoint URL is missing. Set URL using HyperLog.setURL method");
        }
        VolleyUtils.cancelPendingRequests(mContext, TAG);
        if (TextUtils.isEmpty((CharSequence)URL)) {
            HyperLog.e(TAG, "URL is missing. Please set the URL to push the logs.");
            return;
        }
        if (!HyperLog.hasPendingDeviceLogs()) {
            return;
        }
        final int[] temp = new int[]{logsBatchCount};
        final boolean[] isAllLogsPushed = new boolean[]{true};
        for (logsBatchCount = HyperLog.getDeviceLogBatchCount(); logsBatchCount != 0; --logsBatchCount) {
            final List<DeviceLogModel> deviceLogs = HyperLog.getDeviceLogs(false, logsBatchCount);
            deviceLogs.add(new DeviceLogModel(mLogFormat.formatLogMessage(4, "Log Counts: " + deviceLogs.size() + " | File Size: " + deviceLogs.toString().length() + " bytes.")));
            byte[] bytes = Utils.getByteData(deviceLogs);
            if (TextUtils.isEmpty((CharSequence)fileName)) {
                fileName = DateTimeUtility.getCurrentTime() + ".txt";
            }
            HTTPMultiPartPostRequest<String> httpMultiPartPostRequest = new HTTPMultiPartPostRequest<String>(URL, bytes, fileName, additionalHeaders, mContext, String.class, compress, new Response.Listener<String>(){

                public void onResponse(String response) {
                    temp[0] = temp[0] - 1;
                    mDeviceLogList.clearDeviceLogs(deviceLogs);
                    HyperLog.i(HyperLog.TAG, "Log has been pushed");
                    if (callback != null && temp[0] == 0) {
                        if (isAllLogsPushed[0]) {
                            callback.onSuccess(response);
                        } else {
                            ErrorResponse errorResponse = new ErrorResponse("All logs hasn't been pushed");
                            callback.onError(errorResponse);
                        }
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorResponse errorResponse = new ErrorResponse(error);
                    isAllLogsPushed[0] = false;
                    temp[0] = temp[0] - 1;
                    error.printStackTrace();
                    HyperLog.exception(HyperLog.TAG, "Error has occurred while pushing logs: ", (Throwable)error);
                    if (temp[0] == 0 && callback != null) {
                        callback.onError(errorResponse);
                    }
                }
            });
            VolleyUtils.addToRequestQueue(mContext, httpMultiPartPostRequest, TAG);
        }
    }

    public static void deleteLogs() {
        if (!HyperLog.isInitialize()) {
            return;
        }
        mDeviceLogList.clearSavedDeviceLogs();
    }
}

