/*
 * Decompiled with CFR 0.152.
 */
package com.hypertrack.hyperlog;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.hypertrack.hyperlog.DeviceLogModel;
import com.hypertrack.hyperlog.HyperLog;
import com.hypertrack.hyperlog.utils.DateTimeUtility;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

class DeviceLogTable {
    private static final String TAG = DeviceLogTable.class.getSimpleName();
    private static final int DEVICE_LOG_REQUEST_QUERY_LIMIT = 5000;
    private static final String TABLE_NAME = "device_logs";
    private static final String COLUMN_ID = "_id";
    private static final String COLUMN_DEVICE_LOG = "device_log";
    private static final String DATABASE_CREATE = "CREATE TABLE IF NOT EXISTS device_logs (_id INTEGER PRIMARY KEY AUTOINCREMENT, device_log TEXT);";

    DeviceLogTable() {
    }

    static void onCreate(SQLiteDatabase db) {
        if (db == null) {
            return;
        }
        try {
            db.execSQL(DATABASE_CREATE);
        }
        catch (Exception e) {
            e.printStackTrace();
            HyperLog.e(TAG, "DeviceLogTable: Exception occurred while onCreate: " + e);
        }
    }

    static void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (db == null) {
            return;
        }
        try {
            db.execSQL("DROP TABLE IF EXISTS device_logs");
            DeviceLogTable.onCreate(db);
            HyperLog.i(TAG, "DeviceLogTable onUpgrade called. Executing drop_table query to clear old logs.");
        }
        catch (Exception e) {
            e.printStackTrace();
            HyperLog.e(TAG, "DeviceLogTable: Exception occurred while onUpgrade: " + e);
        }
    }

    static long getCount(SQLiteDatabase db) {
        try {
            if (db == null) {
                return 0L;
            }
            return DatabaseUtils.queryNumEntries((SQLiteDatabase)db, (String)TABLE_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
            HyperLog.e(TAG, "DeviceLogTable: Exception occurred while getCount: " + e);
            return 0L;
        }
    }

    static int getDeviceLogBatchCount(SQLiteDatabase db) {
        try {
            if (db == null) {
                return 0;
            }
            return (int)Math.ceil((float)DeviceLogTable.getCount(db) * 1.0f / 5000.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
            HyperLog.e(TAG, "DeviceLogTable: Exception occurred while getDeviceLogBatchCount: " + e);
            return 0;
        }
    }

    static void addDeviceLog(SQLiteDatabase db, String deviceLog) {
        if (db == null || TextUtils.isEmpty((CharSequence)deviceLog)) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put(COLUMN_DEVICE_LOG, deviceLog);
        try {
            db.insert(TABLE_NAME, null, contentValues);
        }
        catch (Exception e) {
            e.printStackTrace();
            HyperLog.e(TAG, "DeviceLogTable: Exception occurred while addDeviceLog: " + e);
        }
    }

    static void deleteDeviceLog(SQLiteDatabase db, List<DeviceLogModel> deviceLogList) {
        if (db == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (DeviceLogModel deviceLog : deviceLogList) {
            if (deviceLog == null || deviceLog.getId() <= 0) continue;
            builder.append(deviceLog.getId()).append(",");
        }
        if (builder.length() == 0) {
            return;
        }
        try {
            String ids = builder.toString();
            ids = ids.substring(0, ids.length() - 1);
            String whereClause = "_id IN (" + ids + ")";
            db.delete(TABLE_NAME, whereClause, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            HyperLog.e(TAG, "DeviceLogTable: Exception occurred while deleteDeviceLog: " + e);
        }
    }

    static void deleteAllDeviceLogs(SQLiteDatabase db) {
        if (db == null) {
            return;
        }
        try {
            db.delete(TABLE_NAME, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            HyperLog.e(TAG, "DeviceLogTable: Exception occurred while deleteAllDeviceLogs: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<DeviceLogModel> getDeviceLogs(SQLiteDatabase db, int batch) {
        ArrayList<DeviceLogModel> deviceLogList;
        block10: {
            if (db == null) {
                return null;
            }
            int count = DeviceLogTable.getDeviceLogBatchCount(db);
            if (count <= 1 || --batch < 0) {
                batch = 0;
            }
            deviceLogList = null;
            String limit = String.valueOf(batch * 5000) + ", " + String.valueOf(5000);
            Cursor cursor = db.query(TABLE_NAME, new String[]{COLUMN_ID, COLUMN_DEVICE_LOG}, null, null, null, null, null, limit);
            if (cursor == null || cursor.isClosed()) {
                return null;
            }
            try {
                if (!cursor.moveToFirst()) break block10;
                deviceLogList = new ArrayList<DeviceLogModel>();
                do {
                    if (cursor.isClosed()) {
                        break;
                    }
                    String deviceLogString = cursor.getString(1);
                    if (TextUtils.isEmpty((CharSequence)deviceLogString)) continue;
                    DeviceLogModel deviceLog = new DeviceLogModel(deviceLogString);
                    Integer rowId = Integer.valueOf(cursor.getString(0));
                    deviceLog.setId(rowId != null ? rowId : 0);
                    deviceLogList.add(deviceLog);
                } while (cursor.moveToNext());
            }
            catch (Exception e) {
                e.printStackTrace();
                HyperLog.e(TAG, "DeviceLogTable: Exception occurred while getDeviceLogs: " + e);
            }
            finally {
                cursor.close();
            }
        }
        return deviceLogList;
    }

    public static void clearOldLogs(SQLiteDatabase db, int expiryTimeInSeconds) {
        if (db == null) {
            return;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.add(13, -expiryTimeInSeconds);
            String date = DateTimeUtility.getFormattedTime(calendar.getTime());
            db.delete(TABLE_NAME, "device_log<?", new String[]{date});
        }
        catch (Exception e) {
            e.printStackTrace();
            HyperLog.e(TAG, "DeviceLogTable: Exception occurred while deleteAllDeviceLogs: " + e);
        }
    }
}

