/*
 * Decompiled with CFR 0.152.
 */
package com.hypertrack.hyperlog;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import com.hypertrack.hyperlog.utils.HLDateTimeUtility;
import java.io.Serializable;

public class LogFormat
implements Serializable {
    private String deviceUUID;

    public LogFormat(Context context) {
        Context mContext = context.getApplicationContext();
        this.deviceUUID = Settings.Secure.getString((ContentResolver)mContext.getContentResolver(), (String)"android_id");
    }

    String formatLogMessage(int logLevel, String tag, String message) {
        String timeStamp = HLDateTimeUtility.getCurrentTime();
        String senderName = "1.0";
        String osVersion = "Android-" + Build.VERSION.RELEASE;
        String logLevelName = LogFormat.getLogLevelName(logLevel);
        return this.getFormattedLogMessage(logLevelName, tag, message, timeStamp, senderName, osVersion, this.deviceUUID);
    }

    public String getFormattedLogMessage(String logLevelName, String tag, String message, String timeStamp, String senderName, String osVersion, String deviceUUID) {
        if (deviceUUID == null) {
            deviceUUID = "DeviceUUID";
        }
        return timeStamp + " | " + senderName + " : " + osVersion + " | " + deviceUUID + " | [" + logLevelName + "/" + tag + "]: " + message;
    }

    private static String getLogLevelName(int messageLogLevel) {
        String logLevelName;
        switch (messageLogLevel) {
            case 2: {
                logLevelName = "VERBOSE";
                break;
            }
            case 3: {
                logLevelName = "DEBUG";
                break;
            }
            case 4: {
                logLevelName = "INFO";
                break;
            }
            case 5: {
                logLevelName = "WARN";
                break;
            }
            case 6: {
                logLevelName = "ERROR";
                break;
            }
            case 7: {
                logLevelName = "ASSERT";
                break;
            }
            default: {
                logLevelName = "NONE";
            }
        }
        return logLevelName;
    }
}

