/*
 * Decompiled with CFR 0.152.
 */
package com.hypertrack.hyperlog.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.text.TextUtils;
import com.hypertrack.hyperlog.DeviceLogModel;
import com.hypertrack.hyperlog.HyperLog;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class Utils {
    private static final double MEGA = Math.pow(1024.0, 2.0);

    public static File writeStringsToFile(Context context, List<String> data, String fileName) {
        try {
            String dirPath = context.getExternalFilesDir(null).getAbsolutePath() + "/LogFiles";
            if (TextUtils.isEmpty((CharSequence)dirPath)) {
                HyperLog.e("ContentValues", "Error occurred while getting directory");
                return null;
            }
            File filePath = new File(dirPath);
            if (!filePath.exists() && !filePath.mkdirs()) {
                HyperLog.e("ContentValues", "Error occurred while creating file.");
                return null;
            }
            File logFile = new File(filePath, fileName);
            FileWriter writer = new FileWriter(logFile, true);
            BufferedWriter bufferedWriter = new BufferedWriter(writer, 4 * (int)MEGA);
            Utils.write(data, bufferedWriter);
            return logFile;
        }
        catch (Exception e) {
            HyperLog.exception("ContentValues", e);
            return null;
        }
    }

    private static void write(List<String> records, Writer writer) throws IOException {
        for (String record : records) {
            writer.write(record + "\n");
        }
        writer.flush();
        writer.close();
    }

    public static String getDeviceId(Context context) {
        String device_uuid = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return device_uuid != null ? device_uuid : "";
    }

    public static byte[] getByteData(List<DeviceLogModel> deviceLogs) {
        StringBuilder stringBuilder = new StringBuilder();
        for (DeviceLogModel deviceLog : deviceLogs) {
            stringBuilder.append(deviceLog.getDeviceLog()).append("\n");
        }
        return stringBuilder.toString().getBytes();
    }
}

