/*
 * Decompiled with CFR 0.152.
 */
package com.hypertrack.hyperlog;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.hypertrack.hyperlog.DeviceLogDataSource;
import com.hypertrack.hyperlog.DeviceLogModel;
import com.hypertrack.hyperlog.DeviceLogTable;
import com.hypertrack.hyperlog.HyperLog;
import java.util.List;

class DeviceLogDatabaseHelper
extends SQLiteOpenHelper
implements DeviceLogDataSource {
    private static final String TAG = DeviceLogDatabaseHelper.class.getSimpleName();
    private static final String DATABASE_NAME = "com.hypertrack.common.device_logs.db";
    private static final int DATABASE_VERSION = 2;
    private static DeviceLogDatabaseHelper deviceLogDatabaseHelper;
    private SQLiteDatabase database;

    private DeviceLogDatabaseHelper(Context context) {
        super(context, DATABASE_NAME, null, 2);
        this.initializeDatabase();
    }

    private void initializeDatabase() {
        if (this.database == null) {
            this.database = this.getWritableDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static DeviceLogDatabaseHelper getInstance(Context context) {
        if (deviceLogDatabaseHelper != null) return deviceLogDatabaseHelper;
        Class<DeviceLogDatabaseHelper> clazz = DeviceLogDatabaseHelper.class;
        synchronized (DeviceLogDatabaseHelper.class) {
            if (deviceLogDatabaseHelper != null) return deviceLogDatabaseHelper;
            deviceLogDatabaseHelper = new DeviceLogDatabaseHelper(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return deviceLogDatabaseHelper;
        }
    }

    public void onCreate(SQLiteDatabase db) {
        DeviceLogTable.onCreate(db);
        HyperLog.i(TAG, "DeviceLogDatabaseHelper onCreate called.");
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        DeviceLogTable.onUpgrade(db, oldVersion, newVersion);
        HyperLog.i(TAG, "DeviceLogDatabaseHelper onUpgrade called.");
    }

    @Override
    public long getDeviceLogCount() {
        this.initializeDatabase();
        return DeviceLogTable.getCount(this.database);
    }

    @Override
    public void addDeviceLog(String deviceLog) {
        this.initializeDatabase();
        DeviceLogTable.addDeviceLog(this.database, deviceLog);
    }

    @Override
    public void deleteDeviceLog(List<DeviceLogModel> deviceLogList) {
        this.initializeDatabase();
        DeviceLogTable.deleteDeviceLog(this.database, deviceLogList);
    }

    @Override
    public void deleteAllDeviceLogs() {
        this.initializeDatabase();
        DeviceLogTable.deleteAllDeviceLogs(this.database);
    }

    @Override
    public List<DeviceLogModel> getDeviceLogs(int batch) {
        this.initializeDatabase();
        List<DeviceLogModel> deviceLogList = null;
        try {
            deviceLogList = DeviceLogTable.getDeviceLogs(this.database, batch);
        }
        catch (Exception | OutOfMemoryError e) {
            e.printStackTrace();
        }
        return deviceLogList;
    }

    @Override
    public int getDeviceLogBatchCount() {
        this.initializeDatabase();
        return DeviceLogTable.getDeviceLogBatchCount(this.database);
    }

    @Override
    public void clearOldLogs(int expiryTimeInSeconds) {
        this.initializeDatabase();
        DeviceLogTable.clearOldLogs(this.database, expiryTimeInSeconds);
    }
}

