/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import org.bson.BsonNumber;
import org.bson.BsonType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BsonDouble
extends BsonNumber
implements Comparable<BsonDouble> {
    private final double value;

    public BsonDouble(double value) {
        this.value = value;
    }

    @Override
    public int compareTo(BsonDouble o) {
        return Double.compare(this.value, o.value);
    }

    @Override
    public BsonType getBsonType() {
        return BsonType.DOUBLE;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BsonDouble that = (BsonDouble)o;
        return Double.compare(that.value, this.value) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.value);
        return (int)(temp ^ temp >>> 32);
    }

    public String toString() {
        return "BsonDouble{value=" + this.value + '}';
    }
}

