/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import org.bson.AbstractBsonWriter;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonContextType;
import org.bson.BsonDateTime;
import org.bson.BsonDbPointer;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonJavaScript;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonSymbol;
import org.bson.BsonTimestamp;
import org.bson.BsonUndefined;
import org.bson.BsonValue;
import org.bson.BsonWriterSettings;
import org.bson.types.ObjectId;

class BsonArrayWriter
extends AbstractBsonWriter {
    private final BsonArray bsonArray;

    public BsonArrayWriter(BsonArray bsonArray) {
        super(new BsonWriterSettings());
        this.bsonArray = bsonArray;
        this.setContext(new Context());
    }

    public BsonArray getArray() {
        return this.bsonArray;
    }

    protected void doWriteStartDocument() {
        switch (this.getState()) {
            case INITIAL: {
                this.setContext(new Context(new BsonDocument(), BsonContextType.DOCUMENT, this.getContext()));
                break;
            }
            case VALUE: {
                this.setContext(new Context(new BsonDocument(), BsonContextType.DOCUMENT, this.getContext()));
                break;
            }
            case SCOPE_DOCUMENT: {
                this.setContext(new Context(new BsonDocument(), BsonContextType.SCOPE_DOCUMENT, this.getContext()));
                break;
            }
            default: {
                throw new BsonInvalidOperationException("Unexpected state " + (Object)((Object)this.getState()));
            }
        }
    }

    protected void doWriteEndDocument() {
        BsonValue value = this.getContext().container;
        this.setContext(this.getContext().getParentContext());
        if (this.getContext().getContextType() == BsonContextType.JAVASCRIPT_WITH_SCOPE) {
            BsonDocument scope = (BsonDocument)value;
            BsonString code = (BsonString)this.getContext().container;
            this.setContext(this.getContext().getParentContext());
            this.write(new BsonJavaScriptWithScope(code.getValue(), scope));
        } else if (this.getContext().getContextType() != BsonContextType.TOP_LEVEL) {
            this.write(value);
        }
    }

    protected void doWriteStartArray() {
        this.setContext(new Context(this.bsonArray, BsonContextType.ARRAY, this.getContext()));
    }

    protected void doWriteEndArray() {
        BsonValue array = this.getContext().container;
        this.setContext(this.getContext().getParentContext());
        this.write(array);
    }

    protected void doWriteBinaryData(BsonBinary value) {
        this.write(value);
    }

    public void doWriteBoolean(boolean value) {
        this.write(BsonBoolean.valueOf(value));
    }

    protected void doWriteDateTime(long value) {
        this.write(new BsonDateTime(value));
    }

    protected void doWriteDBPointer(BsonDbPointer value) {
        this.write(value);
    }

    protected void doWriteDouble(double value) {
        this.write(new BsonDouble(value));
    }

    protected void doWriteInt32(int value) {
        this.write(new BsonInt32(value));
    }

    protected void doWriteInt64(long value) {
        this.write(new BsonInt64(value));
    }

    protected void doWriteJavaScript(String value) {
        this.write(new BsonJavaScript(value));
    }

    protected void doWriteJavaScriptWithScope(String value) {
        this.setContext(new Context(new BsonString(value), BsonContextType.JAVASCRIPT_WITH_SCOPE, this.getContext()));
    }

    protected void doWriteMaxKey() {
        this.write(new BsonMaxKey());
    }

    protected void doWriteMinKey() {
        this.write(new BsonMinKey());
    }

    public void doWriteNull() {
        this.write(BsonNull.VALUE);
    }

    public void doWriteObjectId(ObjectId value) {
        this.write(new BsonObjectId(value));
    }

    public void doWriteRegularExpression(BsonRegularExpression value) {
        this.write(value);
    }

    public void doWriteString(String value) {
        this.write(new BsonString(value));
    }

    public void doWriteSymbol(String value) {
        this.write(new BsonSymbol(value));
    }

    public void doWriteTimestamp(BsonTimestamp value) {
        this.write(value);
    }

    public void doWriteUndefined() {
        this.write(new BsonUndefined());
    }

    public void flush() {
    }

    protected Context getContext() {
        return (Context)super.getContext();
    }

    private void write(BsonValue value) {
        this.getContext().add(value);
    }

    private class Context
    extends AbstractBsonWriter.Context {
        private BsonValue container;

        public Context(BsonValue container, BsonContextType contextType, Context parent) {
            super(BsonArrayWriter.this, parent, contextType);
            this.container = container;
        }

        public Context() {
            super(BsonArrayWriter.this, null, BsonContextType.TOP_LEVEL);
        }

        void add(BsonValue value) {
            if (this.container instanceof BsonArray) {
                ((BsonArray)this.container).add(value);
            } else {
                ((BsonDocument)this.container).put(BsonArrayWriter.this.getName(), value);
            }
        }
    }
}

