/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.management;

import com.mongodb.annotations.Beta;
import com.mongodb.connection.ServerId;
import com.mongodb.event.ConnectionEvent;
import com.mongodb.event.ConnectionPoolEvent;
import com.mongodb.event.ConnectionPoolListener;
import com.mongodb.event.ConnectionPoolOpenedEvent;
import com.mongodb.event.ConnectionPoolWaitQueueEvent;
import com.mongodb.management.ConnectionPoolStatistics;
import com.mongodb.management.ConnectionPoolStatisticsMBean;
import com.mongodb.management.MBeanServerFactory;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.ObjectName;

@Beta
public class JMXConnectionPoolListener
implements ConnectionPoolListener {
    private final ConcurrentMap<ServerId, ConnectionPoolStatistics> map = new ConcurrentHashMap<ServerId, ConnectionPoolStatistics>();

    public void connectionPoolOpened(ConnectionPoolOpenedEvent event) {
        ConnectionPoolStatistics statistics = new ConnectionPoolStatistics(event);
        this.map.put(event.getServerId(), statistics);
        MBeanServerFactory.getMBeanServer().registerMBean(statistics, this.getMBeanObjectName(event.getServerId()));
    }

    public void connectionPoolClosed(ConnectionPoolEvent event) {
        this.map.remove(event.getServerId());
        MBeanServerFactory.getMBeanServer().unregisterMBean(this.getMBeanObjectName(event.getServerId()));
    }

    public void connectionCheckedOut(ConnectionEvent event) {
        ConnectionPoolStatistics statistics = this.getStatistics(event);
        if (statistics != null) {
            statistics.connectionCheckedOut(event);
        }
    }

    public void connectionCheckedIn(ConnectionEvent event) {
        ConnectionPoolStatistics statistics = this.getStatistics(event);
        if (statistics != null) {
            statistics.connectionCheckedIn(event);
        }
    }

    public void waitQueueEntered(ConnectionPoolWaitQueueEvent event) {
        ConnectionPoolListener statistics = this.getStatistics(event);
        if (statistics != null) {
            statistics.waitQueueEntered(event);
        }
    }

    public void waitQueueExited(ConnectionPoolWaitQueueEvent event) {
        ConnectionPoolListener statistics = this.getStatistics(event);
        if (statistics != null) {
            statistics.waitQueueExited(event);
        }
    }

    public void connectionAdded(ConnectionEvent event) {
        ConnectionPoolStatistics statistics = this.getStatistics(event);
        if (statistics != null) {
            statistics.connectionAdded(event);
        }
    }

    public void connectionRemoved(ConnectionEvent event) {
        ConnectionPoolStatistics statistics = this.getStatistics(event);
        if (statistics != null) {
            statistics.connectionRemoved(event);
        }
    }

    String getMBeanObjectName(ServerId serverId) {
        String name = String.format("org.mongodb.driver:type=ConnectionPool,clusterId=%s,host=%s,port=%s", this.ensureValidValue(serverId.getClusterId().getValue()), this.ensureValidValue(serverId.getAddress().getHost()), serverId.getAddress().getPort());
        if (serverId.getClusterId().getDescription() != null) {
            name = String.format("%s,description=%s", name, this.ensureValidValue(serverId.getClusterId().getDescription()));
        }
        return name;
    }

    ConnectionPoolStatisticsMBean getMBean(ServerId serverId) {
        return this.getStatistics(serverId);
    }

    private ConnectionPoolStatistics getStatistics(ConnectionEvent event) {
        return this.getStatistics(event.getConnectionId().getServerId());
    }

    private ConnectionPoolListener getStatistics(ConnectionPoolEvent event) {
        return this.getStatistics(event.getServerId());
    }

    private ConnectionPoolStatistics getStatistics(ServerId serverId) {
        return (ConnectionPoolStatistics)this.map.get(serverId);
    }

    private String ensureValidValue(String value) {
        if (this.containsQuotableCharacter(value)) {
            return ObjectName.quote(value);
        }
        return value;
    }

    private boolean containsQuotableCharacter(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        List<String> quoteableCharacters = Arrays.asList(",", ":", "?", "*", "=", "\"", "\\", "\n");
        for (String quotable : quoteableCharacters) {
            if (!value.contains(quotable)) continue;
            return true;
        }
        return false;
    }
}

